@echo off

rem The invocation by the launcher does not provide for interaction
rem via std[in|out|err].

setlocal enableextensions

rem Additional configuration for TL- and non-TL programs.

rem -----------------------------------------------------------
rem PREPARATIONS
rem -----------------------------------------------------------

rem %TLCONFIG% gets the value specified in tlaunch.ini.
rem %TLROOT% and %VERSION% are also set by the launcher
rem before invoking this script.

rem Set TLEXTRAS and its subdirectory TLSCRIPTS
rem Hard-coding in terms of %TLROOT% is an option,
rem but that can sometimes be avoided:

rem scripts directory contains this batchfile
set TLSCRIPTS=%~dp0
rem includes final backslash

rem TLEXTRAS is its parent.
for %%I in ("%~dp0..") do set "TLEXTRAS=%%~fI"
rem without final backslash

rem user directory for config files, scripts and programs
if not exist "%TLCONFIG%" md "%TLCONFIG%"

path %tlroot%\bin\win32;%systemroot%\system32;%path%

rem TEXMFVAR & TEXMFCONFIG, calculated with batch version of backquoting

for /f "usebackq tokens=*" %%I in (`kpsewhich -var-value=TEXMFVAR`) do set TEXMFVAR=%%I
set TEXMFVAR=%TEXMFVAR:/=\%
for /f "usebackq tokens=*" %%I in (`kpsewhich -var-value=TEXMFCONFIG`) do set TEXMFCONFIG=%%I
set TEXMFCONFIG=%TEXMFCONFIG:/=\%

rem -----------------------------------------------------------
rem   SUMATRAPDF: STORE INSTALL LOCATION IN HKCU REGISTRY HIVE
rem   THIS CAUSES SUMATRAPDF TO STORE PER-USER PREFERENCES IN USER PROFILE
rem -----------------------------------------------------------

reg add HKCU\software\microsoft\windows\currentversion\uninstall\SumatraPDF\ /v InstallLocation /d "%TLEXTRAS%\SumatraPDF" /f

rem disable checking for updates

if exist "%appdata%\SumatraPDF\SumatraPDF-settings.txt" "%tlroot%\tlpkg\tlperl\bin\perl.exe" -pi".orig" -e "s/CheckForUpdates = true/CheckForUpdates = false/" "%appdata%\SumatraPDF\SumatraPDF-settings.txt"
if not exist "%appdata%\SumatraPDF\SumatraPDF-settings.txt" (
  md "%appdata%\SumatraPDF"
  echo CheckForUpdates = false >"%appdata%\SumatraPDF\SumatraPDF-settings.txt"
)

rem -----------------------------------------------------------
rem   TEXNICCENTER: CONFIGURE BUILD PROFILES
rem -----------------------------------------------------------

cscript "%TLSCRIPTS%tnc_config.vbs" "%tlroot%"

rem -----------------------------------------------------------
rem   LYX: COPY PRE-GENERATED CONFIGURATION DATA TO CUSTOM CONFIGURATION DIRECTORY
rem -----------------------------------------------------------

if not exist "%tlconfig%\TLR.LyX2.2" md "%tlconfig%\TLR.LyX2.2"
xcopy "%TLEXTRAS%\TLR.LyX2.2.user\*.*" "%tlconfig%\TLR.LyX2.2\" /c /q /s /e /r /y


rem -----------------------------------------------------------
rem   TEXSTUDIO: disable checking for updates
rem -----------------------------------------------------------

if exist "%appdata%\texstudio\texstudio.ini" "%tlroot%\tlpkg\tlperl\bin\perl.exe" -pi".orig" -e "s/AutoCheck=true/AutoCheck=false/" "%appdata%\texstudio\texstudio.ini"
if not exist "%appdata%\texstudio\texstudio.ini" (
  md "%appdata%\texstudio"
  echo [texmaker] >"%appdata%\texstudio\texstudio.ini"
  echo Update\AutoCheck=false >>"%appdata%\texstudio\texstudio.ini"
)

rem -----------------------------------------------------------
rem   TEXWORKS: COPY TEXSTUDIO SPELLING DICTIONARIES
rem -----------------------------------------------------------

if not exist "%TEXMFCONFIG%\texworks\dictionaries" md "%TEXMFCONFIG%\texworks\dictionaries"
copy /b /y "%TLEXTRAS%\TeXstudio\dictionaries\*.aff" "%TEXMFCONFIG%\texworks\dictionaries\*.*"
copy /b /y "%TLEXTRAS%\TeXstudio\dictionaries\*.dic" "%TEXMFCONFIG%\texworks\dictionaries\*.*"

rem -----------------------------------------------------------
rem   FONT CONFIGURATION FOR XETEX
rem -----------------------------------------------------------

rem xetex.pl from release 2016 has extra parameter to postpone cache generation
rem until needed or explicitly requested
echo "%tlroot%\tlpkg\tlperl\bin\perl.exe" "%tlroot%\tlpkg\tlpostcode\xetex.pl" install "%tlroot%" skip_gen 3>NUL
"%tlroot%\tlpkg\tlperl\bin\perl.exe" "%tlroot%\tlpkg\tlpostcode\xetex.pl" install "%tlroot%" skip_gen 3>NUL

rem -----------------------------------------------------------
rem   PRE_FORGET.CMD
rem -----------------------------------------------------------

echo copy /y "%TLSCRIPTS%pre_forget.cmd" "%tlconfig%"
copy /y "%TLSCRIPTS%pre_forget.cmd" "%tlconfig%"

endlocal

echo Done with post_config

exit 0
