/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.util.Matrix;

public abstract class ShadingContext {
    private static final Log LOG = LogFactory.getLog(ShadingContext.class);
    protected final PDShadingResources shading;
    protected final Rectangle deviceBounds;
    protected ColorSpace shadingColorSpace;
    protected PDColorSpace colorSpace;
    protected PDRectangle bboxRect;
    protected float minBBoxX;
    protected float minBBoxY;
    protected float maxBBoxX;
    protected float maxBBoxY;
    protected ColorModel outputColorModel;
    protected PDFunction shadingTinttransform;

    public ShadingContext(PDShadingResources shading, ColorModel cm, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        this.shading = shading;
        this.deviceBounds = dBounds;
        this.colorSpace = shading.getColorSpace();
        try {
            if (!(this.colorSpace instanceof PDDeviceRGB)) {
                this.shadingColorSpace = this.colorSpace.getJavaColorSpace();
                if (this.colorSpace instanceof PDDeviceN) {
                    this.shadingTinttransform = ((PDDeviceN)this.colorSpace).getTintTransform();
                } else if (this.colorSpace instanceof PDSeparation) {
                    this.shadingTinttransform = ((PDSeparation)this.colorSpace).getTintTransform();
                }
            }
        }
        catch (IOException exception) {
            LOG.error((Object)"error while creating colorSpace", (Throwable)exception);
        }
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        this.outputColorModel = new ComponentColorModel(outputCS, true, false, 3, 0);
        this.bboxRect = shading.getBBox();
        if (this.bboxRect != null) {
            this.transformBBox(ctm, xform, pageHeight);
        }
    }

    private void transformBBox(Matrix ctm, AffineTransform xform, int pageHeight) {
        float[] bboxTab = new float[]{this.bboxRect.getLowerLeftX(), this.bboxRect.getLowerLeftY(), this.bboxRect.getUpperRightX(), this.bboxRect.getUpperRightY()};
        if (ctm != null) {
            ctm.createAffineTransform().transform(bboxTab, 0, bboxTab, 0, 2);
            bboxTab[1] = (float)pageHeight - bboxTab[1];
            bboxTab[3] = (float)pageHeight - bboxTab[3];
        } else {
            float translateY = (float)xform.getTranslateY();
            bboxTab[1] = (float)pageHeight + translateY - bboxTab[1];
            bboxTab[3] = (float)pageHeight + translateY - bboxTab[3];
        }
        xform.transform(bboxTab, 0, bboxTab, 0, 2);
        this.minBBoxX = Math.min(bboxTab[0], bboxTab[2]);
        this.minBBoxY = Math.min(bboxTab[1], bboxTab[3]);
        this.maxBBoxX = Math.max(bboxTab[0], bboxTab[2]);
        this.maxBBoxY = Math.max(bboxTab[1], bboxTab[3]);
        if (this.minBBoxX >= this.maxBBoxX || this.minBBoxY >= this.maxBBoxY) {
            LOG.warn((Object)"empty BBox is ignored");
            this.bboxRect = null;
        }
    }

    protected int convertToRGB(float[] values) {
        int normRGBValues = 0;
        if (this.shadingColorSpace != null) {
            if (this.shadingTinttransform != null) {
                try {
                    values = this.shadingTinttransform.eval(values);
                }
                catch (IOException exception) {
                    LOG.error((Object)"error while processing a function", (Throwable)exception);
                }
            }
            values = this.shadingColorSpace.toRGB(values);
        }
        normRGBValues = (int)(values[0] * 255.0f);
        normRGBValues |= (int)(values[1] * 255.0f) << 8;
        return normRGBValues |= (int)(values[2] * 255.0f) << 16;
    }

    public PDFunction getShadingTintTransform() {
        return this.shadingTinttransform;
    }
}

