---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices
---

# Comment utiliser des petites capitales grasses avec <ctanpkg:lmodern> ?

La méta-famille de fontes *Latin Modern* remplace *Computer Modern* comme fontes standard. 
Sous LaTeX, on la charge en appelant l'extension <ctanpkg:lmodern>. 
Elle souffre néanmoins d'un défaut, celui de ne pas être aussi complète que *Computer Modern* : 
il manque par exemple les petites capitales grasses en famille romaine. 
L'objet de cette astuce est d'y remédier en allant chercher les fontes manquantes 
dans *Computer Modern*.

```{noedit}
\rmfamily
\DeclareFontShape{T1}{lmr}{b}{sc}{<->ssub*cmr/bx/sc}{}
\DeclareFontShape{T1}{lmr}{bx}{sc}{<->ssub*cmr/bx/sc}{}
```

Le code précédent demande à LaTeX de substituer aux petites capitales (`sc`) grasses (`b`) 
ou grasses étendues (`bx`) de *Latin Modern Roman* (`lmr`) 
les petites capitales grasses étendues de *Computer Modern Roman* (`cmr`). 
Si vous utilisez la variante `sub` au lieu de `ssub`, 
LaTeX émettra un avertissement avant d'opérer la substitution. 
Enfin, `\rmfamily` sert à s'assurer que les commandes qui vont être modifiées 
par les deux lignes suivantes sont préalablement crées.

Notez que cette méthode est contestable dans le sens où elle mélange allègrement 
deux familles de fontes. Cependant, vu la proximité entre *Computer Modern Roman* 
et *Latin Modern Roman*, ce mélange semble assez légitime ici 
et constitue la moins mauvaise solution. 
Il convient de surveiller l'évolution de *Latin Modern* 
pour ne plus utiliser cette substitution dès qu'elle ne sera plus utile.

:::{sources}
[Quelques substitution de fontes utiles](https://www.elzevir.fr/imj/latex/tips.html#lmsub), 
par Manuel Pégourié-Gonnard
:::