/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public abstract class ControlSequence
extends Macro {
    protected String name;

    public ControlSequence(String string) {
        this(string, true);
    }

    public ControlSequence(String string, boolean bl) {
        this.setName(string);
        this.setShort(bl);
    }

    @Override
    public abstract Object clone();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,prefix=%d,canExpand=%s,syntax=%s]", this.getClass().getSimpleName(), this.getName(), this.getPrefix(), this.canExpand(), this.getSyntax());
    }

    @Override
    public String format() {
        String string = this.getName();
        char c = string.charAt(string.length() - 1);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return "\\" + string + " ";
        }
        return "\\" + string;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%s%s", new String(Character.toChars(teXParser.getEscChar())), this.getName());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ControlSequence) || object == null) {
            return false;
        }
        ControlSequence controlSequence = (ControlSequence)object;
        return this.isShort() == controlSequence.isShort() && this.isPar() == controlSequence.isPar() && this.hasSyntax(controlSequence);
    }

    public boolean isControlWord(TeXParser teXParser) {
        return teXParser.isLetter(this.name.charAt(0));
    }
}

