%% Herbert Voss <hvoss@tug.org>
%% Copyright (C) 2025
%%
%% This program can be redistributed and/or modified under the terms
%% of the LaTeX Project Public License Distributed from CTAN archives
%% in directory macros/latex/base/lppl.txt.
%%
%%  Option FULLPAGE,  complete paperarea on _one_ page even/odd 
%%
%% width=\textwidth+\leftmargin+\rightmargin   height=variable   --> FULLPAGE
%% _With_ no additional text on the doublepage
%%
%% ------------------------------------- the fullpage obejcts ---------------------------
%% ||1in+evenside --- |1in+oddside ---||
%
%\def\do@@@@hvFloat{%  special float page: caption <-> FULLPAGE images
  \hvfloat@typeout{>>>do@@@@hvFloat: special float page}%
  \ifx\hvSet@capPos\hv@After \global\hv@@capPos=1
  \else
    \ifx\hvSet@capPos\hv@Even  \global\hv@@capPos=2
    \else
      \ifx\hvSet@capPos\hv@Odd   \global\hv@@capPos=3
      \else
        \ifx\hvSet@capPos\hv@Inner   \global\hv@@capPos=4
        \else
          \ifx\hvSet@capPos\hv@Outer   \global\hv@@capPos=5
          \else
            \ifx\hvSet@capPos\hv@Right   \global\hv@@capPos=6% only for twocolumn mode
            \else
              \ifx\hvSet@capPos\hv@Left   \global\hv@@capPos=7% only for twocolumn mode
              \else
                \global\hv@@capPos=0
              \fi
            \fi
          \fi
        \fi
      \fi
    \fi
  \fi
%  \checkoddpage
  \set@caption@object{\hv@floatType}%  set caption and object into a box
%  
  \ifcase\hv@@capPos%   caption before object 0-> _always_ left
    \setBottomCaption\setPageObject        
  \or%                  caption after object 1-> _always_ right
    \setPageObject\setBottomCaption        
  \or%                  caption on even page 2-> left page
    \ifoddpage
      \afterpage{\setBottomCaption\setPageObject}%
    \else% we are on an even page
      \setBottomCaption\setPageObject
    \fi
  \or%                caption on odd page  3->right page
    \if@twoside
      \if@twocolumn
        \ifoddpage
          \if@firstcolumn%  on right side
            \setBottomCaption\setPageObject        
          \else
            \afterpage{\setPageObject\setBottomCaption}% start next column
          \fi
        \else% left (even) page
          \if@firstcolumn
            \afterpage{\setPageObject\setBottomCaption}% start next column
          \else
            \setPageObject\setBottomCaption
          \fi
        \fi
      \else% onecolumn
        \ifoddpage
          \setPageObject\setBottomCaption
        \else%  even page
          \afterpage{\setPageObject\setBottomCaption}%
        \fi
      \fi
    \else% oneside
      \if@twocolumn
        \ifoddpage
          \if@firstcolumn%  on right side
            \setBottomCaption\setPageObject
          \else
            \setPageObject\setBottomCaption
          \fi
        \else
          \if@firstcolumn%  on left side
            \afterpage{\setPageObject\setBottomCaption}%
          \else
            \setPageObject\setBottomCaption
          \fi
        \fi
      \else % onecolumn
        \ifoddpage
          \setBottomCaption\setPageObject%
        \else
          \afterpage{\setBottomCaption\setPageObject}%
        \fi
      \fi
    \fi
  \or%                caption on the inner column 4->inner
%    \set@caption@object
    \if@twocolumn
      \ifoddpage
        \if@firstcolumn%  on right side
	  \setBottomCaption\setPageObject
        \else%             right column on right side
          \setPageObject\setBottomCaption%  start next firstcolumn next page
        \fi
      \else
        \if@firstcolumn%  on left side
          \afterpage{\afterpage{\setBottomCaption\setPageObject}}% start next page/first column
        \else% left page/column
          \setBottomCaption\setPageObject% start on same page/column 
        \fi
      \fi 
    \else% onecolumn
      \setBottomCaption\setPageObject
    \fi       
  \or%                caption on the outer column  5->outer
%    \set@caption@object
    \if@twocolumn
      \ifoddpage
        \if@firstcolumn
          \afterpage{\afterpage{\setBottomCaption\setPageObject}}%
        \else
          \afterpage{\setBottomCaption\setPageObject}%
        \fi
      \else% even page (left)
        \if@firstcolumn
          \setBottomCaption\setPageObject
        \else   
%%%               !!!!  to-do: !!!!          
        \fi
      \fi 
    \else% onecolumn
      \setBottomCaption\setPageObject
    \fi 
  \or%                caption after object on same page 6->right for twocolumn
    \if@twocolumn
      \if@firstcolumn
        \afterpage{\setPageObject\setBottomCaption}%
      \else
        \setPageObject\setBottomCaption
      \fi
    \else%  always caption _after_ object for onecolumn 
      \setPageObject\setBottomCaption
    \fi  
  \or%                caption before object on same page 7->left for twocolumn
    \if@twocolumn
      \if@firstcolumn
        \setBottomCaption\setPageObject
      \else
        \afterpage{\setBottomCaption\setPageObject}%
      \fi    
    \else%        onecolumn -> same as before
      \setBottomCaption\setPageObject
    \fi
  \fi
  \endgroup% startet at main \hvFloat
%}
%
