/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserActionObject;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.ListOf;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.File;
import java.io.IOException;

public class L2HTableOfContents
extends ListOf {
    public L2HTableOfContents() {
        this("tableofcontents");
    }

    public L2HTableOfContents(String string) {
        super(string, "toc");
    }

    @Override
    public Object clone() {
        return new L2HTableOfContents(this.getName());
    }

    @Override
    public void processContentsList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        CountRegister countRegister;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        int n = -1;
        ControlSequence controlSequence = teXParser.getControlSequence("chapter");
        String string = "chapter*";
        if (controlSequence == null || controlSequence instanceof Undefined) {
            controlSequence = l2HConverter.getControlSequence("section");
            string = "section*";
        } else {
            countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel@chapter");
            countRegister.setValue(++n);
        }
        countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel@section");
        countRegister.setValue(++n);
        countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel@subsection");
        countRegister.setValue(++n);
        countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel@subsubsection");
        countRegister.setValue(++n);
        countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel@paragraph");
        countRegister.setValue(++n);
        countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel@subparagraph");
        countRegister.setValue(++n);
        l2HConverter.stepcounter(string);
        String string2 = l2HConverter.isHtml5() ? "nav" : "div";
        teXObjectList.push(new HtmlTag("<!-- end of toc -->"));
        teXObjectList.push(new EndElement(string2));
        teXObjectList.push(l2HConverter.getControlSequence("endgroup"));
        GenericCommand genericCommand = new GenericCommand(true, "@toc@endtags");
        teXParser.putControlSequence(true, genericCommand);
        teXObjectList.push(genericCommand);
        File file = l2HConverter.getAuxFile("toc");
        if (file != null && file.exists()) {
            teXObjectList.push(TeXParserActionObject.createInputAction(file));
        }
        teXObjectList.push(l2HConverter.getControlSequence("makeatletter"));
        teXObjectList.push(l2HConverter.getControlSequence("begingroup"));
        teXObjectList.push(l2HConverter.createGroup("toc"));
        teXObjectList.push(new TeXCsRef("label"));
        teXObjectList.push(new TeXCsRef("contentsname"));
        teXObjectList.push(l2HConverter.getOther(42));
        teXObjectList.push(controlSequence);
        StartElement startElement = new StartElement(string2);
        startElement.putAttribute("class", "toc");
        startElement.putAttribute("aria-label", "Table of Contents");
        teXObjectList.push(startElement);
        countRegister = teXParser.getSettings().newcount(true, "@curr@toclevel");
        countRegister.setValue(-1);
        l2HConverter.setCurrentBlockType(DocumentBlockType.BODY);
    }
}

