.TH PTFTOPL 1 "30 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX\"
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.\"=====================================================================
.SH NAME
ptftopl, uptftopl \- Convert Japanese p\*(TX font metric (JFM) files to property list
.SH SYNOPSIS
.B ptftopl
.RI [ options ]
.IR tfm_file [ \fB.tfm\fP ]
.RI [ pl_file [ \fB.pl\fP ]]
.\"=====================================================================
.SH DESCRIPTION
The
.B ptftopl
program translates a Japanese p\*(TX font metric (JFM) file to a
Japanese property list (JPL) file.  It also serves as a TFM/JFM-file
validating program.
.PP
The
.B uptftopl
program is a Unicode-enabled version of ptftopl.
.PP
In the following sections, we refer to these programs as
.BR (u)ptftopl .
.PP
.B (u)ptftopl
is upper compatible with
.BR tftopl ;
if the input TFM file is for roman fonts, it is translated into an
ordinary property list file.
The difference between
.B ptftopl
and
.B uptftopl
lies in the internal encoding: when the input is a JFM file,
.B ptftopl
always treats it as a JIS-encoded JFM; on the other hand,
.B uptftopl
treats it as a Unicode-encoded JFM by default.
.\"=====================================================================
.SH OPTIONS
Compared to tftopl, the following option is added to
.BR (u)ptftopl .
.TP
.BI -kanji \ string
Sets the output Japanese \fIKanji\fR code.  The
.I string
can be one of the followings:
.IR euc \ (EUC-JP),
.IR jis \ (ISO-2022-JP),
.IR sjis \ (Shift_JIS),
.IR utf8 \ (UTF-8),
.IR uptex \ (UTF-8;
.B uptftopl
only).
.PP
When one of
.IR euc ,
.IR jis ,
.I sjis
or
.I utf8
is specified, both
.B ptftopl
and
.B uptftopl
treats the input JFM as JIS-encoded.
When
.I uptex
is specified with
.BR uptftopl ,
it treats the input JFM as Unicode-encoded.
.\"=====================================================================
.SH "SEE ALSO"
.BR ptex (1).
.\"=====================================================================
.SH AUTHORS
.B (u)ptftopl
is maintained by
Japanese \*(TX Development Community <https://texjp.org>.
For bug reports, open an issue at
GitHub repository <https://github.com/texjporg/tex-jp-build>,
or send an e-mail to <issue@texjp.org>.
.PP
This manual page was written by Hironobu Yamashita.
