.TH OVP2OVF 1 "30 January 2026" "Web2C @VERSION@"
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.\"=====================================================================
.SH "NAME"
ovp2ovf \- convert Omega and TeX virtual property list (ovp) files to virtual font metric (ovf) files
.SH "SYNOPSIS"
.B ovp2ovf
.RI [ options ]
.IR ovpfile [ \fB.ovp\fP ]
.RI [ ovffile [ \fB.ovf\fP ]
.RI [ ofmfile [ \fB.ofm\fP ]]]
.\"=====================================================================
.SH "DESCRIPTION"
\fBovp2ovf\fP translates a human-readable virtual property list (\fI.ovp\fP)
file, \fIovpfile\fP, into a virtual font (\fI.ovf\fP) file, \fIovffile\fP
and its companion font metric (\fI.ofm\fP) file, \fIofmfile\fP.
.PP
The program also works with \*(TX virtual property list (\fI.vpl\fP)
files, producing \*(TX virtual fonts (\fI.vf\fP and \fI.tfm\fP).
.\"=====================================================================
.SH "OPTIONS"
.IP "\fB-help\fP"
output help message and exit
.IP "\fB-verbose\fP"
output progress reports
.IP "\fB-version\fP"
output version information and exit
.IP
.\"=====================================================================
.SH "FILES"
.IP "\fIOFMFILE\fP"
Omega Font Metric file
.IP "\fIOVFFILE\fP"
Omega Virtual Font file
.IP "\fIOVPFILE\fP"
Omega Virtual Property List file
.\"=====================================================================
.SH "BUGS"
Email bug reports via https://lists.tug.org/tex-k
(mailing list); good to check if the same bug is present in
\fBvptovf\fP(1).
.\"=====================================================================
.SH "SEE ALSO"
\fBomega\fP(1), \fBofm2opl\fP(1), \fBovf2ovp\fP(1),
\fBpltotf\fP(1), \fBtftopl\fP(1), \fBvftovp\fP(1),
\fBvptovf\fP(1)
.\"=====================================================================
.SH "AUTHOR"
According to the WEB documentation:
.RS
\fBVPtoVF\fP is an extended version of the program \fBPLtoTF\fP,
which is part of the standard TeXware library.  \fBOVP2OVF\fP is an
extended version of \fBVPtoVF\fP that allows much larger fonts.  The
idea of a virtual font was inspired by the work of David R. Fuchs who
designed a similar set of conventions in 1984 while developing a
device driver for ArborText, Inc.  He wrote a somewhat similar program
called \fBPLFONT\fP.
.RE
.PP
The primary authors of Omega were John Plaice and Yannis Haralambous.
Omega (and Aleph) are now maintained as part of TeX Live.
.PP
This manual page was written by C.M. Connelly for the Debian GNU/Linux
system. Both the program and the man page are now maintained as part of
\*(TX Live.
.PP
Bug reports and general discussion: https://lists.tug.org/omega
