.TH LATEX 1 "30 November 2025" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\h'-0.17m'\v'+0.21m'E\v'-0.21m'\h'-0.04m'X\fP
.el .ds OX TeX\"
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.\" OL for oblique LaTeX
.if t .ds OL \fIL\\h'-0.19m'\\v'-0.15v'\s-2A\s0\\h'-0.09m'\\v'0.15v'\fP\*(OX
.if n .ds OL LaTeX
.\"=====================================================================
.SH NAME
latex, pdflatex, xelatex, lualatex, dvilualatex, cslatex, pdfcslatex, platex, uplatex, lamed \- structured text formatting and typesetting
.SH SYNOPSIS
.B latex
.RI [ options ]
.RI [ \fB&\fPformat ]
\h'.25' [ \fIfile\fP [ \fImore-input\fP ] \h'.5'|\h'.5' [ \fB\e\fP\fImore-input\fP ]
.\"=====================================================================
.SH DESCRIPTION
\*(LX is a \*(TX macro package (format), not a
modification to the compiled \*(TX programs, so see
.BR tex (1)
for details of the command line invocation.
.PP
The \*(LX macros encourage writers to think about the content of their
documents, rather than the form. The ideal, very difficult to realize,
is to have no formatting commands (like ``switch to italic'' or ``skip 2
picas'') in the document, but to use generic markup instructions:
``emphasize'', ``start a section''.  The \*(LX language is described in
the books and documents mentioned below, among others.
.PP
The primary source of documentation for \*(LX is the \*(LX manual 
referenced below.
.PP
.BR lualatex ,
.BR pdflatex ,
.BR pdfcslatex ,
.B xelatex
are \*(LX formats based on the respective engines. These all output PDF
by default. The lualatex format is built with the luahbtex engine, the
Lua\*(TX variant with HarfBuzz (https://en.wikipedia.org/wiki/HarfBuzz)
supported for glyph shaping.
.br
.BR platex ,
.B uplatex
are Japanese \*(LX formats based on e-p\*(TX and e-up\*(TX (DVI output).
.br
.B lamed
is the Aleph-based \*(LX format (DVI output).
.br
.B dvilualatex
is Lua\*(TX-based and outputs DVI.
.br
.B cslatex
is cs\*(TX-based (primitives integrated into pdf\*(TX) and outputs DVI.
.PP
On some systems, the commands
.B latex209
and
.B slitex
may still be available for compatibility with older versions of \*(LX.
These should not be used for new documents.
.\"=====================================================================
.SH "SEE ALSO"
.BR amstex (1),
.BR luatex (1),
.BR pdftex (1),
.BR ptex (1),
.BR tex (1),
.BR xetex (1).
.PP
Leslie Lamport,
.IR \*(OL: A Document Preparation System .
.br
Frank Mittelbach with Ulrike Fischer,
.IR The \*(OL Companion ,
Addison-Wesley, 2024, ISBN 0-13-811578-8 (3rd edition).
https://tug.org/l/tlc3
.PP
Package pages on CTAN: https://ctan.org/pkg/latex,
https://ctan.org/pkg/latex-base
.br
\*(LX tutorial topic on CTAN: https://ctan.org/topic/tut-latex
.br
\*(LX reference topic on CTAN: https://ctan.org/topic/ref-latex
.PP
The \*(LX home page: https://latex-project.org
.br
Online interactive tutorial: https://learnlatex.org
.br
Getting started page: https://tug.org/begin
.PP
Please report bugs in \*(LX
following the procedure at https://www.latex-project.org/bugs.
.PP
Public discussion list for all things \*(TX and \*(LX:
https://lists.tug.org/texhax
