.TH GFTYPE 1 "25 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.\"=====================================================================
.SH NAME
gftype \- verify and translate a generic font (gf) bitmap file to plain text
.SH SYNOPSIS
.B gftype
.RB [ -i ]
.RB [ -m ]
.IR gf_file [gf]
.RI [ output_file ]
.\"=====================================================================
.SH DESCRIPTION
The
.B gftype
program
translates a
.I gf
(generic font) bitmap file output by, typically,
.BR mf (1),
to a file that humans can read.
It also serves as a
.I gf
file-validating
program (i.e., if
.B gftype
can read it, it's correct) and as an example of a
.IR gf -reading
program for other software that wants to read
.I gf
files.
.PP
The
.I gf_file
on the command line must include the resolution, but can omit the suffix
"gf". If no
.I output_file
is specified, the output goes to stdout.
.\"=====================================================================
.SH OPTIONS
See
.BR tex (1)
for details of command-line parsing.
.PP
.TP
.B -images
Includes ASCII art images of the characters in the output.
.TP
.B -mnemonics
Include a symbolic listing of the
.I gf
commands in the output.
.PP
The standard
.B -help
and
.B -version
options are also supported.
.\"=====================================================================
.SH ENVIRONMENT
The program looks for
.I gf_file
using the environment variables GFFONTS, GLYPHFONTS, and TEXFONTS, in
that order. If none are set, it uses the system default. See the
Kpathsea manual at https://tug.org/kpathsea for the details of the
searching.
.\"=====================================================================
.SH "SEE ALSO"
.BR dvitype (1),
.BR pktype (1).
.br
Donald E. Knuth et al.,
.IR \*(MFware .
.PP
Package page on CTAN: https://ctan.org/pkg/gftype
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#gftype-invocation
.br
Typeset source code, including file format descriptions:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH AUTHORS
David Fuchs and Don Knuth wrote the program.  It was published as
part of the
.I \*(MFware
technical report. Paul Richards originally ported it to Unix.
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
