# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153518;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              485|
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463
          )\\d{3,10}|
          648[34]\\d{3,9}|
          (?:
            51|
            66|
            73
          )2\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-7]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463
          )\\d{3,10}|
          648[34]\\d{3,9}|
          (?:
            51|
            66|
            73
          )2\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-7]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            485|
            (?:
              5[0-3579]|
              6[013-9]|
              [7-9]\\d
            )\\d
          )\\d{3,9}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"434846", "Abfaltersbach",
"437614", "Vorchdorf",
"433142", "Voitsberg",
"434277", "Glanegg",
"435354", "Fieberbrunn",
"4318", "Vienna",
"437213", "Bad\ Leonfelden",
"436466", "Werfenweng",
"436245", "Hallein",
"432525", "Gnadendorf",
"433386", "Grosssteinbach",
"433133", "Nestelbach",
"435516", "Doren",
"434213", "Launsdorf",
"436566", "Bramberg\ am\ Wildkogel",
"435557", "St\.\ Gallenkirch",
"432954", "Göllersdorf",
"436475", "Ramingstein",
"433149", "Geistthal",
"433588", "Katsch\ an\ der\ Mur",
"432636", "Puchberg\ am\ Schneeberg",
"437277", "Waizenkirchen",
"432786", "Oberwölbling",
"436541", "Saalbach",
"432641", "Kirchberg\ am\ Wechsel",
"437748", "Eggelsberg",
"432666", "Reichenau",
"433637", "Gams\ bei\ Hieflau",
"432772", "Neulengbach",
"433155", "Fehring",
"433884", "Wegscheid",
"436212", "Seekirchen\ am\ Wallersee",
"435285", "Mayrhofen",
"43662", "Salzburg",
"436467", "Mühlbach\ am\ Hochkönig",
"437265", "Pabneukirchen",
"435239", "Kühtai",
"4315", "Vienna",
"434276", "Feldkirchen\ in\ Kärnten",
"433115", "Studenzen",
"434847", "Obertilliach",
"435358", "Ellmau",
"437289", "Rohrbach\ in\ Oberösterreich",
"432163", "Petronell\-Carnuntum",
"435517", "Riezlern",
"434253", "St\.\ Jakob\ im\ Rosental",
"433387", "Söchau",
"432825", "Göpfritz\ an\ der\ Wild",
"437618", "Neukirchen\,\ Altmünster",
"432914", "Japons",
"432160", "Jois",
"432711", "Dürnstein",
"437235", "Gallneukirchen",
"435473", "Nauders",
"434282", "Hermagor",
"432142", "Gattendorf",
"437941", "Neumarkt\ im\ Mühlkreis",
"434265", "Weitensfeld\ im\ Gurktal",
"4314", "Vienna",
"437744", "Munderfing",
"437723", "Altheim",
"437276", "Peuerbach",
"432637", "Grünbach\ am\ Schneeberg",
"436219", "Obertrum\ am\ See",
"435232", "Kematen\ in\ Tirol",
"435556", "Schruns",
"435573", "Hörbranz",
"434235", "Bleiburg",
"433584", "Neumarkt\ in\ Steiermark",
"435243", "Maurach",
"432958", "Maissau",
"433636", "Wildalpen",
"437282", "Neufelden",
"435224", "Wattens",
"432667", "Schwarzau\ im\ Gebirge",
"437253", "Wolfern",
"435417", "Roppen",
"435262", "Telfs",
"437250", "Maria\ Neustift",
"432769", "Türnitz",
"433332", "Hartberg",
"432665", "Prein\ an\ der\ Rax",
"436453", "Filzmoos",
"436589", "Unken",
"434852", "Lienz",
"434237", "Miklauzhof",
"433173", "Ratten",
"432689", "Hornstein",
"436565", "Neukirchen\ am\ Grossvenediger",
"432739", "Tiefenfucha",
"433362", "Grosspetersdorf",
"433170", "Fischbach",
"436476", "St\.\ Margarethen\ im\ Lungau",
"433613", "Admont",
"432635", "Neunkirchen",
"433324", "Strem",
"434267", "Metnitz",
"433339", "Friedberg",
"432762", "Lilienfeld",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432526", "Stronsdorf",
"432743", "Böheimkirchen",
"433385", "Ilz",
"432827", "Schönbach",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"435515", "Au",
"437412", "Ybbs\ an\ der\ Donau",
"433117", "Eggersdorf\ bei\ Graz",
"432254", "Ebreichsdorf",
"432732", "Krems\ an\ der\ Donau",
"437267", "Mönchdorf",
"432682", "Eisenstadt",
"435287", "Tux",
"436246", "Grödig",
"434236", "Eberndorf",
"432214", "Kopfstetten",
"433157", "Kapfenstein",
"435279", "St\.\ Jodok\ am\ Brenner",
"433635", "Radmer",
"432613", "Deutschkreutz",
"437480", "Langau\,\ Gaming",
"435442", "Landeck",
"433328", "Kukmirn",
"432610", "Horitschon",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"437483", "Oberndorf\ an\ der\ Melk",
"432173", "Gols",
"434266", "Strassburg",
"436477", "St\.\ Michael\ im\ Lungau",
"437471", "Neustadtl\ an\ der\ Donau",
"43512", "Innsbruck",
"435272", "Steinach\ am\ Brenner",
"437583", "Kremsmünster",
"432826", "Rastenfeld",
"432258", "Alland",
"432527", "Wulzeshofen",
"433682", "Stainach",
"437236", "Pregarten",
"435449", "Fliess",
"437953", "Liebenau",
"436247", "Grossgmain",
"435286", "Ginzling",
"437241", "Steinerkirchen\ an\ der\ Traun",
"436413", "Wagrain",
"437266", "Bad\ Kreuzen",
"432728", "Wienerbruck",
"433116", "Kirchbach\ in\ Steiermark",
"434275", "Ebene\ Reichenau",
"437445", "Hollenstein\ an\ der\ Ybbs",
"437616", "Grünau\ im\ Almtal",
"432255", "Deutsch\ Brodersdorf",
"435356", "Kitzbühel",
"434823", "Tresdorf\,\ Rangersdorf",
"432629", "Warth\,\ Lower\ Austria",
"435373", "Ebbs",
"436434", "Bad\ Gastein",
"432249", "Gross\-Enzersdorf",
"434278", "Gnesau",
"437448", "Kematen\ an\ der\ Ybbs",
"435514", "Bezau",
"432725", "Frankenfels",
"432233", "Pressbaum",
"436564", "Krimml",
"433638", "Palfau",
"4313", "Vienna",
"432230", "Schwadorf",
"432956", "Ziersdorf",
"432634", "Gutenstein",
"432784", "Perschling",
"437747", "Kirchberg\ bei\ Mattighofen",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"432263", "Grossrussbach",
"432622", "Wiener\ Neustadt",
"437278", "Neukirchen\ am\ Walde",
"435414", "Wenns",
"435558", "Gaschurn",
"432664", "Semmering",
"432572", "Mistelbach",
"433587", "Schönberg\-Lachtal",
"433886", "Weichselboden",
"432242", "St\.\ Andrä\-Wördern",
"433579", "Pöls",
"434761", "Stockenboi",
"433472", "Mureck",
"435518", "Mellau",
"435357", "Kirchberg\ in\ Tirol",
"4317", "Vienna",
"434274", "Velden\ am\ Wörther\ See",
"437617", "Traunkirchen",
"437444", "Opponitz",
"434848", "Kartitsch",
"432916", "Riegersburg\,\ Hardegg",
"436468", "Werfen",
"435418", "Schönwies",
"437746", "Friedburg",
"433572", "Judenburg",
"437274", "Alkoven",
"432957", "Hohenwarth",
"435554", "Sonntag",
"433622", "Bad\ Aussee",
"437673", "Schwanenstadt",
"432872", "Ottenschlag",
"432215", "Probstdorf",
"433586", "Mühlen",
"433634", "Hieflau",
"435226", "Neustift\ im\ Stubaital",
"432638", "Winzendorf\-Muthmannsdorf",
"434268", "Friesach",
"432949", "Niederfladnitz",
"434359", "Reichenfels",
"433885", "Greith",
"434238", "Eisenkappel\-Vellach",
"436474", "Tamsweg",
"432955", "Grossweikersdorf",
"435333", "Söll",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"437712", "Schärding",
"433326", "Stegersbach",
"433832", "Kraubath\ an\ der\ Mur",
"435288", "Fügen",
"432674", "Weissenbach\ an\ der\ Triesting",
"434352", "Wolfsberg",
"432524", "Kautendorf",
"432942", "Retz",
"433118", "Sinabelkirchen",
"437268", "Grein",
"432726", "Puchenstuben",
"432273", "Tulbing",
"432828", "Rappottenstein",
"437615", "Scharnstein",
"433862", "Bruck\ an\ der\ Mur",
"432532", "Zistersdorf",
"432256", "Leobersdorf",
"435355", "Jochberg",
"434712", "Greifenburg",
"436223", "Anthering",
"437719", "Taufkirchen\ an\ der\ Pram",
"437238", "Mauthausen",
"436244", "Golling\ an\ der\ Salzach",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"434234", "Ruden",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"436478", "Zederhaus",
"436131", "Obertraun",
"433585", "St\.\ Lambrecht",
"435225", "Fulpmes",
"437759", "Antiesenhofen",
"434783", "Reisseck",
"434264", "Klein\ St\.\ Paul",
"433327", "St\.\ Michael\ im\ Burgenland",
"437745", "Lochen",
"437229", "Traun",
"433462", "Deutschlandsberg",
"433158", "St\.\ Anna\ am\ Aigen",
"432843", "Dobersberg",
"432915", "Drosendorf\-Zissersdorf",
"432824", "Allentsteig",
"437234", "Ottensheim",
"433532", "Murau",
"432862", "Heidenreichstein",
"437752", "Ried\ im\ Innkreis",
"437663", "Steinbach\ am\ Attersee",
"433469", "St\.\ Oswald\ im\ Freiland",
"435284", "Gerlos",
"437264", "Windhaag\ bei\ Perg",
"434229", "Krumpendorf\ am\ Wörther\ See",
"432257", "Klausen\-Leopoldsdorf",
"433114", "Markt\ Hartmannsdorf",
"433125", "Übelbach",
"434713", "Techendorf",
"434710", "Oberdrauburg",
"435339", "Wildschönau",
"433863", "Turnau",
"432533", "Neusiedl\ an\ der\ Zaya",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"432286", "Obersiebenbrunn",
"433842", "Leoben",
"435677", "Vils",
"433833", "Traboch",
"436234", "Zell\ am\ Moos",
"437248", "Grieskirchen",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"432272", "Tulln\ an\ der\ Donau",
"432815", "Grossschönau",
"434353", "Prebl",
"432943", "Obritz",
"435332", "Wörgl",
"434874", "Virgen",
"432555", "Herrnbaumgarten",
"436229", "Hof\ bei\ Salzburg",
"437713", "Schardenberg",
"433849", "Vordernberg",
"432985", "Gars\ am\ Kamp",
"437353", "Gaflenz",
"433184", "Wolfsberg\ im\ Schwarzautal",
"433855", "Krieglach",
"435214", "Leutasch",
"436137", "Strobl",
"432279", "Kirchberg\ am\ Wagram",
"437478", "Oed\-Oehling",
"434248", "Treffen",
"437244", "Sattledt",
"437662", "Seewalchen\ am\ Attersee",
"432287", "Strasshof\ an\ der\ Nordbahn",
"437223", "Enns",
"435254", "Sölden",
"434735", "Kremsbrücke",
"433455", "Arnfels",
"435526", "Laterns",
"432842", "Waidhofen\ an\ der\ Thaya",
"433533", "Turrach",
"432863", "Eggern",
"437753", "Eberschwang",
"437750", "Andrichsfurt",
"435676", "Jungholz",
"435635", "Elmen",
"433463", "Stainz",
"433460", "Soboth",
"432855", "Waldenstein",
"437765", "Lambrechten",
"434220", "Köttmannsdorf",
"437474", "Euratsfeld",
"434244", "Bad\ Bleiberg",
"434223", "Maria\ Saal",
"432849", "Schwarzenau",
"436136", "Gosau",
"437735", "Gaspoltshofen",
"434782", "Obervellach",
"437948", "Hirschbach\ im\ Mühlkreis",
"432644", "Grimmenstein",
"432620", "Willendorf",
"432262", "Korneuburg",
"432623", "Pottendorf",
"433856", "Veitsch",
"432573", "Wilfersdorf",
"432243", "Klosterneuburg",
"432951", "Guntersdorf",
"432754", "Loosdorf",
"432232", "Fischamend",
"432556", "Grosskrut",
"432857", "Bad\ Grosspertholz",
"437767", "Eggerding",
"436544", "Rauris",
"436274", "Lamprechtshausen",
"432986", "Irnfritz",
"433354", "Bernstein",
"432269", "Niederfellabrunn",
"432816", "Karlstift",
"435372", "Kufstein",
"433457", "Gleinstätten",
"434822", "Winklern",
"433126", "Frohnleiten",
"432239", "Breitenfurt\ bei\ Wien",
"432718", "Lichtenau\ im\ Waldviertel",
"433516", "Kleinlobming",
"432285", "Marchegg",
"434767", "Rothenthurn",
"432873", "Kottes",
"436135", "Bad\ Goisern",
"433581", "Oberwölz",
"432758", "Pöggstall",
"437736", "Pram",
"433857", "Neuberg\ an\ der\ Mürz",
"436548", "Niedernsill",
"436278", "Ostermiething",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"437944", "Sandl",
"432648", "Hochneukirchen",
"433573", "Fohnsdorf",
"437766", "Andorf",
"433623", "Bad\ Mitterndorf",
"432856", "Weitra",
"432557", "Bernhardsthal",
"437672", "Vöcklabruck",
"437564", "Hinterstoder",
"433456", "Fresing",
"435525", "Nenzing",
"432714", "Rossatz",
"434736", "Innerkrems",
"437434", "Haag",
"435675", "Tannheim",
"434766", "Millstatt",
"433358", "Litzelsdorf",
"433473", "Straden",
"433127", "Peggau",
"432733", "Schönberg\ am\ Kamp",
"433179", "Passail",
"432683", "Purbach\ am\ Neusiedler\ See",
"433619", "Oppenberg",
"437413", "Marbach\ an\ der\ Donau",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"436241", "St\.\ Koloman",
"432284", "Oberweiden",
"435678", "Weissenbach\ am\ Lech",
"437247", "Kematen\ am\ Innbach",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"433355", "Stadtschlaining",
"436583", "Leogang",
"432742", "St\.\ Pölten",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"436471", "Tweng",
"433363", "Rechnitz",
"433612", "Liezen",
"432755", "Mank",
"433172", "Weiz",
"437477", "St\.\ Peter\ in\ der\ Au",
"434247", "Afritz",
"434876", "Kals\ am\ Grossglockner",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"433333", "Sebersdorf",
"436483", "Göriach",
"432645", "Wiesmath",
"432749", "Prinzersdorf",
"434853", "Ainet",
"433151", "Gnas",
"436452", "Radstadt",
"437246", "Gunskirchen",
"435256", "Untergurgl",
"436412", "St\.\ Johann\ im\ Pongau",
"437261", "Schönau\ im\ Mühlkreis",
"437582", "Kirchdorf\ an\ der\ Krems",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"435524", "Satteins",
"437435", "St\.\ Valentin",
"435273", "Matrei\ am\ Brenner",
"433680", "Donnersbachwald",
"437952", "Weitersfelden",
"432619", "Lackendorf",
"433683", "Donnersbach",
"437489", "Purgstall\ an\ der\ Erlauf",
"437231", "Herzogsdorf",
"432288", "Auersthal",
"435674", "Bichlbach",
"435585", "Dalaas",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"434877", "Prägraten\ am\ Grossvenediger",
"434246", "Radenthein",
"437476", "Aschbach\-Markt",
"4312", "Vienna",
"437565", "St\.\ Pankraz",
"436134", "Hallstatt",
"434231", "Mittertrixen",
"437482", "Scheibbs",
"432172", "Frauenkirchen",
"432612", "Oberpullendorf",
"435443", "Galtür",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"433185", "Preding",
"433854", "Langenwang",
"432858", "Moorbad\ Harbach",
"432773", "Eichgraben",
"432756", "St\.\ Leonhard\ am\ Forst",
"434212", "St\.\ Veit\ an\ der\ Glan",
"432554", "Stützenhofen",
"434875", "Matrei\ in\ Osttirol",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"437947", "Kefermarkt",
"437219", "Vorderweissenbach",
"436276", "Nussdorf\ am\ Haunsberg",
"432631", "Pöttsching",
"432984", "Eggenburg",
"433356", "Markt\ Allhau",
"434768", "Kleblach\-Lind",
"436235", "Thalgau",
"433132", "Kumberg",
"432814", "Langschlag",
"432717", "Unter\-Meisling",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"433124", "Gratkorn",
"433143", "Krottendorf",
"433514", "Seckau",
"437212", "Zwettl\ an\ der\ Rodl",
"436461", "Dienten\ am\ Hochkönig",
"433631", "Unterlaussa",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"437283", "Sarleinsbach",
"435572", "Dornbirn",
"435242", "Schwaz",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"435263", "Silz",
"432988", "Neupölla",
"437684", "Frankenmarkt",
"432647", "Krumbach\,\ Lower\ Austria",
"437252", "Steyr",
"435634", "Elbigenalp",
"437722", "Braunau\ am\ Inn",
"433858", "Mitterdorf\ im\ Mürztal",
"436277", "St\.\ Pantaleon",
"437946", "Gutau",
"436547", "Kaprun",
"437764", "Riedau",
"432854", "Kirchberg\ am\ Walde",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"434245", "Feistritz\ an\ der\ Drau",
"432757", "Pöchlarn",
"435230", "Sellrain",
"437566", "Rosenau\ am\ Hengstpass",
"433454", "Leutschach",
"434734", "Rennweg",
"432716", "Gföhl",
"435579", "Alberschwende",
"432162", "Bruck\ an\ der\ Leitha",
"434252", "Wernberg",
"437259", "Sierning",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432143", "Kittsee",
"433357", "Pinkafeld",
"435472", "Prutz",
"437245", "Lambach",
"437729", "Neukirchen\ an\ der\ Enknach",
"436213", "Oberhofen\ am\ Irrsee",
"434271", "Steuerberg",
"4319", "Vienna",
"435255", "Umhausen",
"432875", "Grafenschlag",
"436133", "Ebensee",
"432212", "Orth\ an\ der\ Donau",
"435444", "Ischgl",
"437357", "Kleinreifling",
"437717", "St\.\ Aegidi",
"433575", "St\.\ Johann\ am\ Tauern",
"4316", "Vienna",
"433338", "Lafnitz",
"433466", "Eibiswald",
"434226", "St\.\ Margareten\ im\ Rosental",
"434858", "Nikolsdorf",
"435274", "Gries\ am\ Brenner",
"432841", "Vitis",
"432688", "Steinbrunn",
"432738", "Fels\ am\ Wagram",
"434357", "St\.\ Paul\ im\ Lavanttal",
"435523", "Götzis",
"432947", "Theras",
"435673", "Ehrwald",
"433684", "St\.\ Martin\ am\ Grimming",
"433536", "St\.\ Peter\ am\ Kammersberg",
"437226", "Wilhering",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"434717", "Steinfeld",
"433475", "Hürth",
"436588", "Lofer",
"433867", "Pernegg\ an\ der\ Mur",
"432625", "Bad\ Sauerbrunn",
"436484", "Lessach",
"433334", "Kaindorf",
"432245", "Wolkersdorf\ im\ Weinviertel",
"432575", "Ladendorf",
"435331", "Brandenberg",
"434227", "Ferlach",
"432259", "Münchendorf",
"433364", "Hannersdorf",
"433467", "Schwanberg",
"435448", "Pettneu\ am\ Arlberg",
"433322", "Güssing",
"437716", "Münzkirchen",
"433537", "St\.\ Georgen\ ob\ Murau",
"437757", "Gurten",
"432764", "Hainfeld",
"432946", "Pulkau",
"434356", "Lavamünd",
"432722", "Kirchberg\ an\ der\ Pielach",
"432271", "Ried\ am\ Riederberg",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432252", "Baden",
"432536", "Drösing",
"437414", "Weins\-Isperdorf",
"433866", "Breitenau\ am\ Hochlantsch",
"435278", "Navis",
"432684", "Schützen\ am\ Gebirge",
"434716", "Lesachtal",
"432734", "Langenlois",
"436221", "Koppl",
"433329", "Jennersdorf",
"432283", "Angern\ an\ der\ March",
"433688", "Tauplitz",
"437227", "Neuhofen\ an\ der\ Krems",
"437225", "Hargelsberg",
"436214", "Henndorf\ am\ Wallersee",
"433476", "Bad\ Radkersburg",
"433453", "Ehrenhausen",
"432912", "Geras",
"434733", "Malta",
"433148", "Kainach\ bei\ Voitsberg",
"434284", "Kirchbach",
"437755", "Mettmach",
"432144", "Deutsch\ Jahrndorf",
"432865", "Litschau",
"433535", "Krakaudorf",
"437742", "Mattighofen",
"433576", "Bretstein",
"433465", "Pölfing\-Brunn",
"435633", "Hägerau",
"434225", "Grafenstein",
"435234", "Axams",
"437763", "Kopfing\ im\ Innkreis",
"432853", "Schrems",
"433582", "Scheifling",
"432577", "Asparn\ an\ der\ Zaya",
"432247", "Deutsch\-Wagram",
"432876", "Els",
"437284", "Oberkappel",
"437683", "Frankenburg\ am\ Hausruck",
"432627", "Pitten",
"437733", "Neumarkt\ im\ Hausruckkreis",
"435264", "Mieming",
"432535", "Hohenau\ an\ der\ March",
"433865", "Kindberg",
"437612", "Gmunden",
"432959", "Sitzendorf\ an\ der\ Schmida",
"433144", "Köflach",
"433477", "St\.\ Peter\ am\ Ottersbach",
"434715", "Kötschach\-Mauthen",
"435352", "St\.\ Johann\ in\ Tirol",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"433513", "Bischoffeld",
"432945", "Zellerndorf",
"434355", "Gemmersdorf",
"432813", "Arbesbach",
"435359", "Hochfilzen",
"437288", "Ulrichsberg",
"432231", "Purkersdorf",
"432952", "Hollabrunn",
"437619", "Kirchham",
"432983", "Sigmundsherberg",
"433577", "Zeltweg",
"432626", "Mattersburg",
"433853", "Spital\ am\ Semmering",
"437355", "Weyer",
"432774", "Innermanzing",
"435238", "Zirl",
"432877", "Grainbrunn",
"433882", "Mariazell",
"432246", "Gerasdorf\ bei\ Wien",
"432576", "Ernstbrunn",
"432829", "Schweiggers",
"434232", "Völkermarkt",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433337", "Vorau",
"435446", "St\.\ Anton\ am\ Arlberg",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"437718", "Waldkirchen\ am\ Wesen",
"437239", "Lichtenberg",
"435265", "Nassereith",
"434262", "Treibach",
"433464", "Gross\ St\.\ Florian",
"435289", "Häusling",
"434240", "Bad\ Kleinkirchheim",
"434224", "Pischeldorf",
"433119", "St\.\ Marein\ bei\ Graz",
"434243", "Bodensdorf",
"437473", "Blindenmarkt",
"437269", "Baumgartenberg",
"435276", "Gschnitz",
"434718", "Dellach",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432538", "Velm\-Götzendorf",
"432822", "Zwettl\,\ Lower\ Austria",
"433868", "Tragöss",
"432767", "Hohenberg",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"433686", "Haus",
"432864", "Kautzen",
"434285", "Tröpolach",
"437754", "Waldzell",
"432145", "Prellenkirchen",
"433534", "Stadl\ an\ der\ Mur",
"437240", "Sipbachzell",
"435282", "Zell\ am\ Ziller",
"437224", "St\.\ Florian",
"436215", "Strasswalchen",
"437243", "Marchtrenk",
"434269", "Flattnitz",
"432687", "Siegendorf",
"437262", "Perg",
"435253", "Längenfeld",
"432948", "Weitersfeld",
"433112", "Gleisdorf",
"434358", "St\.\ Andrä",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"433336", "Waldbach",
"435447", "Flirsch",
"434228", "Feistritz\ im\ Rosental",
"435213", "Scharnitz",
"433152", "Feldbach",
"433171", "Gasen",
"434873", "St\.\ Jakob\ in\ Defereggen",
"436472", "Mauterndorf",
"433611", "Johnsbach",
"433366", "Kohfidisch",
"437714", "Esternberg",
"433834", "Wald\ am\ Schoberpass",
"436233", "Oberwang",
"437228", "Kematen\ an\ der\ Krems",
"433687", "Schladming",
"432672", "Berndorf",
"432766", "Kleinzell",
"433159", "Bad\ Gleichenberg",
"432944", "Haugsdorf",
"432741", "Flinsbach",
"434354", "Preitenegg",
"432522", "Laa\ an\ der\ Thaya",
"432534", "Niedersulz",
"433145", "Edelschrott",
"436479", "Muhr",
"433864", "St\.\ Marein\ im\ Mürztal",
"437416", "Wieselburg",
"432686", "Drassburg",
"434714", "Dellach\ im\ Drautal",
"432736", "Paudorf",
"437758", "Obernberg\ am\ Inn",
"436242", "Russbach\ am\ Pass\ Gschütt",
"437279", "Haibach\ ob\ der\ Donau",
"436216", "Neumarkt\ am\ Wallersee",
"435559", "Brand",
"433474", "Deutsch\ Goritz",
"434272", "Pörtschach\ am\ Wörther\ See",
"437442", "Waidhofen\ an\ der\ Ybbs",
"433147", "Salla",
"435275", "Trins",
"437433", "Wallsee",
"432713", "Spitz",
"433685", "Gröbming",
"432146", "Nickelsdorf",
"434286", "Weissbriach",
"437943", "Windhaag\ bei\ Freistadt",
"433574", "Pusterwald",
"435583", "Lech",
"437272", "Eferding",
"432628", "Felixdorf",
"437563", "Spital\ am\ Pyhrn",
"432248", "Markgrafneusiedl",
"434279", "Sirnitz",
"435236", "Gries\ im\ Sellrain",
"435552", "Bludenz",
"433624", "Pichl\-Kainisch",
"432874", "Martinsberg",
"437286", "Lembach\ im\ Mühlkreis",
"433632", "St\.\ Gallen",
"435445", "Kappl",
"437251", "Schiedlberg",
"435266", "Ötztal\-Bahnhof",
"437415", "Altenmarkt\,\ Yspertal",
"434842", "Sillian",
"433146", "Modriach",
"432685", "Rust",
"432735", "Hadersdorf\ am\ Kamp",
"437211", "Reichenau\ im\ Mühlkreis",
"436462", "Bischofshofen",
"436217", "Mattsee",
"432639", "Bad\ Fischau",
"4346", "Klagenfurt",
"432147", "Zurndorf",
"433353", "Oberschützen",
"432765", "Kaumberg",
"433382", "Fürstenfeld",
"436432", "Bad\ Hofgastein",
"435512", "Egg",
"436562", "Mittersill",
"432753", "Gansbach",
"433365", "Deutsch\ Schützen\-Eisenberg",
"432878", "Traunstein",
"432782", "Herzogenburg",
"432632", "Pernitz",
"436543", "Taxenbach",
"432624", "Ebenfurth",
"432643", "Lichtenegg",
"433578", "Obdach",
"433335", "Pöllau",
"435412", "Imst",
"432662", "Gloggnitz",
"435519", "Schröcken",
"437287", "Peilstein\ im\ Mühlviertel",
"432244", "Langenzersdorf",
"434855", "Assling",
"432574", "Gaweinstal",
"433633", "Landl",
"437281", "Aigen\ im\ Mühlkreis",
"432238", "Kaltenleutgeben",
"435246", "Achenkirch",
"432719", "Dross",
"435576", "Hohenems",
"437485", "Gaming",
"432175", "Apetlon",
"437256", "Ternberg",
"432615", "Lutzmannsburg",
"437273", "Aschach\ an\ der\ Donau",
"432268", "Grossmugl",
"437942", "Freistadt",
"435582", "Klösterle",
"437674", "Attnang\-Puchheim",
"435553", "Raggal",
"437562", "Windischgarsten",
"435550", "Thüringen",
"432712", "Aggsbach",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"434256", "Nötsch\ im\ Gailtal",
"432166", "Parndorf",
"437432", "Strengberg",
"433137", "Söding",
"437955", "Königswiesen",
"435476", "Serfaus",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"437949", "Rainbach\ im\ Mühlkreis",
"434273", "Reifnitz",
"437443", "Ybbsitz",
"436415", "Schwarzach\ im\ Pongau",
"432642", "Aspangberg\-St\.\ Peter",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437257", "Grünburg",
"432264", "Rückersdorf\,\ Harmannsdorf",
"433359", "Loipersdorf\-Kitzladen",
"435577", "Lustenau",
"436455", "Untertauern",
"432663", "Schottwien",
"432752", "Melk",
"433615", "Trieben",
"436563", "Uttendorf",
"432234", "Gramatneusiedl",
"433175", "Anger",
"436272", "Oberndorf\ bei\ Salzburg",
"436542", "Zell\ am\ See",
"432630", "Ternitz",
"432783", "Traismauer",
"432633", "Markt\ Piesting",
"437727", "Ach",
"433352", "Oberwart",
"435477", "Tösens",
"432649", "Mönichkirchen",
"435513", "Hittisau",
"433136", "Dobl",
"432167", "Neusiedl\ am\ See",
"434257", "Fürnitz",
"435510", "Damüls",
"432745", "Pyhra",
"433383", "Burgau",
"435374", "Walchsee",
"436433", "Dorfgastein",
"434824", "Heiligenblut",
"433141", "Hirschegg",
"434843", "Ausservillgraten",
"436549", "Piesendorf",
"437216", "Helfenberg",
"436463", "Annaberg\-Lungötz",
"437242", "Wels",
"435280", "Hochfügen",
"435283", "Kaltenbach",
"437664", "Weyregg\ am\ Attersee",
"435252", "Oetz",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"43732", "Linz",
"437260", "Waldhausen",
"432278", "Absdorf",
"436416", "Lend",
"43316", "Graz",
"437479", "Ardagger",
"437263", "Bad\ Zell",
"437586", "Pettenbach",
"432823", "Grossglobnitz",
"432747", "Ober\-Grafendorf",
"434255", "Arnoldstein",
"432844", "Karlstein\ an\ der\ Thaya",
"432165", "Hainburg\ a\.d\.\ Donau",
"436228", "Faistenau",
"437956", "Unterweissenbach",
"437230", "Altenberg\ bei\ Linz",
"435475", "Feichten",
"433848", "Eisenerz",
"437233", "Feldkirchen\ an\ der\ Donau",
"434263", "Hüttenberg",
"437249", "Bad\ Schallerbach",
"437472", "Amstetten",
"434242", "Villach",
"433177", "Puch\ bei\ Weiz",
"433617", "Gaishorn\ am\ See",
"436457", "Flachau",
"434230", "Globasnitz",
"435338", "Kundl",
"435245", "Hinterriss",
"434233", "Griffen",
"435575", "Langen\ bei\ Bregenz",
"432176", "Tadten",
"437486", "Lunz\ am\ See",
"437255", "Losenstein",
"434784", "Mallnitz",
"435441", "See",
"432616", "Lockenhaus",
"432731", "Idolsberg",
"436417", "Hüttschlag",
"434879", "St\.\ Veit\ in\ Defereggen",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"436243", "Abtenau",
"433844", "Kammern\ im\ Liesingtal",
"436224", "Hintersee",
"436240", "Krispl",
"437215", "Hellmonsödt",
"432673", "Altenmarkt\ an\ der\ Triesting",
"436232", "Mondsee",
"432274", "Sieghartskirchen",
"433135", "Kalsdorf\ bei\ Graz",
"432746", "Wilhelmsburg",
"437587", "Wartberg\ an\ der\ Krems",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"435334", "Westendorf",
"436473", "Mariapfarr",
"433616", "Selzthal",
"436470", "Atzmannsdorf",
"433176", "Stubenberg",
"434215", "Liebenfels",
"434872", "Huben",
"432617", "Drassmarkt",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"433182", "Wildon",
"437487", "Gresten",
"432177", "Podersdorf\ am\ See",
"433153", "Riegersburg",
"435212", "Seefeld\ in\ Tirol",
"436456", "Obertauern",
"433150", "Paldau",
"435223", "Hall\ in\ Tirol",
"433583", "Unzmarkt",
"435244", "Jenbach",
"435574", "Bregenz",
"432267", "Sierndorf",
"437682", "Vöcklamarkt",
"437732", "Haag\ am\ Hausruck",
"437254", "Grossraming",
"434785", "Ausserfragant",
"437724", "Mauerkirchen",
"435632", "Stanzach",
"437743", "Maria\ Schmolln",
"434769", "Möllbrücke",
"433571", "Möderbrugg",
"437676", "Ottnang\ am\ Hausruck",
"432237", "Gaaden",
"437762", "Raab",
"432852", "Gmünd",
"433452", "Leibnitz",
"432913", "Hötzelsdorf",
"434732", "Gmünd\ in\ Kärnten",
"434254", "Faak\ am\ See",
"432164", "Rohrau",
"432845", "Weikertschlag\ an\ der\ Thaya",
"437218", "Grosstraberg",
"435474", "Pfunds",
"434762", "Spittal\ an\ der\ Drau",
"437665", "Unterach\ am\ Attersee",
"432859", "Brand\-Nagelberg",
"433852", "Mürzzuschlag",
"437728", "Schwand\ im\ Innkreis",
"432621", "Sieggraben",
"432266", "Stockerau",
"433883", "Terz",
"435335", "Hopfgarten\ im\ Brixental",
"435248", "Steinberg\ am\ Rofan",
"432953", "Nappersdorf",
"435578", "Höchst",
"432236", "Mödling",
"434214", "Brückl",
"432552", "Poysdorf",
"437258", "Bad\ Hall",
"432982", "Horn",
"433859", "Mürzsteg",
"433134", "Heiligenkreuz\ am\ Waasen",
"432275", "Atzenbrugg",
"432812", "Gross\ Gerungs",
"435376", "Thiersee",
"434258", "Gummern",
"435353", "Waidring",
"434826", "Mörtschach",
"432168", "Mannersdorf\ am\ Leithagebirge",
"437613", "Laakirchen",
"433845", "Mautern\ in\ Steiermark",
"432989", "Brunn\ an\ der\ Wild",
"433512", "Knittelfeld",
"436225", "Eugendorf",
"437214", "Reichenthal",
"436227", "St\.\ Gilgen",
"437666", "Attersee",
"433847", "Trofaiach",
"437221", "Hörsching",
"432748", "Kilb",
"436414", "Grossarl",
"437584", "Molln",
"435522", "Feldkirch",
"432846", "Raabs\ an\ der\ Thaya",
"432277", "Zwentendorf",
"437954", "St\.\ Georgen\ am\ Walde",
"437751", "St\.\ Martin\ im\ Innkreis",
"435672", "Reutte",
"433461", "Trahütten",
"436458", "Hüttau",
"437675", "Ampflwang\ im\ Hausruckwald",
"434221", "Gallizien",
"435337", "Brixlegg",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"433618", "Hohentauern",
"436132", "Bad\ Ischl",
"432213", "Lassee",
"437484", "Göstling\ an\ der\ Ybbs",
"432174", "Wallern\ im\ Burgenland",
"432614", "Kleinwarasdorf",
"434825", "Grosskirchheim",
"432253", "Oberwaltersdorf",
"433861", "Aflenz",
"437588", "Ried\ im\ Traunkreis",
"432282", "Gänserndorf",
"433846", "Kalwang",
"437667", "St\.\ Georgen\ im\ Attergau",
"436226", "Fuschl\ am\ See",
"432276", "Reidling",
"432723", "Rabenstein\ an\ der\ Pielach",
"432847", "Gross\-Siegharts",
"436418", "Kleinarl",
"432744", "Kasten\ bei\ Böheimkirchen",
"435375", "Kössen",
"435336", "Alpbach",
"433614", "Rottenmann",
"433174", "Birkfeld",
"432235", "Maria\-Lanzendorf",
"433323", "Eberau",
"437711", "Suben",
"432618", "Markt\ St\.\ Martin",
"437488", "Steinakirchen\ am\ Forst",
"432289", "Matzen",
"432265", "Hausleiten",
"436454", "Mandling",};
$areanames{de} = {"434286", "Weißbriach",
"433632", "Sankt\ Gallen",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433834", "Wald\ am\ Schoberpaß",
"432686", "Draßburg",
"433864", "Sankt\ Marein\ im\ Mürztal",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"435446", "Sankt\ Anton\ am\ Arlberg",
"433464", "Groß\ Sankt\ Florian",
"433119", "Sankt\ Marein\ bei\ Graz",
"432822", "Zwettl\-Niederösterreich",
"433868", "Tragöß",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"436215", "Straßwalchen",
"437224", "Sankt\ Florian",
"434358", "Sankt\ Andrä",
"435352", "Sankt\ Johann\ in\ Tirol",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"433537", "Sankt\ Georgen\ ob\ Murau",
"4316", "Wien",
"433575", "Sankt\ Johann\ am\ Tauern",
"437717", "Sankt\ Aegidi",
"434226", "Sankt\ Margareten\ im\ Rosental",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"433684", "Sankt\ Martin\ am\ Grimming",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434825", "Großkirchheim",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432847", "Groß\-Siegharts",
"432618", "Markt\ Sankt\ Martin",
"436227", "Sankt\ Gilgen",
"436414", "Großarl",
"437751", "Sankt\ Martin\ im\ Innkreis",
"437954", "Sankt\ Georgen\ am\ Walde",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"432812", "Groß\ Gerungs",
"434785", "Außerfragant",
"437254", "Großraming",
"437218", "Großtraberg",
"434879", "Sankt\ Veit\ in\ Defereggen",
"432617", "Draßmarkt",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"432823", "Großglobnitz",
"437956", "Unterweißenbach",
"435245", "Hinterriß",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"432642", "Aspangberg\-Sankt\ Peter",
"434843", "Außervillgraten",
"432719", "Droß",
"432268", "Großmugl",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"433585", "Sankt\ Lambrecht",
"434783", "Reißeck",
"433327", "Sankt\ Michael\ im\ Burgenland",
"434264", "Klein\ Sankt\ Paul",
"433158", "Sankt\ Anna\ am\ Aigen",
"433469", "Sankt\ Oswald\ im\ Freiland",
"432955", "Großweikersdorf",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"432674", "Weißenbach\ an\ der\ Triesting",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"4317", "Wien",
"432629", "Warth\,\ Niederösterreich",
"432249", "Groß\-Enzersdorf",
"4313", "Wien",
"432233", "Preßbaum",
"432263", "Großrußbach",
"432242", "Sankt\ Andrä\-Wördern",
"435279", "Sankt\ Jodok\ am\ Brenner",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"434266", "Straßburg",
"436477", "Sankt\ Michael\ im\ Lungau",
"435449", "Fließ",
"436247", "Großgmain",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"433362", "Großpetersdorf",
"436565", "Neukirchen\ am\ Großvenediger",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"4315", "Wien",
"434253", "Sankt\ Jakob\ im\ Rosental",
"4314", "Wien",
"4318", "Wien",
"433386", "Großsteinbach",
"435557", "Sankt\ Gallenkirch",
"432647", "Krumbach\,\ Niederösterreich",
"436277", "Sankt\ Pantaleon",
"437566", "Rosenau\ am\ Hengstpaß",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"4319", "Wien",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"432756", "Sankt\ Leonhard\ am\ Forst",
"437219", "Vorderweißenbach",
"436276", "Nußdorf\ am\ Haunsberg",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"436412", "Sankt\ Johann\ im\ Pongau",
"437435", "Sankt\ Valentin",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"437565", "Sankt\ Pankraz",
"4312", "Wien",
"434877", "Prägraten\ am\ Großvenediger",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"435678", "Weißenbach\ am\ Lech",
"436241", "Sankt\ Koloman",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"432742", "Sankt\ Pölten",
"437477", "Sankt\ Peter\ in\ der\ Au",
"434876", "Kals\ am\ Großglockner",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"432857", "Bad\ Großpertholz",
"432556", "Großkrut",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"432815", "Großschönau",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;