#!/usr/bin/perl -w
use strict;
use ExtUtils::MakeMaker;

my $build_requires = {
        'ExtUtils::MakeMaker'   => 6.60,
        'Test::More'            => 0.94,
    };

my $prereq_pm = {
        'Mojolicious'           => 7.94,    # Ubuntu = libmojolicious-perl          RHEL = perl-Mojolicious
        'Sys::Syslog'           => 0,
    };

WriteMakefile(
    'NAME'              => 'WWW::Suffit::Plugin::Syslog',
    'MIN_PERL_VERSION'  => 5.020,
    'VERSION_FROM'      => 'lib/WWW/Suffit/Plugin/Syslog.pm',
    'ABSTRACT_FROM'     => 'lib/WWW/Suffit/Plugin/Syslog.pm',
    'BUILD_REQUIRES'    => $build_requires,
    'PREREQ_PM'         => $prereq_pm,
    'AUTHOR'            => 'Serz Minus (Sergey Lepenkov) <abalama@cpan.org>',
    'LICENSE'           => 'artistic_2',
    'META_MERGE'        => {
        'meta-spec' => {version => 2},
        prereqs     => {runtime => {requires => {perl => '5.020'}}},
        resources   => {
            homepage    => 'https://sourceforge.net/projects/www-suffit-plugin-syslog/',
            license     => 'https://opensource.org/license/artistic-2-0',
            repository      => {
                    type => 'git',
                    url  => 'https://abalama@git.code.sf.net/p/www-suffit-plugin-syslog/code',
                    web  => 'https://sourceforge.net/p/www-suffit-plugin-syslog/code/ci/master/tree/',
                  },
        },
    },
);

1;
