/*!The Treasure Box Library
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (C) 2009-present, TBOOX Open Source Group.
 *
 * @author      ruki
 * @file        sqlite3.h
 */
#ifndef TB_DATABASE_IMPL_SQLITE3_H
#define TB_DATABASE_IMPL_SQLITE3_H

/* //////////////////////////////////////////////////////////////////////////////////////
 * includes
 */
#include "prefix.h"

/* //////////////////////////////////////////////////////////////////////////////////////
 * extern
 */
__tb_extern_c_enter__

/* //////////////////////////////////////////////////////////////////////////////////////
 * interfaces
 */

/* probe sqlite3 from the url
 *
 * @param url               the database url
 *
 * @return                  the score
 */
tb_size_t                   tb_database_sqlite3_probe(tb_url_ref_t url);

/* init sqlite3
 *
 * @param url               the database url
 *
 * @return                  the database handle
 */
tb_database_sql_ref_t       tb_database_sqlite3_init(tb_url_ref_t url);

/* //////////////////////////////////////////////////////////////////////////////////////
 * extern
 */
__tb_extern_c_leave__

#endif
