use std::ffi::CString;

#[tokio::main]
async fn main() -> udisks2::Result<()> {
    let client = udisks2::Client::new().await?;

    for object in client
        .object_manager()
        .get_managed_objects()
        .await?
        .into_iter()
        .filter_map(|(object_path, _)| client.object(object_path).ok())
    {
        //only use objects that have a drive
        let Ok(fs) = object.filesystem().await else {
            continue;
        };

        // print path and mount point
        for mount_point in fs
            .mount_points()
            .await
            .unwrap()
            .iter()
            .filter_map(|p| CString::from_vec_with_nul(p.to_vec()).ok())
            .filter_map(|p| p.to_str().map(|p| p.to_string()).ok())
        {
            println!("{}:{:?}", object.object_path(), mount_point);
        }
    }
    Ok(())
}
