Generic `Atomic<T>` for Rust
============================

[![Build Status](https://travis-ci.org/Amanieu/atomic-rs.svg?branch=master)](https://travis-ci.org/Amanieu/atomic-rs) [![Crates.io](https://img.shields.io/crates/v/atomic.svg)](https://crates.io/crates/atomic)

A Rust library which provides a generic `Atomic<T>` type for all `T: NoUninit` types, unlike the standard library which only provides a few fixed atomic types (`AtomicBool`, `AtomicIsize`, `AtomicUsize`, `AtomicPtr`). The `NoUninit` bound is from the [bytemuck] crate, and indicates that a type has no internal padding bytes. You will need to derive or implement this trait for all types used with `Atomic<T>`.

This library will use native atomic instructions if possible, and will otherwise fall back to a lock-based mechanism. You can use the `Atomic::<T>::is_lock_free()` function to check whether native atomic operations are supported for a given type. Note that a type must have a power-of-2 size and alignment in order to be used by native atomic instructions.

This crate uses `#![no_std]` and only depends on libcore.

[bytemuck]: https://docs.rs/bytemuck

[Documentation](https://docs.rs/atomic)

## Features

This crate has the following [Cargo
features](https://doc.rust-lang.org/cargo/reference/features.html):

* `fallback`: Fall back to locks when atomic instructions cannot be
  used. (Enabled by default.)
* `serde`: Enables serialization and serialization of `Atomic<T>` with
  [serde](https://docs.rs/serde/latest/serde/).

## Usage

Add this to your `Cargo.toml`:

```toml
[dependencies]
atomic = "0.6"
```

and this to your crate root:

```rust
extern crate atomic;
```

## License

Licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any
additional terms or conditions.
