// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Path, PathPoint, RoundedRect, ffi};
use glib::translate::*;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct PathBuilder(Shared<ffi::GskPathBuilder>);

    match fn {
        ref => |ptr| ffi::gsk_path_builder_ref(ptr),
        unref => |ptr| ffi::gsk_path_builder_unref(ptr),
        type_ => || ffi::gsk_path_builder_get_type(),
    }
}

impl PathBuilder {
    #[doc(alias = "gsk_path_builder_new")]
    pub fn new() -> PathBuilder {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gsk_path_builder_new()) }
    }

    #[doc(alias = "gsk_path_builder_add_circle")]
    pub fn add_circle(&self, center: &graphene::Point, radius: f32) {
        unsafe {
            ffi::gsk_path_builder_add_circle(
                self.to_glib_none().0,
                center.to_glib_none().0,
                radius,
            );
        }
    }

    #[doc(alias = "gsk_path_builder_add_layout")]
    pub fn add_layout(&self, layout: &pango::Layout) {
        unsafe {
            ffi::gsk_path_builder_add_layout(self.to_glib_none().0, layout.to_glib_none().0);
        }
    }

    #[doc(alias = "gsk_path_builder_add_path")]
    pub fn add_path(&self, path: &Path) {
        unsafe {
            ffi::gsk_path_builder_add_path(self.to_glib_none().0, path.to_glib_none().0);
        }
    }

    #[doc(alias = "gsk_path_builder_add_rect")]
    pub fn add_rect(&self, rect: &graphene::Rect) {
        unsafe {
            ffi::gsk_path_builder_add_rect(self.to_glib_none().0, rect.to_glib_none().0);
        }
    }

    #[doc(alias = "gsk_path_builder_add_reverse_path")]
    pub fn add_reverse_path(&self, path: &Path) {
        unsafe {
            ffi::gsk_path_builder_add_reverse_path(self.to_glib_none().0, path.to_glib_none().0);
        }
    }

    #[doc(alias = "gsk_path_builder_add_rounded_rect")]
    pub fn add_rounded_rect(&self, rect: &RoundedRect) {
        unsafe {
            ffi::gsk_path_builder_add_rounded_rect(self.to_glib_none().0, rect.to_glib_none().0);
        }
    }

    #[doc(alias = "gsk_path_builder_add_segment")]
    pub fn add_segment(&self, path: &Path, start: &PathPoint, end: &PathPoint) {
        unsafe {
            ffi::gsk_path_builder_add_segment(
                self.to_glib_none().0,
                path.to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gsk_path_builder_arc_to")]
    pub fn arc_to(&self, x1: f32, y1: f32, x2: f32, y2: f32) {
        unsafe {
            ffi::gsk_path_builder_arc_to(self.to_glib_none().0, x1, y1, x2, y2);
        }
    }

    #[doc(alias = "gsk_path_builder_close")]
    pub fn close(&self) {
        unsafe {
            ffi::gsk_path_builder_close(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gsk_path_builder_conic_to")]
    pub fn conic_to(&self, x1: f32, y1: f32, x2: f32, y2: f32, weight: f32) {
        unsafe {
            ffi::gsk_path_builder_conic_to(self.to_glib_none().0, x1, y1, x2, y2, weight);
        }
    }

    #[doc(alias = "gsk_path_builder_cubic_to")]
    pub fn cubic_to(&self, x1: f32, y1: f32, x2: f32, y2: f32, x3: f32, y3: f32) {
        unsafe {
            ffi::gsk_path_builder_cubic_to(self.to_glib_none().0, x1, y1, x2, y2, x3, y3);
        }
    }

    #[doc(alias = "gsk_path_builder_get_current_point")]
    #[doc(alias = "get_current_point")]
    pub fn current_point(&self) -> graphene::Point {
        unsafe {
            from_glib_none(ffi::gsk_path_builder_get_current_point(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gsk_path_builder_html_arc_to")]
    pub fn html_arc_to(&self, x1: f32, y1: f32, x2: f32, y2: f32, radius: f32) {
        unsafe {
            ffi::gsk_path_builder_html_arc_to(self.to_glib_none().0, x1, y1, x2, y2, radius);
        }
    }

    #[doc(alias = "gsk_path_builder_line_to")]
    pub fn line_to(&self, x: f32, y: f32) {
        unsafe {
            ffi::gsk_path_builder_line_to(self.to_glib_none().0, x, y);
        }
    }

    #[doc(alias = "gsk_path_builder_move_to")]
    pub fn move_to(&self, x: f32, y: f32) {
        unsafe {
            ffi::gsk_path_builder_move_to(self.to_glib_none().0, x, y);
        }
    }

    #[doc(alias = "gsk_path_builder_quad_to")]
    pub fn quad_to(&self, x1: f32, y1: f32, x2: f32, y2: f32) {
        unsafe {
            ffi::gsk_path_builder_quad_to(self.to_glib_none().0, x1, y1, x2, y2);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_arc_to")]
    pub fn rel_arc_to(&self, x1: f32, y1: f32, x2: f32, y2: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_arc_to(self.to_glib_none().0, x1, y1, x2, y2);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_conic_to")]
    pub fn rel_conic_to(&self, x1: f32, y1: f32, x2: f32, y2: f32, weight: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_conic_to(self.to_glib_none().0, x1, y1, x2, y2, weight);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_cubic_to")]
    pub fn rel_cubic_to(&self, x1: f32, y1: f32, x2: f32, y2: f32, x3: f32, y3: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_cubic_to(self.to_glib_none().0, x1, y1, x2, y2, x3, y3);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_html_arc_to")]
    pub fn rel_html_arc_to(&self, x1: f32, y1: f32, x2: f32, y2: f32, radius: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_html_arc_to(self.to_glib_none().0, x1, y1, x2, y2, radius);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_line_to")]
    pub fn rel_line_to(&self, x: f32, y: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_line_to(self.to_glib_none().0, x, y);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_move_to")]
    pub fn rel_move_to(&self, x: f32, y: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_move_to(self.to_glib_none().0, x, y);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_quad_to")]
    pub fn rel_quad_to(&self, x1: f32, y1: f32, x2: f32, y2: f32) {
        unsafe {
            ffi::gsk_path_builder_rel_quad_to(self.to_glib_none().0, x1, y1, x2, y2);
        }
    }

    #[doc(alias = "gsk_path_builder_rel_svg_arc_to")]
    pub fn rel_svg_arc_to(
        &self,
        rx: f32,
        ry: f32,
        x_axis_rotation: f32,
        large_arc: bool,
        positive_sweep: bool,
        x: f32,
        y: f32,
    ) {
        unsafe {
            ffi::gsk_path_builder_rel_svg_arc_to(
                self.to_glib_none().0,
                rx,
                ry,
                x_axis_rotation,
                large_arc.into_glib(),
                positive_sweep.into_glib(),
                x,
                y,
            );
        }
    }

    #[doc(alias = "gsk_path_builder_svg_arc_to")]
    pub fn svg_arc_to(
        &self,
        rx: f32,
        ry: f32,
        x_axis_rotation: f32,
        large_arc: bool,
        positive_sweep: bool,
        x: f32,
        y: f32,
    ) {
        unsafe {
            ffi::gsk_path_builder_svg_arc_to(
                self.to_glib_none().0,
                rx,
                ry,
                x_axis_rotation,
                large_arc.into_glib(),
                positive_sweep.into_glib(),
                x,
                y,
            );
        }
    }

    #[doc(alias = "gsk_path_builder_to_path")]
    pub fn to_path(&self) -> Path {
        unsafe { from_glib_full(ffi::gsk_path_builder_to_path(self.to_glib_none().0)) }
    }
}

#[cfg(feature = "v4_14")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
impl Default for PathBuilder {
    fn default() -> Self {
        Self::new()
    }
}
