// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-proxy-object-internal-methods-and-internal-slots-call-thisargument-argumentslist
es6id: 9.5.13
description: >
  Throws if trap is not callable (honoring the Realm of the current execution
  context)
features: [cross-realm]
---*/

var OProxy = $262.createRealm().global.Proxy;
var p = new OProxy(function() {}, {
  apply: {}
});

assert.throws(TypeError, function() {
  p();
});

reportCompare(0, 0);
