/*
 * Copyright (c) 2020-2026 Valve Corporation
 * Copyright (c) 2020-2026 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Authors:
 * - Christophe Riccio <christophe@lunarg.com>
 */

#pragma once

#include "tab.h"

class TabDrivers : public Tab {
    Q_OBJECT

   public:
    TabDrivers(MainWindow &window, std::shared_ptr<Ui::MainWindow> ui);
    virtual ~TabDrivers();

    virtual void UpdateUI(UpdateUIMode mode) override;
    virtual void CleanUI() override;
    virtual bool EventFilter(QObject *target, QEvent *event) override;

   public Q_SLOTS:
    void on_driver_override_toggled(bool checked);
    void on_driver_mode_changed(int index);
    void on_driver_name_changed(int index);

    void on_driver_paths_toggled(bool checked);
    void on_paths_changed();
    void on_paths_toggled();
    void on_driver_append_pressed();
    void on_driver_browse_pressed();

   private:
    std::string new_path;
};
