/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.loader;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.util.ConfigUtil;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.config.xml.XMLHelper;
import com.metamatrix.common.config.xml.XMLHelperUtil;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBModelDefn;
import com.metamatrix.common.xml.XMLReaderWriter;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBModelDefn;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class VDBDefnXMLHelper {
    private static final String DEFAULT_USER_CREATED_BY = "VDBWriter";
    private XMLHelper cfgXMLHelper = null;

    protected Element getRoot(File f) throws Exception {
        FileInputStream in = new FileInputStream(f);
        Document doc = null;
        String fileName = f.getName();
        String absolutePath = f.getAbsolutePath();
        try {
            doc = this.getXMLReaderWriter().readDocument((InputStream)in);
        }
        catch (JDOMException e) {
            System.out.println(absolutePath);
            e.printStackTrace();
            throw new IOException(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Unable_to_read_file", (Object)fileName));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return doc.getRootElement();
    }

    protected Element getRoot(char[] defFile) throws Exception {
        InputStream in = ObjectConverterUtil.convertToInputStream((String)new String(defFile));
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(in);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new IOException(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Unable_to_read_defn_file"));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return doc.getRootElement();
    }

    private XMLReaderWriter getXMLReaderWriter() {
        return new XMLReaderWriterImpl();
    }

    public Element createRootDocumentElement() {
        return new Element("VDB");
    }

    public Element createVDBInfoElement(VDBDefn defn, String archiveFileName) {
        if (defn == null) {
            ArgCheck.isNotNull((Object)defn, (String)VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_VDB_defintion"));
        }
        Element vdbInfoElement = new Element("VDBInfo");
        String v = null;
        v = defn.getName();
        this.addPropertyElement(vdbInfoElement, "Name", v);
        v = defn.getUUID();
        if (v != null) {
            this.addPropertyElement(vdbInfoElement, "GUID", v);
        }
        if ((v = defn.getVersion()) != null && v.length() > 0) {
            this.addPropertyElement(vdbInfoElement, "Version", v);
        }
        if (archiveFileName != null) {
            v = archiveFileName;
        } else {
            v = defn.getFileName();
            if (v == null) {
                v = defn.getName();
            }
        }
        this.addPropertyElement(vdbInfoElement, "VDBArchiveName", v);
        v = defn.getDescription();
        if (v != null) {
            this.addPropertyElement(vdbInfoElement, "Description", v);
        }
        return vdbInfoElement;
    }

    public Element createVDBModelElement(VDBModelDefn modelDefn) {
        if (modelDefn == null) {
            ArgCheck.isNotNull((Object)modelDefn, (String)VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_VDB_model"));
        }
        Element vdbModelElement = new Element("Model");
        this.addPropertyElement(vdbModelElement, "Name", modelDefn.getName());
        if (modelDefn.isVisible()) {
            this.addPropertyElement(vdbModelElement, "Visibility", "Public");
        } else {
            this.addPropertyElement(vdbModelElement, "Visibility", "Private");
        }
        this.addPropertyElement(vdbModelElement, "MultiSourceEnabled", new Boolean(modelDefn.isMultiSourceBindingEnabled()).toString());
        return vdbModelElement;
    }

    protected void addPropertyElement(Element element, String name, String value) {
        if (element == null) {
            ArgCheck.isNotNull((Object)element, (String)VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_elment_property"));
        }
        if (name == null) {
            ArgCheck.isNotNull((Object)name, (String)VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_element_name"));
        }
        if (value == null) {
            ArgCheck.isNotNull((Object)value, (String)VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_element_value", (Object)name));
        }
        Element propElement = new Element("Property");
        propElement.setAttribute("Name", name);
        propElement.setAttribute("Value", value);
        element.addContent((Content)propElement);
    }

    public VDBDefn createVDBDefn(Element root, File archiveSoftReference) throws Exception {
        Element vdbInfoElement = root.getChild("VDBInfo");
        if (vdbInfoElement == null) {
            throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_xml_section", (Object)"VDBInfo"));
        }
        Properties vdbProps = this.getElementProperties(vdbInfoElement);
        if (vdbProps == null || vdbProps.isEmpty()) {
            throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.No_properties_defined_to_create_defn", (Object)"VDBInfo"));
        }
        String vdbName = vdbProps.getProperty("Name");
        if (vdbName == null) {
            Assertion.isNotNull((Object)vdbName, (String)VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_VDB_name"));
        }
        BasicVDBDefn defn = null;
        defn = archiveSoftReference != null ? new BasicVDBDefn(vdbName, archiveSoftReference) : new BasicVDBDefn(vdbName);
        return this.loadVDBDefn(defn, vdbProps);
    }

    public VDBDefn createVDBDefn(VirtualDatabase vdb, File archiveSoftReference) throws Exception {
        BasicVDBDefn defn = null;
        defn = archiveSoftReference != null ? new BasicVDBDefn(vdb.getName(), archiveSoftReference) : new BasicVDBDefn(vdb.getName());
        if (vdb.getVersion() == null) {
            defn.setVersion("1");
        } else {
            defn.setVersion(vdb.getVersion());
        }
        defn.setDescription(vdb.getDescription());
        defn.setUUID(vdb.getUuid());
        defn.setFileName(vdb.getName() + ".vdb");
        defn.setDateCreated(vdb.getTimeLastChangedAsDate());
        return defn;
    }

    public void addVDBDefnInfo(VDBDefn vdbdefn, Element root) throws Exception {
        BasicVDBDefn defn = (BasicVDBDefn)vdbdefn;
        Element vdbInfoElement = root.getChild("VDBInfo");
        if (vdbInfoElement == null) {
            throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_xml_section", (Object)"VDBInfo"));
        }
        Properties vdbProps = this.getElementProperties(vdbInfoElement);
        if (vdbProps == null || vdbProps.isEmpty()) {
            throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.No_properties_defined_to_create_defn", (Object)"VDBInfo"));
        }
        this.loadVDBDefn(defn, vdbProps);
    }

    private VDBDefn loadVDBDefn(BasicVDBDefn defn, Properties vdbProps) throws Exception {
        String vdbName = vdbProps.getProperty("Name");
        if (vdbName != null && vdbName.length() > 0) {
            defn.setName(vdbName);
        }
        String vdbVersion = vdbProps.getProperty("Version");
        String vdbArchiveName = vdbProps.getProperty("VDBArchiveName");
        String desc = vdbProps.getProperty("Description", defn.getName());
        String guid = vdbProps.getProperty("GUID", defn.getName());
        if (vdbVersion != null) {
            defn.setVersion(vdbVersion);
        }
        if (vdbArchiveName != null) {
            defn.setFileName(vdbArchiveName);
        }
        if (defn.getUUID() == null && guid != null) {
            defn.setUUID(guid);
        }
        if (desc != null) {
            defn.setDescription(desc);
        }
        return defn;
    }

    public VDBDefn addModelInfo42(Element root, VDBDefn vdbDefn, ConfigurationModelContainer cmc) throws Exception {
        Collection cmc_bindings;
        XMLConfigurationImportExportUtility importUtil = new XMLConfigurationImportExportUtility();
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        HashMap<String, ConnectorBinding> bindingMap = null;
        HashMap<String, ComponentType> typeMap = null;
        List modelsElements = root.getChildren("Model");
        Collection modelEntries = vdbDefn.getModels();
        HashMap<String, BasicVDBModelDefn> meMap = new HashMap<String, BasicVDBModelDefn>(modelEntries.size());
        Iterator it = modelEntries.iterator();
        while (it.hasNext()) {
            BasicVDBModelDefn e = (BasicVDBModelDefn)it.next();
            meMap.put(e.getName(), e);
        }
        Collection bindings = importUtil.importConnectorBindings(root, (ConfigurationObjectEditor)editor);
        Collection types = importUtil.importComponentTypes(root, (ConfigurationObjectEditor)editor, true);
        BasicVDBDefn defn = (BasicVDBDefn)vdbDefn;
        typeMap = cmc != null ? cmc.getComponentTypes() : new HashMap<String, ComponentType>();
        if (types != null && types.size() > 0) {
            Iterator itypes = types.iterator();
            while (itypes.hasNext()) {
                ComponentType t = (ComponentType)itypes.next();
                typeMap.put(t.getFullName(), t);
            }
        }
        bindingMap = new HashMap<String, ConnectorBinding>();
        if (cmc != null && (cmc_bindings = cmc.getConfiguration().getConnectorBindings()) != null && cmc_bindings.size() > 0) {
            Iterator it2 = cmc_bindings.iterator();
            while (it2.hasNext()) {
                ConnectorBinding cb = (ConnectorBinding)it2.next();
                bindingMap.put(cb.getFullName(), cb);
            }
        }
        if (bindings != null && bindings.size() > 0) {
            Iterator iBindings = bindings.iterator();
            while (iBindings.hasNext()) {
                ConnectorBinding b = (ConnectorBinding)iBindings.next();
                bindingMap.put(b.getFullName(), b);
            }
        }
        Iterator iterator = modelsElements.iterator();
        while (iterator.hasNext()) {
            List connectorBindings;
            Element connectorBindingsEle;
            Element modelElement = (Element)iterator.next();
            Properties props = this.getElementProperties(modelElement);
            if (props == null || props.isEmpty()) {
                throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.No_properties_defined_to_create_defn", (Object)"Model"));
            }
            String name = props.getProperty("Name");
            if (name == null) {
                throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.No_name_defined", (Object)"Name"));
            }
            BasicVDBModelDefn m = (BasicVDBModelDefn)meMap.get(name);
            if (m == null) continue;
            String visibility = props.getProperty("Visibility");
            if (visibility.equalsIgnoreCase("Public")) {
                m.setIsVisible(true);
            } else {
                m.setIsVisible(false);
            }
            String multiSourceEnabled = props.getProperty("MultiSourceEnabled", Boolean.FALSE.toString());
            if (multiSourceEnabled != null && multiSourceEnabled.equalsIgnoreCase(Boolean.TRUE.toString())) {
                m.enableMutliSourceBindings(true);
            } else {
                m.enableMutliSourceBindings(false);
            }
            if ((connectorBindingsEle = modelElement.getChild("ConnectorBindings")) == null || (connectorBindings = connectorBindingsEle.getChildren("Connector")) == null) continue;
            Iterator itr = connectorBindings.iterator();
            while (itr.hasNext()) {
                ConnectorBinding binding;
                Element connectorBindingElement = (Element)itr.next();
                String bindingName = connectorBindingElement.getAttributeValue("Name");
                if (bindingName == null || bindingName.length() <= 0 || (binding = (ConnectorBinding)bindingMap.get(bindingName)) == null) continue;
                ComponentType cmcT = (ComponentType)typeMap.get(binding.getComponentTypeID().getFullName());
                if (cmcT != null) {
                    defn.addConnectorType(cmcT);
                }
                defn.addConnectorBinding(m.getName(), binding);
            }
        }
        return defn;
    }

    public boolean containsModelInfo(Element root) throws Exception {
        List modelsElements = root.getChildren("Model");
        return modelsElements != null && modelsElements.size() != 0;
    }

    public VDBDefn addModelInfo(Element root, VDBDefn vdbDefn, ConfigurationModelContainer cmc) throws Exception {
        List modelsElements = root.getChildren("Model");
        Collection modelEntries = vdbDefn.getModels();
        HashMap<String, BasicVDBModelDefn> meMap = new HashMap<String, BasicVDBModelDefn>(modelEntries.size());
        Iterator it = modelEntries.iterator();
        while (it.hasNext()) {
            BasicVDBModelDefn e = (BasicVDBModelDefn)it.next();
            meMap.put(e.getName(), e);
        }
        HashMap<BaseID, ComponentType> types = new HashMap<BaseID, ComponentType>();
        HashMap<String, ConnectorBinding> bindings = new HashMap<String, ConnectorBinding>();
        BasicVDBDefn defn = (BasicVDBDefn)vdbDefn;
        Iterator iterator = modelsElements.iterator();
        while (iterator.hasNext()) {
            Element modelElement = (Element)iterator.next();
            Properties props = this.getElementProperties(modelElement);
            if (props == null || props.isEmpty()) {
                throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.No_properties_defined_to_create_defn", (Object)"Model"));
            }
            String name = props.getProperty("Name");
            if (name == null) {
                throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.No_name_defined", (Object)"Name"));
            }
            BasicVDBModelDefn m = (BasicVDBModelDefn)meMap.get(name);
            if (m == null) continue;
            String visibility = props.getProperty("Visibility");
            if (visibility.equalsIgnoreCase("Public")) {
                m.setIsVisible(true);
            } else {
                m.setIsVisible(false);
            }
            defn.addModelInfo((ModelInfo)m);
            Element typeElement = modelElement.getChild("ComponentType");
            Element bindingElement = modelElement.getChild("Connector");
            if (typeElement != null) {
                ComponentType type = this.getConfigXMLHelper().createComponentType(typeElement, this.getEditor(), null, true);
                if (cmc != null && cmc.getComponentType(type.getFullName()) != null) {
                    type = cmc.getComponentType(type.getFullName());
                }
                if (!types.containsKey(type.getID())) {
                    defn.addConnectorType(type);
                    types.put(type.getID(), type);
                }
            }
            String bindingName = null;
            ConnectorBinding binding = null;
            if (bindingElement != null) {
                binding = this.getConfigXMLHelper().createConnectorBinding(Configuration.NEXT_STARTUP_ID, bindingElement, this.getEditor(), null, false);
                if (cmc != null && cmc.getConfiguration().getConnectorBinding(binding.getFullName()) != null) {
                    binding = cmc.getConfiguration().getConnectorBinding(binding.getFullName());
                }
                if (!bindings.containsKey(binding.getFullName())) {
                    defn.addConnectorBinding(binding);
                    bindings.put(binding.getFullName(), binding);
                } else {
                    binding = (ConnectorBinding)bindings.get(binding.getFullName());
                }
                bindingName = binding.getFullName();
            } else {
                bindingName = props.getProperty("ConnectorBindingName");
            }
            if (bindingName == null || bindingName.length() <= 0) continue;
            m.addConnectorBindingByName(bindingName);
        }
        return defn;
    }

    protected Properties getElementProperties(Element elementProperties) {
        Properties properties = new Properties();
        List propertyElements = elementProperties.getChildren("Property");
        if (propertyElements != null) {
            Iterator iterator = propertyElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                String value = element.getAttributeValue("Value");
                if (name != null && name.length() > 0) {
                    properties.setProperty(name, value);
                }
                ++i;
            }
        }
        return properties;
    }

    private ConfigurationObjectEditor getEditor() {
        return ConfigUtil.getEditor();
    }

    private XMLHelper getConfigXMLHelper() {
        if (this.cfgXMLHelper == null) {
            this.cfgXMLHelper = new XMLConfig_42_HelperImpl();
        }
        return this.cfgXMLHelper;
    }

    public void addConnectorRefs(Collection connectorBindingNames, Element model) {
        if (connectorBindingNames != null && connectorBindingNames.size() > 0) {
            Element connectorBindingsElement = new Element("ConnectorBindings");
            Iterator iter = connectorBindingNames.iterator();
            while (iter.hasNext()) {
                Element aConnectorBindingElement = new Element("Connector");
                String name = (String)iter.next();
                aConnectorBindingElement.setAttribute("Name", name);
                connectorBindingsElement.addContent((Content)aConnectorBindingElement);
            }
            model.addContent((Content)connectorBindingsElement);
        }
    }

    public Element addHeaderElement(Element root, Properties properties) {
        root.addContent((Content)this.createHeaderElement(properties));
        return root;
    }

    public static boolean is41Compatible(Element root) throws IOException {
        Element headerElement = root.getChild("Header");
        if (headerElement == null) {
            return false;
        }
        Properties props = new VDBDefnXMLHelper().getHeaderProperties(headerElement);
        return VDBDefnXMLHelper.is41Compatible(props);
    }

    public static boolean is41Compatible(Properties props) {
        String sVersion = props.getProperty("VDBExporterVersion");
        if (sVersion == null) {
            return VDBDefnXMLHelper.is42ConfigurationCompatible(props);
        }
        try {
            try {
                double sv = Double.parseDouble(sVersion);
                if (sv >= 4.1) {
                    return true;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            return VDBDefnXMLHelper.is42ConfigurationCompatible(props);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final boolean is42ConfigurationCompatible(Properties props) {
        try {
            return XMLHelperUtil.is42ConfigurationCompatible((Properties)props);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public final Properties getHeaderProperties(Element element) throws IOException {
        Properties props = new Properties();
        if (!element.getName().equals("Header") && (element = element.getChild("Header")) == null) {
            return props;
        }
        List elements = element.getChildren();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            props.setProperty(e.getName(), e.getText());
        }
        return props;
    }

    public Element createHeaderElement(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        Element headerElement = new Element("Header");
        String applicationCreatedByContent = props.getProperty("ApplicationCreatedBy");
        String applicationVersionCreatedByContent = props.getProperty("ApplicationVersion");
        String userNameContent = props.getProperty("UserCreatedBy");
        String vdbVersionContent = "4.1";
        String serverVersionContent = "5.0";
        String timeContent = DateUtil.getCurrentDateAsString();
        Element configurationVersion = new Element("VDBExporterVersion");
        configurationVersion.addContent(vdbVersionContent);
        headerElement.addContent((Content)configurationVersion);
        if (applicationCreatedByContent != null) {
            Element applicationCreatedBy = new Element("ApplicationCreatedBy");
            applicationCreatedBy.addContent(applicationCreatedByContent);
            headerElement.addContent((Content)applicationCreatedBy);
        }
        if (applicationVersionCreatedByContent != null) {
            Element applicationVersionCreatedBy = new Element("ApplicationVersion");
            applicationVersionCreatedBy.addContent(applicationVersionCreatedByContent);
            headerElement.addContent((Content)applicationVersionCreatedBy);
        }
        if (userNameContent == null) {
            userNameContent = DEFAULT_USER_CREATED_BY;
        }
        Element userName = new Element("UserCreatedBy");
        userName.addContent(userNameContent);
        headerElement.addContent((Content)userName);
        Element serverVersion = new Element("MetaMatrixSystemVersion");
        serverVersion.addContent(serverVersionContent);
        headerElement.addContent((Content)serverVersion);
        Element time = new Element("Time");
        time.addContent(timeContent);
        headerElement.addContent((Content)time);
        return headerElement;
    }

    public void updateVDBName(Element root, String newname, String archiveName) throws Exception {
        Element vdbInfoElement = root.getChild("VDBInfo");
        if (vdbInfoElement == null) {
            throw new Exception(VdbEditPlugin.Util.getString("VDBDefnXMLHelper.Invalid_xml_section", (Object)"VDBInfo"));
        }
        List propertyElements = vdbInfoElement.getChildren("Property");
        if (propertyElements != null) {
            Iterator iterator = propertyElements.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.getAttributeValue("Name");
                if (name.equalsIgnoreCase("Name")) {
                    element.setAttribute("Value", newname);
                } else if (name.equalsIgnoreCase("VDBArchiveName")) {
                    element.setAttribute("Value", archiveName);
                }
                ++i;
            }
        }
    }
}

