/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.BindValueVisitor;
import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.util.FunctionReplacementVisitor;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import com.metamatrix.data.visitor.util.CollectorVisitor;
import com.metamatrix.data.visitor.util.NamingCorrectionVisitor;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TranslatedCommand {
    public static final int EXEC_TYPE_QUERY = 0;
    public static final int EXEC_TYPE_UPDATE = 1;
    public static final int EXEC_TYPE_EXECUTE = 2;
    public static final int STMT_TYPE_STATEMENT = 0;
    public static final int STMT_TYPE_PREPARED_STATEMENT = 1;
    public static final int STMT_TYPE_CALLABLE_STATEMENT = 2;
    private String sql;
    private int executionType;
    private int statementType;
    private List preparedValues;
    private List preparedTypes;
    private SQLConversionVisitor sqlConversionVisitor;
    private FunctionReplacementVisitor functionVisitor;
    private ExecutionContext context;
    private SQLTranslator sqlTranslator;
    static /* synthetic */ Class class$com$metamatrix$data$language$ILiteral;

    public TranslatedCommand(ExecutionContext context, SQLTranslator sqlTranslator) {
        this.context = context;
        this.sqlTranslator = sqlTranslator;
        Map modifiers = sqlTranslator.getFunctionModifiers();
        this.sqlConversionVisitor = sqlTranslator.getTranslationVisitor();
        this.sqlConversionVisitor.setFunctionModifiers(modifiers);
        this.sqlConversionVisitor.setExecutionContext(context);
        this.functionVisitor = new FunctionReplacementVisitor(modifiers);
    }

    public TranslatedCommand(ExecutionContext context, SQLTranslator sqlTranslator, SQLConversionVisitor sqlConversionVisitor, FunctionReplacementVisitor functionVisitor) {
        this.context = context;
        this.sqlTranslator = sqlTranslator;
        this.sqlConversionVisitor = sqlConversionVisitor;
        this.functionVisitor = functionVisitor;
    }

    public void translateCommand(ICommand command) throws ConnectorException {
        this.sql = this.getSQL(command);
        this.statementType = this.sqlConversionVisitor.getStmtType();
        this.executionType = this.sqlConversionVisitor.getExecType();
        this.preparedValues = this.sqlConversionVisitor.getPreparedValues();
        this.preparedTypes = this.sqlConversionVisitor.getPreparedTypes();
    }

    private String getSQL(ICommand command) throws ConnectorException {
        NamingCorrectionVisitor visitor = new NamingCorrectionVisitor((SQLStringVisitor)this.sqlConversionVisitor);
        command.acceptVisitor((LanguageObjectVisitor)visitor);
        command = this.sqlTranslator.modifyCommand(command, this.context);
        command.acceptVisitor((LanguageObjectVisitor)this.functionVisitor);
        if (this.sqlConversionVisitor.getStmtType() == 1 || this.hasBindValue(command)) {
            this.sqlConversionVisitor.setStmtType(1);
            command.acceptVisitor((LanguageObjectVisitor)new BindValueVisitor());
        }
        this.sqlConversionVisitor.append((ILanguageObject)command);
        return this.sqlConversionVisitor.toString();
    }

    private boolean hasBindValue(ICommand command) {
        Collection literals = CollectorVisitor.collectObjects((Class)(class$com$metamatrix$data$language$ILiteral == null ? (class$com$metamatrix$data$language$ILiteral = TranslatedCommand.class$("com.metamatrix.data.language.ILiteral")) : class$com$metamatrix$data$language$ILiteral), (ILanguageObject)command);
        Iterator i = literals.iterator();
        while (i.hasNext()) {
            ILiteral l = (ILiteral)i.next();
            if (!l.isBindValue() && !TranslatedCommand.isBindEligible(l)) continue;
            return true;
        }
        return false;
    }

    static boolean isBindEligible(ILiteral l) {
        return DataTypeManager.DefaultDataClasses.CLOB.equals(l.getType()) || DataTypeManager.DefaultDataClasses.BLOB.equals(l.getType()) || DataTypeManager.DefaultDataClasses.OBJECT.equals(l.getType());
    }

    public int getExecutionType() {
        return this.executionType;
    }

    public List getPreparedValues() {
        return this.preparedValues;
    }

    public List getPreparedTypes() {
        return this.preparedTypes;
    }

    public String getSql() {
        return this.sql;
    }

    public int getStatementType() {
        return this.statementType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

