/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.internal.process.WorkQueue;
import java.util.LinkedList;
import java.util.List;

public class WorkItemState {
    static final int IDLE = 0;
    static final int WORKING = 1;
    static final int MORE_WORK = 2;
    static final int DONE = 3;
    static final int IDLE_SENDING = 4;
    static final int WORKING_SENDING = 5;
    static final int MORE_WORK_SENDING = 6;
    static final int DONE_SENDING = 7;
    private int state;
    private WorkQueue queue;
    private BoundedStringBuffer history = new BoundedStringBuffer();
    private BoundedStringBuffer eventHistory = new BoundedStringBuffer();

    public WorkItemState(WorkQueue queue, boolean clientExpectsResults) {
        this.queue = queue;
        if (clientExpectsResults) {
            this.gotoState(6);
        } else {
            this.gotoState(2);
        }
    }

    int getState() {
        return this.state;
    }

    public void startProcessing() {
        this.addEvent("Start");
        int newState = this.state;
        switch (this.state) {
            case 2: {
                newState = 1;
                break;
            }
            case 6: {
                newState = 5;
                break;
            }
            case 7: {
                newState = 5;
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable start state.");
            }
        }
        this.gotoState(newState);
    }

    public void endProcessing(WorkItem workItem) throws QueueSuspendedException, MetaMatrixComponentException {
        this.addEvent("End");
        int newState = this.state;
        boolean enqueue = false;
        switch (this.state) {
            case 2: {
                enqueue = true;
                break;
            }
            case 1: {
                newState = 0;
                break;
            }
            case 6: {
                enqueue = true;
                break;
            }
            case 5: {
                newState = 4;
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable end state.");
            }
        }
        this.gotoState(newState);
        if (enqueue) {
            this.queue.add(workItem);
        }
    }

    public void doneProcessing(WorkItem workItem) throws QueueSuspendedException, MetaMatrixComponentException {
        this.addEvent("Done");
        int newState = this.state;
        boolean enqueue = false;
        switch (this.state) {
            case 2: {
                newState = 3;
                break;
            }
            case 1: {
                newState = 3;
                break;
            }
            case 6: {
                newState = 7;
                enqueue = true;
                break;
            }
            case 5: {
                newState = 4;
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable done state.");
            }
        }
        this.gotoState(newState);
        if (enqueue) {
            this.queue.add(workItem);
        }
    }

    public void sentResults() {
        this.addEvent("SentResults");
        int newState = this.state;
        switch (this.state) {
            case 6: {
                newState = 2;
                break;
            }
            case 5: {
                newState = 1;
                break;
            }
            case 4: 
            case 7: {
                this.invalidEvent("Cannot send results without working");
            }
            default: {
                this.invalidEvent("Cannot resend results");
            }
        }
        this.gotoState(newState);
    }

    public void requestResults(WorkItem workItem) throws QueueSuspendedException {
        this.addEvent("RequestResults");
        int newState = this.state;
        boolean enqueue = false;
        switch (this.state) {
            case 1: {
                newState = 6;
                break;
            }
            case 0: {
                newState = 6;
                enqueue = true;
                break;
            }
            case 3: {
                newState = 7;
                enqueue = true;
                break;
            }
            case 2: {
                newState = 6;
                break;
            }
            default: {
                this.invalidEvent("Results not sent");
            }
        }
        this.gotoState(newState);
        if (enqueue) {
            this.queue.add(workItem);
        }
    }

    public void pollResults(WorkItem workItem) throws QueueSuspendedException {
        this.addEvent("PollResults");
        int newState = this.state;
        boolean enqueue = false;
        switch (this.state) {
            case 0: 
            case 4: {
                newState = 6;
                enqueue = true;
                break;
            }
            case 3: 
            case 7: {
                newState = 7;
                enqueue = true;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                newState = 6;
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable poll state.");
            }
        }
        this.gotoState(newState);
        if (enqueue) {
            this.queue.add(workItem);
        }
    }

    public void requestWork(WorkItem workItem) throws QueueSuspendedException {
        this.addEvent("Request");
        int newState = this.state;
        boolean enqueue = false;
        switch (this.state) {
            case 0: {
                newState = 2;
                enqueue = true;
                break;
            }
            case 2: {
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                newState = 2;
                break;
            }
            case 5: {
                newState = 6;
                break;
            }
            case 4: {
                newState = 6;
                enqueue = true;
                break;
            }
            default: {
                this.invalidEvent(this.getStateString() + " is not an allowable request state.");
            }
        }
        this.gotoState(newState);
        if (enqueue) {
            this.queue.add(workItem);
        }
    }

    private void gotoState(int newState) {
        this.state = newState;
        this.history.append(this.getStateString());
    }

    private void addEvent(String event) {
        this.eventHistory.append(event);
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return "IDLE";
            }
            case 2: {
                return "MORE_WORK";
            }
            case 1: {
                return "WORKING";
            }
            case 3: {
                return "DONE";
            }
            case 5: {
                return "WORKING_SENDING";
            }
            case 6: {
                return "MORE_WORK_SENDING";
            }
            case 4: {
                return "IDLE_SENDING";
            }
            case 7: {
                return "DONE_SENDING";
            }
        }
        throw new RuntimeException();
    }

    protected void invalidEvent(String message) {
        throw new MetaMatrixRuntimeException(message + " thread name: " + Thread.currentThread().getName() + " " + this.getHistoryString());
    }

    public List getEventHistory() {
        return this.eventHistory.getEntries();
    }

    public List getStateHistory() {
        return this.history.getEntries();
    }

    public String getHistoryString() {
        List lstEvents = this.getEventHistory();
        List lstStates = this.getStateHistory();
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < lstStates.size(); ++i2) {
            sb.append(lstStates.get(i2)).append("  ");
            if (lstEvents.size() <= i2) continue;
            sb.append(lstEvents.get(i2)).append(" -> ");
        }
        return sb.toString();
    }

    boolean needsResults() {
        return this.state == 5 || this.state == 6 || this.state == 4 || this.state == 7;
    }

    static class BoundedStringBuffer {
        final int SIZE = 10;
        LinkedList stringList = new LinkedList();

        BoundedStringBuffer() {
        }

        public List getEntries() {
            return this.stringList;
        }

        public void append(String str) {
            if (this.stringList.size() < 10) {
                this.stringList.add(str);
            } else {
                this.stringList.removeFirst();
                this.stringList.addLast(str);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < this.stringList.size(); ++i2) {
                sb.append(this.stringList.get(i2)).append(" ");
            }
            return sb.toString();
        }
    }
}

