/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.mapping.ui.part;

import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.ScaledFontManager;
import com.metamatrix.modeler.diagram.ui.connection.NodeConnectionModel;
import com.metamatrix.modeler.diagram.ui.editor.DiagramViewer;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.notation.uml.figure.UmlClassifierFigure;
import com.metamatrix.modeler.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import com.metamatrix.modeler.diagram.ui.part.AbstractDiagramEditPart;
import com.metamatrix.modeler.diagram.ui.part.AbstractFreeEditPart;
import com.metamatrix.modeler.diagram.ui.part.DiagramEditPart;
import com.metamatrix.modeler.diagram.ui.part.ExpandableDiagram;
import com.metamatrix.modeler.diagram.ui.util.DiagramXYLayoutEditPolicy;
import com.metamatrix.modeler.diagram.ui.util.LassoDragTracker;
import com.metamatrix.modeler.mapping.ui.UiConstants;
import com.metamatrix.modeler.mapping.ui.editor.MappingDiagramController;
import com.metamatrix.modeler.mapping.ui.model.MappingDiagramNode;
import com.metamatrix.modeler.mapping.ui.model.MappingExtentNode;
import com.metamatrix.modeler.mapping.ui.part.MappingDiagramLayout;
import com.metamatrix.modeler.mapping.ui.part.MappingExtentEditPart;
import com.metamatrix.modeler.mapping.ui.util.MappingUiUtil;
import com.metamatrix.modeler.ui.IDiagramTypeEditPart;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class MappingDiagramEditPart
extends AbstractDiagramEditPart
implements ExpandableDiagram,
IDiagramTypeEditPart {
    private static DragTracker m_dragTracker = null;
    private String sCurrentRouterStyle = "DiagramRouterStyles.fan.textid";
    private boolean bLayoutInProgress = false;

    protected void addChildVisual(EditPart childEditPart, int index) {
        DiagramModelNode model;
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        Object obj = childEditPart.getModel();
        if (obj instanceof DiagramModelNode && (obj = (model = (DiagramModelNode)obj).getModelObject()) instanceof MappingClass && ((MappingClass)obj).isRecursive() && child instanceof UmlClassifierFigure && (obj = MappingUiUtil.getCurrentTreeMappingAdapter().getLocation((MappingClass)obj)) instanceof XmlDocumentNode && ((XmlDocumentNode)obj).isExcludeFromDocument()) {
            ((UmlClassifierFigure)child).getEditButton().setEnabled(false);
        }
        this.getContentPane().add(child, index);
    }

    protected IFigure createFigure() {
        Figure newFigure = this.getFigureFactory().createFigure(this.getModel());
        this.setCurrentDiagramFont(ScaledFontManager.getFont());
        return newFigure;
    }

    protected void createEditPolicies() {
        this.setSelectablePart(false);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramXYLayoutEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        if (m_dragTracker == null) {
            m_dragTracker = new LassoDragTracker();
        }
        return m_dragTracker;
    }

    public void layout(boolean layoutChildren) {
        String message;
        if (layoutChildren) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(layoutChildren);
            }
        }
        if (!((DiagramModelNode)this.getModel()).wasLayedOut()) {
            if (UiConstants.Util.isDebugEnabled("mappingDiagramEditParts")) {
                message = "calling layout()";
                UiConstants.Util.print("mappingDiagramEditParts", message);
            }
            this.layout();
        } else {
            if (UiConstants.Util.isDebugEnabled("mappingDiagramEditParts")) {
                message = "calling recoverObjectProperties()";
                UiConstants.Util.print("mappingDiagramEditParts", message);
            }
            ((DiagramModelNode)this.getModel()).recoverObjectProperties();
        }
        ArrayList arylSourceConnections = new ArrayList();
        if (!arylSourceConnections.isEmpty()) {
            Iterator itSourceConns = arylSourceConnections.iterator();
            while (itSourceConns.hasNext()) {
                NodeConnectionModel ncmSourceConn = (NodeConnectionModel)itSourceConns.next();
                ncmSourceConn.setRouterStyle(this.sCurrentRouterStyle);
                ncmSourceConn.layout();
            }
        }
    }

    private boolean hasChildren() {
        return this.getViewer().getContents().getChildren().size() > 0;
    }

    public void layout() {
        MappingDiagramController controller;
        if (this.bLayoutInProgress) {
            return;
        }
        this.bLayoutInProgress = true;
        MappingDiagramLayout diagramLayout = new MappingDiagramLayout((DiagramModelNode)this.getModel(), this.isCoarseMapping());
        int yValue = this.getLowestYExtentValue();
        if (!this.isCoarseMapping() && (controller = (MappingDiagramController)((DiagramViewer)this.getViewer()).getEditor().getDiagramController()) != null) {
            yValue += controller.getScrollOffset();
        }
        diagramLayout.run(120, yValue);
        this.updateAnchorsAndLinks();
        this.bLayoutInProgress = false;
        this.getFigure().repaint();
    }

    private void updateAnchorsAndLinks() {
        EditPart canvasEditPart = this.getViewer().getContents();
        List canvasChildren = canvasEditPart.getChildren();
        Iterator iter = canvasChildren.iterator();
        EditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (EditPart)iter.next();
            if (!(nextEditPart instanceof DiagramEditPart) || nextEditPart instanceof AbstractFreeEditPart) continue;
            ((DiagramEditPart)nextEditPart).createOrUpdateAnchorsLocations(false);
        }
    }

    private int getLowestYExtentValue() {
        int minYValue = 20;
        int yValue = -99;
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        int partY = 0;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (!(nextEditPart instanceof MappingExtentEditPart)) continue;
            partY = ((DiagramModelNode)nextEditPart.getModel()).getY();
            if (yValue < 0) {
                yValue = partY;
                continue;
            }
            yValue = Math.min(partY, yValue);
        }
        if (yValue < minYValue) {
            yValue = minYValue;
        }
        return yValue;
    }

    private boolean isClassifer(DiagramEditPart editPart) {
        return editPart instanceof UmlClassifierEditPart;
    }

    public TopAndBottomClassifierInfo getTopAndBottomClassifierInfo() {
        TopAndBottomClassifierInfo tab = new TopAndBottomClassifierInfo();
        boolean firstRun = true;
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (!this.isClassifer(nextEditPart)) continue;
            DiagramModelNode diagramModelNode = (DiagramModelNode)nextEditPart.getModel();
            int topY = diagramModelNode.getY();
            int bottomY = topY + diagramModelNode.getHeight();
            if (firstRun) {
                firstRun = false;
                tab.bottomPart = nextEditPart;
                tab.topPart = nextEditPart;
                tab.bottomY = bottomY;
                tab.topY = topY;
                continue;
            }
            if (bottomY > tab.bottomY) {
                tab.bottomY = bottomY;
                tab.bottomPart = nextEditPart;
            }
            if (topY >= tab.topY) continue;
            tab.topY = topY;
            tab.topPart = nextEditPart;
        }
        return tab;
    }

    public int getLowestYValue() {
        int yValue = 0;
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        int partY = 0;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (nextEditPart.getModel() == null || !(nextEditPart.getModel() instanceof DiagramModelNode)) continue;
            partY = ((DiagramModelNode)nextEditPart.getModel()).getY();
            yValue = Math.min(partY, yValue);
        }
        return yValue;
    }

    public int getHighestYValue() {
        int yValue = -99;
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        int partY = 0;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (nextEditPart.getModel() == null || !(nextEditPart.getModel() instanceof DiagramModelNode)) continue;
            partY = ((DiagramModelNode)nextEditPart.getModel()).getY() + ((DiagramModelNode)nextEditPart.getModel()).getHeight();
            yValue = Math.max(partY, yValue);
        }
        return yValue;
    }

    public boolean hasConnections() {
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (nextEditPart.getSourceConnections().isEmpty() && nextEditPart.getTargetConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void refreshFont(boolean refreshChildren) {
        super.refreshFont(refreshChildren);
        if (this.hasChildren()) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(true);
            }
        }
    }

    protected void refreshVisuals() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (this.sCurrentRouterStyle.equals("DiagramRouterStyles.fan.textid")) {
            cLayer.setConnectionRouter((ConnectionRouter)new FanRouter());
        }
    }

    public boolean isCoarseMapping() {
        return ((MappingDiagramNode)this.getModel()).isCoarse();
    }

    public boolean isPrimary(DiagramEditPart editPart) {
        boolean primary = false;
        EObject diagramTarget = ((Diagram)this.getModelObject()).getTarget();
        if (editPart.getModelObject() != null && editPart.getModelObject().equals(diagramTarget)) {
            primary = true;
        }
        return primary;
    }

    public void updateForPreferences() {
        RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.mapping.backgroundcolor");
        this.getFigure().setBackgroundColor(new Color(null, currentBkgdColor));
        this.refreshFont(true);
        this.layout(false);
    }

    public void handleZoomChanged() {
        DiagramEditPart canvasEditPart = (DiagramEditPart)this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        MappingDiagramNode mdn = (MappingDiagramNode)canvasEditPart.getModel();
        int currentYOrigin = mdn.getCurrentYOrigin();
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (!(nextEditPart instanceof MappingExtentEditPart)) continue;
            MappingExtentNode men = (MappingExtentNode)nextEditPart.getModel();
            men.updateModelForExtent();
            men.setExtentPosition(currentYOrigin);
        }
    }

    public boolean canExpand() {
        return this.isCoarseMapping();
    }

    public void collapseAll() {
    }

    public void collapse(Object child) {
    }

    public void expandAll() {
    }

    public void expand(Object child) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        super.propertyChange(evt);
        if (prop.equals("collapse") || prop.equals("expand")) {
            this.layout();
        }
    }

    public void setUnderConstruction(boolean theUnderConstruction) {
        List contents = this.getChildren();
        Iterator iter = contents.iterator();
        Object nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof DiagramEditPart)) continue;
            ((DiagramEditPart)nextObj).setUnderConstruction(theUnderConstruction);
        }
        super.setUnderConstruction(theUnderConstruction);
    }

    public static class TopAndBottomClassifierInfo {
        public int topY;
        public int bottomY;
        public DiagramEditPart topPart;
        public DiagramEditPart bottomPart;
    }
}

