#!/bin/bash
#By PPC, anti-apxos, for use with antiX Linux- GPL license - Please keep this attribution.
#Depends: jmtpfs,yad

TEXTDOMAINDIR=/usr/share/locale
TEXTDOMAIN=android-device-usb-connect

#Commandline options
[[ "$@" =~ "help" ]] && echo "Usage: mini_android_mounter.sh [options]
  
  Available options:
    --help           Show this usage information and exit
    --quiet          Suppress information dialogs and only show errors
    --root           Skip user mount attempt and go directly to mounting as root (gksu)
" && exit 0
[[ "$@" =~ "quiet" ]] && quiet=1
[[ "$@" =~ "root" ]] && root=1

#Third file descriptor is needed to capture stderr while still displaying stdout
exec 3>&1

#Main variables, used in the yad GUI's:
yad_window_icon="phone"
yad_image="/usr/share/icons/papirus-antix/48x48/devices/smartphone.png"
yad_title=$"Android Device USB Connect"
dir="$HOME/android-device"

#(Most) (localizable) Text strings used in the script:
exit_button=$"EXIT"
retry_button=$"Retry"
ok_button=$"OK"
try_as_root_button=$"Try as ROOT"
big_not_detected_warning=$"No (MTP enabled) Android device found!"
big_grant_permitission_warning=$"Unable to mount device!"
detailed_grant_permitission_text=$"On the android device, check if you have to select 'MTP...' or 'File transfer...' option \n or 'Allowed' file access.\n After you do so, click the Retry button on this window."
when_all_hope_is_lost_text=$"If that fails: unplug the device, grant the permission, replug it and re-run this program."
connect_the_damn_cable_stupid=$"Connect a single device to this computer, using its USB cable..."
grant_permitission_reminder=$"Please check that you have ALLOWED access to your files on your android device in order to proceed."
try_as_root_question=$"There was a device permission error.\n \n Try to mount again as root?"

###MAIN SCRIPT###
mkdir -p "$dir"
echo Mount point for the android device will be "$dir"

android_mointer()
{
  if [ "$(mount | grep "jmtpfs on "$dir"")" ]; then
#If there's already a jmtpfs mount, offer to unmount it
  echo $"An android device seems to be mounted"
  [ $quiet ] || yad --on-top --fixed --window-icon=$yad_window_icon --image=$yad_image --title "$yad_title" --center --text=$"An android device seems to be mounted.\n \nChoose 'Unmount' to unplug it safely OR \nChoose 'Access device' to view the device's contents again.   " --width=450 --button=$"Access device":1 --button=$"Unmount":2
  foo=$?
  [ $foo -eq 1 ] && echo $"User has chosen to access the android device" && desktop-defaults-run -fm "$dir" && exit 0
  [ $quiet ] || [ $foo -eq 2 ] && echo $"User has chosen to unmount the android device"
#Check if user owns the mountpoint and unmount with or without gksu
  if [ -O "$dir" ]; then
    fusermount -u "$dir" && rmdir "$dir"
  else
    gksu --description "$yad_title (umount)" -- sh -c "umount "$dir" && rmdir "$dir""
  fi
#### NEW confirmation dialog, that warns if it's safe to unplug the device
  if [ "$(mount | grep "jmtpfs on "$dir"")" ]; then
    echo $"Android device WAS NOT umounted for some reason, do not unplug!"
    yad --on-top --fixed --window-icon=$yad_window_icon --image=$yad_image --title "$yad_title" --center --text=$"Android device WAS NOT umounted for some reason; do not unplug!" --width=450 --button="$ok_button" && exit
  else
    echo $"Android device is umounted; it is safe to unplug!"
    [ $quiet ] || yad --fixed --window-icon=$yad_window_icon --image=$yad_image --title "$yad_title" --center --text=$"Android device is umounted; it is safe to unplug!" --width=450 --button="$ok_button" && exit
  fi
else
#If no existing mount, attempt a new mount using jmtpfs and store the output for error-checking
  [ $root ] || mount_check=$(jmtpfs -o auto_unmount "$dir" 2>&1 1>&3)
  echo $mount_check

#Check for jmtpfs mount errors and prompt user if needed
  #CASE 1: Device permissions won't allow mounting. Offer to try again with gksu.
  if [ $root ] || [[ "$mount_check" =~ "Permission denied" ]]; then
    [ $root ] || yad --on-top --center --title="$yad_title" --window-icon=$yad_window_icon --image=$yad_image --text=" $try_as_root_question" --width=450 --button="$exit_button":1 --button="$try_as_root_button":2
    foo=$?
    [ $foo -eq 1 ] && echo User has chosen to Exit && exit 1
    [ $root ] || [ $foo -eq 2 ] && echo User chosen to try mount as ROOT
    gksu --description "$yad_title (jmtpfs)" -- jmtpfs -o auto_unmount,allow_other "$dir"
  #Case 2: No MTP devices found. Warn user and allow a second try.
  elif [[ "$mount_check" =~ "No mtp devices found" ]]; then
    yad --on-top --fixed --window-icon=$yad_window_icon --image=$yad_image --title "$yad_title" --center  --borders=10 --text=$"<b><big>$big_not_detected_warning</big></b>\n \n $connect_the_damn_cable_stupid \n \n $detailed_grant_permitission_text   \n" --width=450 --button="$exit_button":1 --button="$retry_button":2
    foo=$?
    [ $foo -eq 1 ] && echo User has chosen to Exit && exit 1
    [ $foo -eq 2 ] && echo User has chosen to Retry && android_mointer
    echo Trying jmtpfs mount again...
    #fusermount -u $dir #Mounting failed, so there's no need to unmount
    jmtpfs -o auto_unmount "$dir"
  #Case 3: User has to “allow” access. Wait for the user and try again.
  elif [[ "$mount_check" =~ "bad mount point" ]]; then
    yad --on-top --center --title="$yad_title" --window-icon=$yad_window_icon --image=$yad_image --text="$grant_permitission_reminder" --width=450 --button="$ok_button"
    echo Trying jmtpfs mount again...
    #fusermount -u $dir #Mounting failed, so there's no need to unmount
    jmtpfs -o auto_unmount "$dir"
  #Case 4: Mount location is empty. Warn user and unmount. (Does this really happen? Does jmtpfs give an error message?) 
  elif [ "$(ls -A "$dir" | wc -l)" -eq 0 ]; then
    echo Directory "$dir" is empty after mount. This means an error happened. Please try to reconnect the phone to the computer and run this program again.
    fusermount -u "$dir" && rmdir "$dir"
  fi

# Final check for successful mount. Either open file manager or display a failure dialog.
  if [ "$(mount | grep "jmtpfs on "$dir"")" ]; then
    desktop-defaults-run -fm "$dir"
  else
    echo Android device connection has failed
    yad  --on-top --fixed --window-icon=$yad_window_icon --image=$yad_image --title "$yad_title" --center  --borders=10 --text=$"<b><big> $big_grant_permitission_warning</big></b>\n \n $detailed_grant_permitission_text\n \n $when_all_hope_is_lost_text \n " --width=450 --button="$exit_button":1 --button="$retry_button":2
     foo=$?
    [ $foo -eq 1 ] && echo User has chosen to Exit && exit 1
    [ $foo -eq 2 ] && echo User has chosen to Retry && bash "$0"
    
    
  fi
fi

} # end main function

#Run main funciton, then exit:
android_mointer
exit
