# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

ECM_HANDBOOK="optional"
ECM_TEST="forceoptional"
KFMIN=6.19.0
QTMIN=6.10.1
inherit ecm gear.kde.org xdg

DESCRIPTION="Language learning application that helps improving pronunciation skills"
HOMEPAGE="https://apps.kde.org/artikulate/"

LICENSE="GPL-2" # TODO: CHECK
SLOT="0"
KEYWORDS="amd64 arm64 ~riscv ~x86"
IUSE=""

DEPEND="
	dev-libs/libxml2:=
	>=dev-qt/qtbase-${QTMIN}:6[gui,sql,xml]
	>=dev-qt/qtdeclarative-${QTMIN}:6
	>=dev-qt/qtmultimedia-${QTMIN}:6[qml]
	>=kde-frameworks/karchive-${KFMIN}:6
	>=kde-frameworks/kconfig-${KFMIN}:6
	>=kde-frameworks/kconfigwidgets-${KFMIN}:6
	>=kde-frameworks/kcoreaddons-${KFMIN}:6
	>=kde-frameworks/kcrash-${KFMIN}:6
	>=kde-frameworks/ki18n-${KFMIN}:6
	>=kde-frameworks/kirigami-${KFMIN}:6
	>=kde-frameworks/kitemmodels-${KFMIN}:6
	>=kde-frameworks/knewstuff-${KFMIN}:6
	>=kde-frameworks/kwidgetsaddons-${KFMIN}:6
"
RDEPEND="${DEPEND}
	dev-libs/kirigami-addons:6
"

src_configure() {
	local mycmakeargs=(
		-DBUILD_autotests=$(usex test)
	)
	ecm_src_configure
}
