# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.0.0.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit ghc-package haskell-cabal

DESCRIPTION="Run external processes, with strong typing of streams"
HOMEPAGE="https://github.com/fpco/typed-process"

LICENSE="MIT"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"

PATCHES=(
	"${FILESDIR}/${PN}-0.2.10.1-smp-flag.patch"
)

RDEPEND="
	>=dev-haskell/async-2.0:=[profile?]
	dev-haskell/stm:=[profile?]
	dev-haskell/unliftio-core:=[profile?]
	>=dev-lang/ghc-8.6.3:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.4.0.1
	test? ( dev-haskell/base64-bytestring
		dev-haskell/hspec
		dev-haskell/temporary )
"

src_configure() {
	if ghc-supports-smp; then
		local smp_flag=smp
	else
		local smp_flag=-smp
	fi

	haskell-cabal_src_configure \
		--flag="${smp_flag}"
}
