/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public abstract class Instruction
extends Expression
implements SourceLocator,
TailCallReturner {
    public int getImplementationMethod() {
        return 4;
    }

    public int getInstructionNameCode() {
        return -1;
    }

    public String getInstructionName() {
        return this.getClass().getName();
    }

    public String getExpressionName() {
        int code = this.getInstructionNameCode();
        if (code < 0) {
            return this.getClass().getName();
        }
        if (code < 1024) {
            return StandardNames.getDisplayName(code);
        }
        return this.getInstructionName();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }

    public abstract TailCall processLeavingTail(XPathContext var1) throws XPathException;

    public void process(XPathContext context) throws XPathException {
        try {
            for (TailCall tc = this.processLeavingTail(context); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    protected static XPathException dynamicError(SourceLocator loc, XPathException error, XPathContext context) {
        if (error instanceof TerminationException) {
            return error;
        }
        error.maybeSetLocation(loc);
        error.maybeSetContext(context);
        return error;
    }

    public static ParameterSet assembleParams(XPathContext context, WithParam[] actualParams) throws XPathException {
        if (actualParams == null || actualParams.length == 0) {
            return null;
        }
        ParameterSet params = new ParameterSet(actualParams.length);
        for (int i = 0; i < actualParams.length; ++i) {
            params.put(actualParams[i].getParameterId(), actualParams[i].getSelectValue(context), actualParams[i].isTypeChecked());
        }
        return params;
    }

    public static ParameterSet assembleTunnelParams(XPathContext context, WithParam[] actualParams) throws XPathException {
        ParameterSet existingParams = context.getTunnelParameters();
        if (existingParams == null) {
            return Instruction.assembleParams(context, actualParams);
        }
        ParameterSet newParams = new ParameterSet(existingParams, actualParams == null ? 0 : actualParams.length);
        if (actualParams == null || actualParams.length == 0) {
            return newParams;
        }
        for (int i = 0; i < actualParams.length; ++i) {
            newParams.put(actualParams[i].getParameterId(), actualParams[i].getSelectValue(context), false);
        }
        return newParams;
    }

    public abstract Expression simplify(ExpressionVisitor var1) throws XPathException;

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.createsNewNodes()) {
            return p;
        }
        return p | 0x400000;
    }

    public boolean createsNewNodes() {
        return false;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
    }

    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.promoteInst(offer);
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((m & 2) != 0) {
            return this.iterate(context).next();
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        Item result = seq.getFirstItem();
        seq.reset();
        return result;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(item);
        }
        if ((m & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        return this.getIteratorFromProcessMethod(context);
    }

    protected final SequenceIterator getIteratorFromProcessMethod(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(20);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        return seq.iterate();
    }

    public final CharSequence evaluateAsString(XPathContext context) throws XPathException {
        Item item = this.evaluateItem(context);
        if (item == null) {
            return "";
        }
        return item.getStringValue();
    }

    public int getConstructType() {
        return this.getInstructionNameCode();
    }

    public boolean isXSLT() {
        return this.getHostLanguage() == 50;
    }
}

