/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.query;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class QueryAutoStopWordAnalyzer
extends Analyzer {
    Analyzer delegate;
    HashMap<String, HashSet<String>> stopWordsPerField = new HashMap();
    public static final float defaultMaxDocFreqPercent = 0.4f;
    private final Version matchVersion;

    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate) {
        this.delegate = delegate;
        this.setOverridesTokenStreamMethod(QueryAutoStopWordAnalyzer.class);
        this.matchVersion = matchVersion;
    }

    public int addStopWords(IndexReader reader) throws IOException {
        return this.addStopWords(reader, 0.4f);
    }

    public int addStopWords(IndexReader reader, int maxDocFreq) throws IOException {
        int numStopWords = 0;
        Collection fieldNames = reader.getFieldNames(IndexReader.FieldOption.INDEXED);
        for (String fieldName : fieldNames) {
            numStopWords += this.addStopWords(reader, fieldName, maxDocFreq);
        }
        return numStopWords;
    }

    public int addStopWords(IndexReader reader, float maxPercentDocs) throws IOException {
        int numStopWords = 0;
        Collection fieldNames = reader.getFieldNames(IndexReader.FieldOption.INDEXED);
        for (String fieldName : fieldNames) {
            numStopWords += this.addStopWords(reader, fieldName, maxPercentDocs);
        }
        return numStopWords;
    }

    public int addStopWords(IndexReader reader, String fieldName, float maxPercentDocs) throws IOException {
        return this.addStopWords(reader, fieldName, (int)((float)reader.numDocs() * maxPercentDocs));
    }

    public int addStopWords(IndexReader reader, String fieldName, int maxDocFreq) throws IOException {
        HashSet<String> stopWords = new HashSet<String>();
        String internedFieldName = StringHelper.intern((String)fieldName);
        TermEnum te = reader.terms(new Term(fieldName));
        Term term = te.term();
        while (term != null && term.field() == internedFieldName) {
            if (te.docFreq() > maxDocFreq) {
                stopWords.add(term.text());
            }
            if (!te.next()) break;
            term = te.term();
        }
        this.stopWordsPerField.put(fieldName, stopWords);
        Map streamMap = (Map)this.getPreviousTokenStream();
        if (streamMap != null) {
            streamMap.remove(fieldName);
        }
        return stopWords.size();
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result;
        try {
            result = this.delegate.reusableTokenStream(fieldName, reader);
        }
        catch (IOException e) {
            result = this.delegate.tokenStream(fieldName, reader);
        }
        HashSet<String> stopWords = this.stopWordsPerField.get(fieldName);
        if (stopWords != null) {
            result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), result, stopWords);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams;
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        HashMap<String, SavedStreams> streamMap = (HashMap<String, SavedStreams>)this.getPreviousTokenStream();
        if (streamMap == null) {
            streamMap = new HashMap<String, SavedStreams>();
            this.setPreviousTokenStream(streamMap);
        }
        if ((streams = (SavedStreams)streamMap.get(fieldName)) == null) {
            streams = new SavedStreams();
            streamMap.put(fieldName, streams);
            streams.wrapped = this.delegate.reusableTokenStream(fieldName, reader);
            HashSet<String> stopWords = this.stopWordsPerField.get(fieldName);
            streams.withStopFilter = stopWords != null ? new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.wrapped, stopWords) : streams.wrapped;
        } else {
            TokenStream result = this.delegate.reusableTokenStream(fieldName, reader);
            if (result == streams.wrapped) {
                streams.withStopFilter.reset();
            } else {
                streams.wrapped = result;
                HashSet<String> stopWords = this.stopWordsPerField.get(fieldName);
                streams.withStopFilter = stopWords != null ? new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.wrapped, stopWords) : streams.wrapped;
            }
        }
        return streams.withStopFilter;
    }

    public String[] getStopWords(String fieldName) {
        HashSet<String> stopWords = this.stopWordsPerField.get(fieldName);
        String[] result = stopWords != null ? stopWords.toArray(new String[stopWords.size()]) : new String[]{};
        return result;
    }

    public Term[] getStopWords() {
        ArrayList<Term> allStopWords = new ArrayList<Term>();
        for (String fieldName : this.stopWordsPerField.keySet()) {
            HashSet<String> stopWords = this.stopWordsPerField.get(fieldName);
            for (String text : stopWords) {
                allStopWords.add(new Term(fieldName, text));
            }
        }
        return allStopWords.toArray(new Term[allStopWords.size()]);
    }

    private class SavedStreams {
        TokenStream wrapped;
        TokenStream withStopFilter;

        private SavedStreams() {
        }
    }
}

