/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        UntypedAtomicValue v = new UntypedAtomicValue(this.value);
        v.noSurrogates = this.noSurrogates;
        v.doubleValue = this.doubleValue;
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, ConversionRules rules) {
        int req = requiredType.getFingerprint();
        if (req == 513) {
            if (this.value.length() == 0) {
                return StringValue.EMPTY_STRING;
            }
            return new StringValue(this.value);
        }
        if (req == 631) {
            return this;
        }
        if (req == 517 || req == 635) {
            try {
                return this.toDouble(rules);
            }
            catch (ValidationException e) {
                return new ValidationFailure(e);
            }
        }
        return super.convertPrimitive(requiredType, validate, rules);
    }

    private AtomicValue toDouble(ConversionRules rules) throws ValidationException {
        if (this.doubleValue == null) {
            try {
                double d = rules.getStringToDoubleConverter().stringToNumber(this.value);
                this.doubleValue = new DoubleValue(d);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Cannot convert string " + Err.wrap(this.value) + " to a double");
            }
        }
        return this.doubleValue;
    }

    public int compareTo(AtomicValue other, StringCollator collator, XPathContext context) {
        if (other instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = (DoubleValue)this.convertPrimitive(BuiltInAtomicType.DOUBLE, true, context.getConfiguration().getConversionRules()).asAtomic();
                }
                catch (XPathException err) {
                    throw new ClassCastException("Cannot convert untyped value \"" + this.getStringValueCS() + "\" to a double");
                }
            }
            return this.doubleValue.compareTo(other);
        }
        if (other instanceof StringValue) {
            if (collator instanceof CodepointCollator) {
                return ((CodepointCollator)collator).compareCS(this.getStringValueCS(), other.getStringValueCS());
            }
            return collator.compareStrings(this.getStringValue(), other.getStringValue());
        }
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        ConversionResult result = this.convert((AtomicType)other.getItemType(th), true, config.getConversionRules());
        if (result instanceof ValidationFailure) {
            throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + other.getItemType(th));
        }
        return ((Comparable)((Object)((AtomicValue)result))).compareTo(other);
    }
}

