/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class Concat
extends Function {
    public String getName() {
        return "concat";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(2, Integer.MAX_VALUE);
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            this.argument[n2] = this.argument[n2].simplify();
            if (!(this.argument[n2] instanceof Value)) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            return this.evaluate(null);
        }
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        int n = this.getNumberOfArguments();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.argument[n2].evaluateAsString(context));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    public int getDependencies() {
        int n = this.getNumberOfArguments();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 |= this.argument[n3].getDependencies();
            ++n3;
        }
        return n2;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Concat concat = new Concat();
        int n2 = this.getNumberOfArguments();
        int n3 = 0;
        while (n3 < n2) {
            concat.addArgument(this.argument[n3].reduce(n, context));
            ++n3;
        }
        concat.setStaticContext(this.getStaticContext());
        return concat.simplify();
    }
}

