/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Controller;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;

public class DifferenceEnumeration
implements NodeEnumeration {
    private NodeEnumeration p1;
    private NodeEnumeration p2;
    private NodeEnumeration e1;
    private NodeEnumeration e2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private Controller controller;
    NodeInfo nextNode = null;

    public DifferenceEnumeration(NodeEnumeration nodeEnumeration, NodeEnumeration nodeEnumeration2, Controller controller) throws XPathException {
        this.p1 = nodeEnumeration;
        this.p2 = nodeEnumeration2;
        this.controller = controller;
        this.e1 = nodeEnumeration;
        this.e2 = nodeEnumeration2;
        if (!this.e1.isSorted()) {
            this.e1 = new NodeSetExtent(this.e1, (NodeOrderComparer)controller).sort().enumerate();
        }
        if (!this.e2.isSorted()) {
            this.e2 = new NodeSetExtent(this.e2, (NodeOrderComparer)controller).sort().enumerate();
        }
        if (this.e1.hasMoreElements()) {
            this.nextNode1 = this.e1.nextElement();
        }
        if (this.e2.hasMoreElements()) {
            this.nextNode2 = this.e2.nextElement();
        }
        this.advance();
    }

    public boolean hasMoreElements() {
        return this.nextNode != null;
    }

    public NodeInfo nextElement() throws XPathException {
        NodeInfo nodeInfo = this.nextNode;
        this.advance();
        return nodeInfo;
    }

    private void advance() throws XPathException {
        while (this.nextNode1 != null && this.nextNode2 != null) {
            NodeInfo nodeInfo;
            int n = this.controller.compare(this.nextNode1, this.nextNode2);
            if (n < 0) {
                nodeInfo = this.nextNode1;
                if (this.e1.hasMoreElements()) {
                    this.nextNode1 = this.e1.nextElement();
                } else {
                    this.nextNode1 = null;
                    this.nextNode = null;
                }
                this.nextNode = nodeInfo;
                return;
            }
            if (n > 0) {
                nodeInfo = this.nextNode2;
                if (this.e2.hasMoreElements()) {
                    this.nextNode2 = this.e2.nextElement();
                    continue;
                }
                this.nextNode2 = null;
                this.nextNode = null;
                continue;
            }
            nodeInfo = this.nextNode2;
            this.nextNode2 = this.e2.hasMoreElements() ? this.e2.nextElement() : null;
            this.nextNode1 = this.e1.hasMoreElements() ? this.e1.nextElement() : null;
        }
        if (this.nextNode1 != null) {
            this.nextNode = this.nextNode1;
            this.nextNode1 = this.e1.hasMoreElements() ? this.e1.nextElement() : null;
            return;
        }
        this.nextNode = null;
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return false;
    }
}

