/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;

final class SiblingEnumeration
implements AxisEnumeration {
    TinyDocumentImpl document;
    int nextNodeNr;
    NodeTest test;
    TinyNodeImpl startNode;
    TinyNodeImpl parentNode;
    boolean getChildren;
    int last = -1;

    protected SiblingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.getChildren = bl;
        if (bl) {
            this.parentNode = tinyNodeImpl;
            this.nextNodeNr = tinyNodeImpl.nodeNr + 1;
        } else {
            this.parentNode = (TinyNodeImpl)tinyNodeImpl.getParent();
            this.nextNodeNr = tinyDocumentImpl.next[tinyNodeImpl.nodeNr];
        }
        if (this.nextNodeNr >= 0 && !nodeTest.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr])) {
            this.advance();
        }
    }

    public boolean hasMoreElements() {
        return this.nextNodeNr >= 0;
    }

    public NodeInfo nextElement() {
        TinyNodeImpl tinyNodeImpl = this.document.getNode(this.nextNodeNr);
        tinyNodeImpl.setParentNode(this.parentNode);
        this.advance();
        return tinyNodeImpl;
    }

    private void advance() {
        do {
            this.nextNodeNr = this.document.next[this.nextNodeNr];
        } while (this.nextNodeNr >= 0 && !this.test.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr]));
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return true;
    }

    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        SiblingEnumeration siblingEnumeration = new SiblingEnumeration(this.document, this.startNode, this.test, this.getChildren);
        this.last = 0;
        while (siblingEnumeration.hasMoreElements()) {
            siblingEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

