/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Move
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _target = new QName("target");
    private static final int bufsize = 8192;
    private WritablePipe result = null;

    public Move(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue runtimeValue = this.getOption(_href);
        URI uRI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        if (!"file".equals(uRI.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the delete step.");
        }
        File file = new File(uRI.getPath());
        if (!file.exists()) {
            throw new XProcException(this.step.getNode(), "Cannot move: file does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new XProcException(this.step.getNode(), "Cannot move: file is a directory: " + file.getAbsolutePath());
        }
        runtimeValue = this.getOption(_target);
        uRI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        if (!"file".equals(uRI.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the copy step.");
        }
        File file2 = new File(uRI.getPath());
        if (file2.isDirectory() && (file2 = new File(file2, file.getName())).isDirectory()) {
            throw new XProcException(this.step.getNode(), "Cannot move: target is a directory: " + file2.getAbsolutePath());
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        treeWriter.addText(file2.toURI().toASCIIString());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[8192];
            int n = fileInputStream.read(byArray, 0, 8192);
            while (n >= 0) {
                fileOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray, 0, 8192);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        if (!file.delete()) {
            throw new XProcException(this.step.getNode(), "Move failed: could not delete file: " + file.getAbsolutePath());
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

