/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexInput
implements Cloneable,
Closeable {
    private byte[] bytes;
    private char[] chars;
    private boolean preUTF8Strings;

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.readBytes(b, offset, len);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public void setModifiedUTF8StringsMode() {
        this.preUTF8Strings = true;
    }

    public String readString() throws IOException {
        if (this.preUTF8Strings) {
            return this.readModifiedUTF8String();
        }
        int length = this.readVInt();
        if (this.bytes == null || length > this.bytes.length) {
            this.bytes = new byte[(int)((double)length * 1.25)];
        }
        this.readBytes(this.bytes, 0, length);
        return new String(this.bytes, 0, length, "UTF-8");
    }

    private String readModifiedUTF8String() throws IOException {
        int length = this.readVInt();
        if (this.chars == null || length > this.chars.length) {
            this.chars = new char[length];
        }
        this.readChars(this.chars, 0, length);
        return new String(this.chars, 0, length);
    }

    public void readChars(char[] buffer, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            byte b = this.readByte();
            buffer[i] = (b & 0x80) == 0 ? (char)(b & 0x7F) : ((b & 0xE0) != 224 ? (char)((b & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((b & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
        }
    }

    public void skipChars(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            byte b = this.readByte();
            if ((b & 0x80) == 0) continue;
            if ((b & 0xE0) != 224) {
                this.readByte();
                continue;
            }
            this.readByte();
            this.readByte();
        }
    }

    @Override
    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    public abstract long length();

    public Object clone() {
        IndexInput clone = null;
        try {
            clone = (IndexInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.bytes = null;
        clone.chars = null;
        return clone;
    }

    public Map<String, String> readStringStringMap() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = this.readInt();
        for (int i = 0; i < count; ++i) {
            String key = this.readString();
            String val = this.readString();
            map.put(key, val);
        }
        return map;
    }
}

