/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.perf;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntPerformanceListener
implements BuildListener {
    private HashMap targetStats = new HashMap();
    private HashMap taskStats = new HashMap();
    private StopWatch master = null;
    private long start_time = 0L;

    public void buildStarted(BuildEvent be) {
        this.master = new StopWatch();
        this.start_time = this.master.start();
    }

    public void buildFinished(BuildEvent be) {
        String f;
        String target_name;
        StopWatch key;
        long stop_time = this.master.stop();
        TreeMap sortedTargets = new TreeMap(new StopWatchComparator());
        Iterator it = this.targetStats.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            Object value = this.targetStats.get(key2);
            sortedTargets.put(value, key2);
        }
        TreeMap sortedTasks = new TreeMap(new StopWatchComparator());
        it = this.taskStats.keySet().iterator();
        while (it.hasNext()) {
            Object key3 = it.next();
            Object value = this.taskStats.get(key3);
            sortedTasks.put(value, key3);
        }
        StringBuffer msg = new StringBuffer();
        String lSep = System.getProperty("line.separator");
        msg.append(lSep).append("Statistics:").append(lSep);
        msg.append("-------------- Target Results ---------------------").append(lSep);
        it = sortedTargets.keySet().iterator();
        while (it.hasNext()) {
            key = (StopWatch)it.next();
            StringBuffer sb = new StringBuffer();
            Target target = (Target)sortedTargets.get(key);
            if (target != null) {
                Project p = target.getProject();
                if (p != null && p.getName() != null) {
                    sb.append(p.getName()).append(".");
                }
                String total = this.format(key.total());
                target_name = target.getName();
                if (target_name == null || target_name.length() == 0) {
                    target_name = "<implicit>";
                }
                sb.append(target_name).append(": ").append(total);
            }
            msg.append(sb.toString()).append(lSep);
        }
        msg.append(lSep);
        msg.append("-------------- Task Results -----------------------").append(lSep);
        it = sortedTasks.keySet().iterator();
        while (it.hasNext()) {
            key = (StopWatch)it.next();
            Task task = (Task)sortedTasks.get(key);
            StringBuffer sb = new StringBuffer();
            Target target = task.getOwningTarget();
            if (target != null) {
                Project p = target.getProject();
                if (p != null && p.getName() != null) {
                    sb.append(p.getName()).append(".");
                }
                if ((target_name = target.getName()) == null || target_name.length() == 0) {
                    target_name = "<implicit>";
                }
                sb.append(target_name).append(".");
            }
            sb.append(task.getTaskName()).append(": ").append(this.format(key.total()));
            msg.append(sb.toString()).append(lSep);
        }
        msg.append(lSep);
        msg.append("-------------- Totals -----------------------------").append(lSep);
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss.SSS");
        msg.append("Start time: " + format.format(new Date(this.start_time))).append(lSep);
        msg.append("Stop time: " + format.format(new Date(stop_time))).append(lSep);
        msg.append("Total time: " + this.format(this.master.total())).append(lSep);
        System.out.println(msg.toString());
        Project p = be.getProject();
        File outfile = null;
        if (p != null && (f = p.getProperty("performance.log")) != null) {
            outfile = new File(f);
        }
        if (outfile != null) {
            try {
                FileWriter fw = new FileWriter(outfile);
                fw.write(msg.toString());
                fw.flush();
                fw.close();
                System.out.println("Wrote stats to: " + outfile.getAbsolutePath() + lSep);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.targetStats = new HashMap();
        this.taskStats = new HashMap();
    }

    private String format(long ms) {
        String total = String.valueOf(ms);
        String frontpad = "000";
        int pad_length = 3 - total.length();
        total = pad_length >= 0 ? "0." + frontpad.substring(0, pad_length) + total : total.substring(0, total.length() - 3) + "." + total.substring(total.length() - 3);
        return total + " sec";
    }

    public void targetStarted(BuildEvent be) {
        StopWatch sw = new StopWatch();
        sw.start();
        this.targetStats.put(be.getTarget(), sw);
    }

    public void targetFinished(BuildEvent be) {
        StopWatch sw = (StopWatch)this.targetStats.get(be.getTarget());
        sw.stop();
    }

    public void taskStarted(BuildEvent be) {
        StopWatch sw = new StopWatch();
        sw.start();
        this.taskStats.put(be.getTask(), sw);
    }

    public void taskFinished(BuildEvent be) {
        StopWatch sw = (StopWatch)this.taskStats.get(be.getTask());
        if (sw != null) {
            sw.stop();
        }
    }

    public void messageLogged(BuildEvent be) {
    }

    public static void main(String[] args) {
        AntPerformanceListener apl = new AntPerformanceListener();
        System.out.println(apl.format(1L));
        System.out.println(apl.format(10L));
        System.out.println(apl.format(100L));
        System.out.println(apl.format(1000L));
        System.out.println(apl.format(100000L));
        System.out.println(apl.format(1000000L));
        System.out.println(apl.format(10000000L));
        System.out.println(apl.format(100000000L));
        System.out.println(apl.format(1000000000L));
    }

    public class StopWatch {
        private long _start_time = 0L;
        private long _stop_time = 0L;
        private long _total_time = 0L;

        public StopWatch() {
            this.start();
        }

        public long start() {
            this._start_time = System.currentTimeMillis();
            return this._start_time;
        }

        public long stop() {
            long stop_time = System.currentTimeMillis();
            this._total_time += stop_time - this._start_time;
            this._start_time = 0L;
            this._stop_time = 0L;
            return stop_time;
        }

        public long total() {
            return this._total_time;
        }

        public long elapsed() {
            return System.currentTimeMillis() - this._start_time;
        }
    }

    public class StopWatchComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            StopWatch a = (StopWatch)o1;
            StopWatch b = (StopWatch)o2;
            if (a.total() < b.total()) {
                return -1;
            }
            if (a.total() == b.total()) {
                return 0;
            }
            return 1;
        }
    }
}

