/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;

public class TinyBuilderMonitor
extends BuilderMonitor {
    private TinyBuilder builder;
    private int mark = -1;
    private int markedNodeNr = -1;
    private int markedAttribute = -1;
    private int markedNamespace = -1;

    public TinyBuilderMonitor(TinyBuilder builder) {
        this.builder = builder;
        this.setPipelineConfiguration(builder.getPipelineConfiguration());
        this.setUnderlyingReceiver(builder);
    }

    public void markNextNode(int nodeKind) {
        this.mark = nodeKind;
    }

    public void startDocument(int properties) throws XPathException {
        if (this.mark == 9) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.startDocument(properties);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.mark == 1) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.mark == 3) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.mark == 8) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.comment(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.mark == 7) {
            this.markedNodeNr = this.builder.getTree().getNumberOfNodes();
        }
        this.mark = -1;
        super.processingInstruction(target, data, locationId, properties);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.mark == 2) {
            this.markedAttribute = this.builder.getTree().getNumberOfAttributes();
        }
        this.mark = -1;
        super.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.mark == 13) {
            this.markedNamespace = this.builder.getTree().getNumberOfNamespaces();
        }
        this.mark = -1;
        super.namespace(namespaceCode, properties);
    }

    public NodeInfo getMarkedNode() {
        if (this.markedNodeNr != -1) {
            return this.builder.getTree().getNode(this.markedNodeNr);
        }
        if (this.markedAttribute != -1) {
            return this.builder.getTree().getAttributeNode(this.markedNodeNr);
        }
        if (this.markedNamespace != -1) {
            int nscode = this.builder.getTree().namespaceCode[this.markedNamespace];
            NamePool pool = this.builder.getConfiguration().getNamePool();
            String prefix = pool.getPrefixFromNamespaceCode(nscode);
            TinyNodeImpl parent = this.builder.getTree().getNode(this.builder.getTree().namespaceParent[this.markedNamespace]);
            NameTest test = new NameTest(13, "", prefix, pool);
            AxisIterator iter = parent.iterateAxis((byte)8, test);
            return (NodeInfo)iter.next();
        }
        return null;
    }
}

