/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.logging.Logger;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;

public class CollectionResolver
implements CollectionURIResolver {
    XProcRuntime runtime = null;
    Vector<XdmNode> docs = null;
    CollectionURIResolver chainedResolver = null;
    protected Logger logger = Logger.getLogger(this.getClass().getName());

    public CollectionResolver(XProcRuntime xProcRuntime, Vector<XdmNode> vector, CollectionURIResolver collectionURIResolver) {
        this.runtime = xProcRuntime;
        this.docs = vector;
        this.chainedResolver = collectionURIResolver;
    }

    public SequenceIterator resolve(String string, String string2, XPathContext xPathContext) throws XPathException {
        this.runtime.finest(null, null, "Collection: " + string + " (" + string2 + ")");
        if (string == null) {
            Item[] itemArray = new Item[this.docs.size()];
            for (int i = 0; i < this.docs.size(); ++i) {
                itemArray[i] = this.docs.get(i).getUnderlyingNode();
            }
            return new ArrayIterator(itemArray);
        }
        try {
            URI uRI = string2 == null ? new URI(string) : new URI(string2).resolve(string);
            Vector<XdmNode> vector = this.runtime.getCollection(uRI);
            if (vector != null) {
                Item[] itemArray = new Item[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    itemArray[i] = vector.get(i).getUnderlyingNode();
                }
                return new ArrayIterator(itemArray);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.runtime.finest(null, null, "URI Syntax exception resolving collection URI: " + string + " (" + string2 + ")");
        }
        return this.chainedResolver.resolve(string, string2, xPathContext);
    }
}

