/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class FormatCallout {
    protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static final String xhURI = "http://www.w3.org/1999/xhtml";
    protected String uri = "";
    protected boolean foStylesheet = false;
    protected boolean xhStylesheet = false;
    protected NamePool namePool = null;

    public FormatCallout(NamePool nPool, boolean fo, boolean xhtml) {
        this.namePool = nPool;
        this.foStylesheet = fo;
        this.xhStylesheet = xhtml;
    }

    public String areaLabel(Element area) {
        String label = null;
        if (area.hasAttribute("label")) {
            label = area.getAttribute("label");
        } else {
            Element parent = (Element)area.getParentNode();
            if (parent != null && parent.getLocalName().equalsIgnoreCase("areaset") && parent.hasAttribute("label")) {
                label = parent.getAttribute("label");
            }
        }
        return label;
    }

    public String areaID(Element area) {
        String id = null;
        id = area.hasAttribute("id") ? area.getAttribute("id") : (area.hasAttribute("xml:id") ? area.getAttribute("xml:id") : "");
        return id;
    }

    public void startSpan(Emitter rtf, String id) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            if (this.xhStylesheet) {
                this.uri = xhURI;
            }
            int spanName = this.namePool.allocate("", this.uri, "span");
            AttributeCollection spanAttr = new AttributeCollection(this.namePool);
            int[] namespaces = new int[1];
            spanAttr.addAttribute("", this.uri, "class", "CDATA", "co");
            spanAttr.addAttribute("", this.uri, "id", "CDATA", id);
            rtf.startElement(spanName, (Attributes)spanAttr, namespaces, 0);
        }
    }

    public void endSpan(Emitter rtf) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            if (this.xhStylesheet) {
                this.uri = xhURI;
            }
            int spanName = this.namePool.allocate("", this.uri, "span");
            rtf.endElement(spanName);
        }
    }

    public void formatTextCallout(Emitter rtfEmitter, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String id = this.areaID(area);
        String label = "(" + num + ")";
        if (userLabel != null) {
            label = userLabel;
        }
        char[] chars = label.toCharArray();
        try {
            int inlineName;
            this.startSpan(rtfEmitter, id);
            if (this.foStylesheet) {
                inlineName = this.namePool.allocate("fo", foURI, "inline");
                AttributeCollection inlineAttr = new AttributeCollection(this.namePool);
                int[] namespaces = new int[1];
                inlineAttr.addAttribute("", "", "id", "CDATA", id);
                rtfEmitter.startElement(inlineName, (Attributes)inlineAttr, namespaces, 0);
            }
            rtfEmitter.characters(chars, 0, label.length());
            this.endSpan(rtfEmitter);
            if (this.foStylesheet) {
                inlineName = this.namePool.allocate("fo", foURI, "inline");
                rtfEmitter.endElement(inlineName);
            }
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in formatTextCallout");
        }
    }

    public abstract void formatCallout(Emitter var1, Callout var2);
}

