/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.NamespaceMaintainer;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.NamespaceContextImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class EventToStaxBridge
implements XMLStreamReader {
    private EventIterator provider;
    private StartElementEvent startElementEvent;
    private Item currentItem;
    private Stack stack;
    private NamePool namePool;
    private boolean previousAtomic;
    private FastStringBuffer currentTextNode = new FastStringBuffer(64);
    private int currentStaxEvent = 7;
    private XPathException pendingException = null;

    public EventToStaxBridge(EventIterator provider, PipelineConfiguration pipe) {
        this.namePool = pipe.getConfiguration().getNamePool();
        EventIterator flatIterator = EventStackIterator.flatten(provider);
        if (flatIterator instanceof LocationProvider) {
            pipe.setLocationProvider((LocationProvider)((Object)flatIterator));
        }
        this.provider = new NamespaceMaintainer(flatIterator, this.namePool);
        this.stack = new Stack();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getAttributeCount() {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.startElementEvent.getAttributeCount();
    }

    public boolean isAttributeSpecified(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return true;
    }

    public QName getAttributeName(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        NodeInfo att = this.startElementEvent.getAttribute(i);
        return new QName(att.getURI(), att.getLocalPart(), att.getPrefix());
    }

    public String getAttributeLocalName(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.startElementEvent.getAttribute(i).getLocalPart();
    }

    public String getAttributeNamespace(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.startElementEvent.getAttribute(i).getURI();
    }

    public String getAttributePrefix(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.startElementEvent.getAttribute(i).getPrefix();
    }

    public String getAttributeType(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        int type = this.startElementEvent.getAttribute(i).getTypeAnnotation();
        if (type == 560) {
            return "ID";
        }
        if (type == 561) {
            return "IDREF";
        }
        if (type == 562) {
            return "IDREFS";
        }
        if (type == 556) {
            return "NMTOKEN";
        }
        if (type == 557) {
            return "NMTOKENS";
        }
        if (type == 563) {
            return "ENTITY";
        }
        if (type == 564) {
            return "ENTITIES";
        }
        return "CDATA";
    }

    public String getAttributeValue(int i) {
        if (this.currentStaxEvent != 1) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.startElementEvent.getAttribute(i).getStringValue();
    }

    public String getAttributeValue(String uri, String local) {
        Iterator iter = this.startElementEvent.iterateAttributes();
        while (iter.hasNext()) {
            NodeInfo att = (NodeInfo)iter.next();
            if (!att.getURI().equals(uri) || !att.getLocalPart().equals(local)) continue;
            return att.getStringValue();
        }
        return null;
    }

    public int getEventType() {
        return this.currentStaxEvent;
    }

    public int getNamespaceCount() {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        int[] nscodes = this.startElementEvent.getLocalNamespaces();
        for (int i = 0; i < nscodes.length; ++i) {
            if (nscodes[i] != -1) continue;
            return i;
        }
        return nscodes.length;
    }

    public String getText() {
        if (this.currentStaxEvent != 4 && this.currentStaxEvent != 5) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        if (this.previousAtomic) {
            return this.currentTextNode.toString();
        }
        return this.currentItem.getStringValue();
    }

    public int getTextLength() {
        if (this.currentStaxEvent != 4 && this.currentStaxEvent != 5) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.getText().length();
    }

    public int getTextStart() {
        if (this.currentStaxEvent != 4 && this.currentStaxEvent != 5) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return 0;
    }

    public char[] getTextCharacters() {
        if (this.currentStaxEvent != 4 && this.currentStaxEvent != 5) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        String stringValue = this.getText();
        char[] chars = new char[stringValue.length()];
        stringValue.getChars(0, chars.length, chars, 0);
        return chars;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.currentStaxEvent != 4 && this.currentStaxEvent != 5) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        if (targetStart < 0 || targetStart > target.length) {
            throw new IndexOutOfBoundsException("targetStart");
        }
        if (length < 0 || targetStart + length > target.length) {
            throw new IndexOutOfBoundsException("length");
        }
        String value = this.getText();
        if (sourceStart >= value.length()) {
            return 0;
        }
        int sourceEnd = sourceStart + length;
        if (sourceEnd > value.length()) {
            sourceEnd = value.length();
        }
        value.getChars(sourceStart, sourceEnd, target, targetStart);
        return sourceEnd - sourceStart;
    }

    public int next() throws XMLStreamException {
        PullEvent p;
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        try {
            p = this.provider.next();
        }
        catch (XPathException e) {
            throw new XMLStreamException(e);
        }
        if (p == null) {
            throw new NoSuchElementException("end of stream");
        }
        this.startElementEvent = null;
        if (p instanceof StartDocumentEvent) {
            this.currentStaxEvent = 7;
            return this.next();
        }
        if (p instanceof StartElementEvent) {
            this.startElementEvent = (StartElementEvent)p;
            this.currentStaxEvent = 1;
            this.stack.push(p);
            return this.currentStaxEvent;
        }
        if (p instanceof EndElementEvent) {
            this.currentStaxEvent = 2;
            this.startElementEvent = (StartElementEvent)this.stack.pop();
            return this.currentStaxEvent;
        }
        if (p instanceof EndDocumentEvent) {
            this.currentStaxEvent = 8;
            return this.currentStaxEvent;
        }
        if (p instanceof NodeInfo) {
            this.currentItem = (NodeInfo)p;
            switch (((NodeInfo)p).getNodeKind()) {
                case 8: {
                    this.currentStaxEvent = 5;
                    return this.currentStaxEvent;
                }
                case 7: {
                    this.currentStaxEvent = 3;
                    return this.currentStaxEvent;
                }
                case 3: {
                    this.currentStaxEvent = 4;
                    return this.currentStaxEvent;
                }
                case 2: {
                    throw new XMLStreamException("Encountered top-level attribute in sequence");
                }
            }
            throw new AssertionError((Object)"Unexpected node kind (sequence not decomposed?)");
        }
        if (p instanceof AtomicValue) {
            this.currentItem = (AtomicValue)p;
            this.currentStaxEvent = 4;
            this.previousAtomic = true;
            return this.currentStaxEvent;
        }
        if (p instanceof EventIterator) {
            throw new AssertionError((Object)"EventToStaxBridge requires a flattened event sequence");
        }
        throw new AssertionError((Object)("Unhandled pull event: " + p.getClass().getName()));
    }

    public int nextTag() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void close() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
    }

    public boolean hasName() {
        return this.currentStaxEvent == 1 || this.currentStaxEvent == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        return this.currentStaxEvent != 8;
    }

    public boolean hasText() {
        return this.currentStaxEvent == 4 || this.currentStaxEvent == 5;
    }

    public boolean isCharacters() {
        return this.currentStaxEvent == 4;
    }

    public boolean isEndElement() {
        return this.currentStaxEvent == 2;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean isStartElement() {
        return this.currentStaxEvent == 1;
    }

    public boolean isWhiteSpace() {
        return this.currentStaxEvent == 4 && Whitespace.isWhite(this.getText());
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuffer content = new StringBuffer();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content", this.getLocation());
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return content.toString();
    }

    public String getEncoding() {
        return null;
    }

    public String getLocalName() {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        return this.namePool.getLocalName(this.startElementEvent.getNameCode());
    }

    public String getNamespaceURI() {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            return null;
        }
        return this.namePool.getURI(this.startElementEvent.getNameCode());
    }

    public String getPIData() {
        if (this.currentStaxEvent != 3) {
            throw new IllegalStateException("Not positioned at a processing instruction");
        }
        return this.getText();
    }

    public String getPITarget() {
        if (this.currentStaxEvent != 3) {
            throw new IllegalStateException("Not positioned at a processing instruction");
        }
        return this.namePool.getLocalName(((NodeInfo)this.currentItem).getNameCode());
    }

    public String getPrefix() {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            return null;
        }
        return this.namePool.getPrefix(this.startElementEvent.getNameCode());
    }

    public String getVersion() {
        return "1.0";
    }

    public String getNamespacePrefix(int i) {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        int nscode = this.startElementEvent.getLocalNamespaces()[i];
        return this.namePool.getPrefixFromNamespaceCode(nscode);
    }

    public String getNamespaceURI(int i) {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        int nscode = this.startElementEvent.getLocalNamespaces()[i];
        return this.namePool.getURIFromNamespaceCode(nscode);
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContextImpl((NamespaceResolver)((Object)this.provider));
    }

    public QName getName() {
        if (this.currentStaxEvent != 1 && this.currentStaxEvent != 2) {
            throw new IllegalStateException("" + this.currentStaxEvent);
        }
        int nc = this.startElementEvent.getNameCode();
        return new QName(this.namePool.getURI(nc), this.namePool.getLocalName(nc), this.namePool.getPrefix(nc));
    }

    public Location getLocation() {
        if (this.startElementEvent != null) {
            PipelineConfiguration pipe = this.startElementEvent.getPipelineConfiguration();
            final LocationProvider provider = pipe.getLocationProvider();
            final int locationId = this.startElementEvent.getLocationId();
            if (provider != null) {
                return new Location(){

                    public int getCharacterOffset() {
                        return -1;
                    }

                    public int getColumnNumber() {
                        return provider.getColumnNumber(locationId);
                    }

                    public int getLineNumber() {
                        return provider.getLineNumber(locationId);
                    }

                    public String getPublicId() {
                        return null;
                    }

                    public String getSystemId() {
                        return provider.getSystemId(locationId);
                    }
                };
            }
        }
        if (this.currentItem instanceof NodeInfo) {
            final NodeInfo node = (NodeInfo)this.currentItem;
            return new Location(){

                public int getCharacterOffset() {
                    return -1;
                }

                public int getColumnNumber() {
                    return node.getColumnNumber();
                }

                public int getLineNumber() {
                    return node.getLineNumber();
                }

                public String getPublicId() {
                    return null;
                }

                public String getSystemId() {
                    return node.getSystemId();
                }
            };
        }
        return DummyLocation.THE_INSTANCE;
    }

    public Object getProperty(String s) throws IllegalArgumentException {
        return null;
    }

    public void require(int event, String uri, String local) throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.currentStaxEvent != event) {
            throw new XMLStreamException("Required event type is " + event + ", actual event is " + this.currentStaxEvent);
        }
        if (uri != null && !uri.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Required namespace is " + uri + ", actual is " + this.getNamespaceURI());
        }
        if (local != null && !local.equals(this.getLocalName())) {
            throw new XMLStreamException("Required local name is " + local + ", actual is " + this.getLocalName());
        }
    }

    public String getNamespaceURI(String prefix) {
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return ((NamespaceResolver)((Object)this.provider)).getURIForPrefix(prefix, true);
    }

    public EventIterator getProvider() {
        return this.provider;
    }

    private static class DummyLocation
    implements Location {
        public static final Location THE_INSTANCE = new DummyLocation();

        private DummyLocation() {
        }

        public int getCharacterOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    }
}

