/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class Subsequence
extends SystemFunction {
    public ItemType getItemType(TypeHierarchy th) {
        return this.argument[0].getItemType(th);
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public int computeCardinality() {
        if (this.getNumberOfArguments() == 3 && Literal.isConstantOne(this.argument[2])) {
            return 24576;
        }
        return this.argument[0].getCardinality() | 0x2000;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (this.getNumberOfArguments() == 2 && Literal.isAtomic(this.argument[1])) {
            NumericValue start = (NumericValue)((Literal)this.argument[1]).getValue();
            long intstart = (start = start.round(0)).longValue();
            if (intstart > Integer.MAX_VALUE) {
                return new Literal(EmptySequence.getInstance());
            }
            return new TailExpression(this.argument[0], (int)intstart);
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator seq = this.argument[0].iterate(context);
        AtomicValue startVal0 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue startVal = (NumericValue)startVal0;
        if (this.argument.length == 2) {
            long lstart;
            if (startVal instanceof Int64Value) {
                lstart = startVal.longValue();
                if (lstart <= 1L) {
                    return seq;
                }
            } else {
                if (startVal.isNaN()) {
                    return EmptyIterator.getInstance();
                }
                if ((startVal = startVal.round(0)).compareTo(Int64Value.PLUS_ONE) <= 0) {
                    return seq;
                }
                if (startVal.compareTo(Int64Value.MAX_LONG) > 0) {
                    return EmptyIterator.getInstance();
                }
                lstart = startVal.longValue();
            }
            if (lstart > Integer.MAX_VALUE) {
                return EmptyIterator.getInstance();
            }
            return TailIterator.make(seq, (int)lstart);
        }
        AtomicValue lengthVal0 = (AtomicValue)this.argument[2].evaluateItem(context);
        NumericValue lengthVal = (NumericValue)lengthVal0;
        if (startVal instanceof Int64Value && lengthVal instanceof Int64Value) {
            long lstart = startVal.longValue();
            if (lstart > Integer.MAX_VALUE) {
                return EmptyIterator.getInstance();
            }
            long llength = lengthVal.longValue();
            if (llength > Integer.MAX_VALUE) {
                llength = Integer.MAX_VALUE;
            }
            if (llength < 1L) {
                return EmptyIterator.getInstance();
            }
            long lend = lstart + llength - 1L;
            if (lend < 1L) {
                return EmptyIterator.getInstance();
            }
            int start = lstart < 1L ? 1 : (int)lstart;
            return SubsequenceIterator.make(seq, start, (int)lend);
        }
        if (startVal.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if (startVal.compareTo(Int64Value.MAX_LONG) > 0) {
            return EmptyIterator.getInstance();
        }
        startVal = startVal.round(0);
        if (lengthVal.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if ((lengthVal = lengthVal.round(0)).compareTo(Int64Value.ZERO) <= 0) {
            return EmptyIterator.getInstance();
        }
        NumericValue rend = (NumericValue)ArithmeticExpression.compute(startVal, 0, lengthVal, context);
        if (rend.isNaN()) {
            return EmptyIterator.getInstance();
        }
        if ((rend = (NumericValue)ArithmeticExpression.compute(rend, 1, Int64Value.PLUS_ONE, context)).compareTo(Int64Value.ZERO) <= 0) {
            return EmptyIterator.getInstance();
        }
        long lstart = startVal.compareTo(Int64Value.PLUS_ONE) <= 0 ? 1L : startVal.longValue();
        if (lstart > Integer.MAX_VALUE) {
            return EmptyIterator.getInstance();
        }
        long lend = rend.compareTo(Int64Value.MAX_LONG) >= 0 ? Integer.MAX_VALUE : rend.longValue();
        return SubsequenceIterator.make(seq, (int)lstart, (int)lend);
    }
}

