/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.match;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.match.IncorrectSchemaException;
import com.thaiopensource.relaxng.match.MatchablePattern;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.compact.CompactParseable;
import com.thaiopensource.relaxng.parse.sax.SAXParseable;
import com.thaiopensource.relaxng.pattern.FeasibleTransform;
import com.thaiopensource.relaxng.pattern.MatchablePatternImpl;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MatchablePatternLoader {
    public static final int COMPACT_SYNTAX_FLAG = 1;
    public static final int FEASIBLE_FLAG = 2;

    public MatchablePattern load(Input input, SAXResolver sAXResolver, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, int n) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        SubParseable subParseable = (n & 1) != 0 ? new CompactParseable(input, sAXResolver.getResolver(), errorHandler) : new SAXParseable(sAXResolver.createSAXSource(input), sAXResolver, errorHandler);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        try {
            Pattern pattern = SchemaBuilderImpl.parse(subParseable, errorHandler, datatypeLibraryFactory, schemaPatternBuilder, false);
            if ((n & 2) != 0) {
                pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
            }
            return new MatchablePatternImpl(schemaPatternBuilder, pattern);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new IncorrectSchemaException();
        }
    }
}

