/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CodepointCollatingComparer
implements AtomicComparer {
    private static CodepointCollator collator = CodepointCollator.getInstance();
    private static CodepointCollatingComparer THE_INSTANCE = new CodepointCollatingComparer();

    public static CodepointCollatingComparer getInstance() {
        return THE_INSTANCE;
    }

    private CodepointCollatingComparer() {
    }

    public StringCollator getCollator() {
        return collator;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        StringValue as = (StringValue)a;
        StringValue bs = (StringValue)b;
        if (as.containsSurrogatePairs() || bs.containsSurrogatePairs()) {
            return collator.compareCS(as.getStringValueCS(), bs.getStringValueCS());
        }
        return as.getStringValue().compareTo(bs.getStringValue());
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        StringValue as = (StringValue)a;
        StringValue bs = (StringValue)b;
        return as.codepointEquals(bs);
    }

    public ComparisonKey getComparisonKey(AtomicValue a) {
        StringValue as = (StringValue)a;
        return new ComparisonKey(513, as.getStringValue());
    }
}

