/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine.platform;

import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.python.constantine.Constant;
import org.python.constantine.ConstantSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantResolver<E extends Enum<E>> {
    public static final String __UNKNOWN_CONSTANT__ = "__UNKNOWN_CONSTANT__";
    private final Object modLock = new Object();
    private final Class<E> enumType;
    private final Map<Integer, E> reverseLookupMap = new ConcurrentHashMap<Integer, E>();
    private final AtomicInteger nextUnknown;
    private final int lastUnknown;
    private final boolean bitmask;
    private Constant[] cache = null;
    private volatile E[] valueCache = null;
    private volatile int cacheGuard = 0;
    private volatile ConstantSet constants;

    private ConstantResolver(Class<E> enumType) {
        this(enumType, Integer.MIN_VALUE, -2147482648, false);
    }

    private ConstantResolver(Class<E> enumType, int firstUnknown, int lastUnknown, boolean bitmask) {
        this.enumType = enumType;
        this.nextUnknown = new AtomicInteger(firstUnknown);
        this.lastUnknown = lastUnknown;
        this.bitmask = bitmask;
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType, int first, int last) {
        return new ConstantResolver<T>(enumType, first, last, false);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getBitmaskResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType, 0, Integer.MIN_VALUE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Constant getConstant(E e) {
        Constant c;
        if (this.cacheGuard != 0 && (c = this.cache[((Enum)e).ordinal()]) != null) {
            return c;
        }
        Object object = this.modLock;
        synchronized (object) {
            if (this.cacheGuard != 0 && (c = this.cache[((Enum)e).ordinal()]) != null) {
                return c;
            }
            EnumSet<Enum> enums = EnumSet.allOf(this.enumType);
            ConstantSet cset = this.getConstants();
            if (this.cache == null) {
                this.cache = new Constant[enums.size()];
            }
            long known = 0L;
            long unknown = 0L;
            for (Enum v : enums) {
                c = cset.getConstant(v.name());
                if (c == null) {
                    if (this.bitmask) {
                        unknown |= 1L << v.ordinal();
                        c = new UnknownConstant(0, v.name());
                    } else {
                        c = new UnknownConstant(this.nextUnknown.getAndAdd(1), v.name());
                    }
                } else if (this.bitmask) {
                    known |= (long)c.value();
                }
                this.cache[v.ordinal()] = c;
            }
            if (this.bitmask) {
                long l = 0L;
                while ((l = Long.lowestOneBit(unknown)) != 0L) {
                    void value;
                    int n = Long.numberOfTrailingZeros(l);
                    int n2 = Long.numberOfTrailingZeros(Long.lowestOneBit(known ^ 0xFFFFFFFFFFFFFFFFL));
                    int n3 = 1 << n2;
                    this.cache[value] = new UnknownConstant(n3, this.cache[value].name());
                    known |= (long)n3;
                    unknown &= 1L << value ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            this.cacheGuard = 1;
        }
        return this.cache[((Enum)e).ordinal()];
    }

    final int intValue(E e) {
        return this.getConstant(e).value();
    }

    final String description(E e) {
        return this.getConstant(e).toString();
    }

    final E valueOf(int value) {
        Enum e;
        if (value >= 0 && value < 256 && this.valueCache != null && (e = this.valueCache[value]) != null) {
            return (E)e;
        }
        e = (Enum)this.reverseLookupMap.get(value);
        if (e != null) {
            return (E)e;
        }
        Constant c = this.getConstants().getConstant(value);
        if (c != null) {
            try {
                e = Enum.valueOf(this.enumType, c.name());
                this.reverseLookupMap.put(value, e);
                if (c.value() >= 0 && c.value() < 256) {
                    Object[] values = this.valueCache;
                    if (values == null) {
                        values = (Enum[])Array.newInstance(this.enumType, 256);
                    }
                    values[c.value()] = e;
                    this.valueCache = values;
                }
                return (E)e;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return Enum.valueOf(this.enumType, __UNKNOWN_CONSTANT__);
    }

    private final ConstantSet getConstants() {
        if (this.constants == null) {
            this.constants = ConstantSet.getConstantSet(this.enumType.getSimpleName());
            if (this.constants == null) {
                throw new RuntimeException("Could not load platform constants for " + this.enumType.getSimpleName());
            }
        }
        return this.constants;
    }

    private static final class UnknownConstant
    implements Constant {
        private final int value;
        private final String name;

        UnknownConstant(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

