/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.StringPattern;
import com.thaiopensource.xml.util.Name;
import org.relaxng.datatype.Datatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValuePattern
extends StringPattern {
    private final Object obj;
    private final Datatype dt;
    private final Name dtName;
    private final String stringValue;

    ValuePattern(Datatype datatype, Name name, Object object, String string) {
        super(ValuePattern.combineHashCode(27, datatype.valueHashCode(object)));
        this.dt = datatype;
        this.dtName = name;
        this.obj = object;
        this.stringValue = string;
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (this.getClass() != pattern.getClass()) {
            return false;
        }
        if (!(pattern instanceof ValuePattern)) {
            return false;
        }
        return this.dt.equals(((ValuePattern)pattern).dt) && this.dt.sameValue(this.obj, ((ValuePattern)pattern).obj);
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseValue(this);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_value");
            }
        }
    }

    Datatype getDatatype() {
        return this.dt;
    }

    Name getDatatypeName() {
        return this.dtName;
    }

    Object getValue() {
        return this.obj;
    }

    String getStringValue() {
        return this.stringValue;
    }
}

