/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.XProcLocationProvider;
import java.net.URI;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.NamespaceIterator;

public class TreeWriter {
    protected static final String logger = "com.xmlcalabash.util";
    protected Controller controller = null;
    protected XProcRuntime runtime = null;
    protected Executable exec = null;
    protected NamePool pool = null;
    protected XdmDestination destination = null;
    protected Receiver receiver = null;
    protected XProcLocationProvider xLocationProvider = null;
    protected boolean seenRoot = false;
    protected boolean inDocument = false;

    public TreeWriter(XProcRuntime xproc) {
        this.runtime = xproc;
        this.controller = new Controller(this.runtime.getProcessor().getUnderlyingConfiguration());
        this.pool = this.controller.getNamePool();
        this.xLocationProvider = new XProcLocationProvider();
    }

    public TreeWriter(Processor proc) {
        this.controller = new Controller(proc.getUnderlyingConfiguration());
        this.pool = this.controller.getNamePool();
        this.xLocationProvider = new XProcLocationProvider();
    }

    public XdmNode getResult() {
        return this.destination.getXdmNode();
    }

    public boolean inDocument() {
        return this.inDocument;
    }

    public void startDocument(URI baseURI) {
        this.inDocument = true;
        this.seenRoot = false;
        try {
            this.exec = new Executable(this.controller.getConfiguration());
            this.destination = new XdmDestination();
            this.receiver = this.destination.getReceiver(this.controller.getConfiguration());
            this.receiver = new NamespaceReducer(this.receiver);
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            pipe.setLocationProvider((LocationProvider)this.xLocationProvider);
            this.receiver.setPipelineConfiguration(pipe);
            if (baseURI != null) {
                this.receiver.setSystemId(baseURI.toASCIIString());
            } else {
                this.receiver.setSystemId("http://example.com/");
            }
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    public void endDocument() {
        try {
            this.receiver.endDocument();
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addSubtree(XdmNode node) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            this.writeChildren(node);
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            this.addStartElement(node);
            XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                this.addAttribute(child, child.getStringValue());
            }
            try {
                this.receiver.startContent();
            }
            catch (XPathException xe) {
                throw new XProcException(xe);
            }
            this.writeChildren(node);
            this.addEndElement();
        } else if (node.getNodeKind() == XdmNodeKind.COMMENT) {
            this.addComment(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            this.addText(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            this.addPI(node.getNodeName().getLocalName(), node.getStringValue());
        } else {
            throw new UnsupportedOperationException("Unexpected node type");
        }
    }

    protected void writeChildren(XdmNode node) {
        XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            this.addSubtree(child);
        }
    }

    public void addStartElement(XdmNode node) {
        NodeInfo inode = node.getUnderlyingNode();
        int nameCode = inode.getNameCode();
        int typeCode = inode.getTypeAnnotation() & 0xFFFFF;
        int[] inscopeNS = null;
        if (this.seenRoot) {
            inscopeNS = inode.getDeclaredNamespaces(null);
        } else {
            inscopeNS = NamespaceIterator.getInScopeNamespaceCodes((NodeInfo)inode);
            this.seenRoot = true;
        }
        URI nodeBaseURI = node.getBaseURI();
        this.receiver.setSystemId(nodeBaseURI.toASCIIString());
        this.addStartElement(nameCode, typeCode, inscopeNS);
    }

    public void addStartElement(XdmNode node, QName newName) {
        NodeInfo inode = node.getUnderlyingNode();
        int nameCode = this.pool.allocate(newName.getPrefix(), newName.getNamespaceURI(), newName.getLocalName());
        int typeCode = inode.getTypeAnnotation() & 0xFFFFF;
        int[] inscopeNS = null;
        if (this.seenRoot) {
            inscopeNS = inode.getDeclaredNamespaces(null);
        } else {
            inscopeNS = NamespaceIterator.getInScopeNamespaceCodes((NodeInfo)inode);
            this.seenRoot = true;
        }
        if ("".equals(newName.getPrefix())) {
            int newLen = 0;
            for (int pos = 0; pos < inscopeNS.length; ++pos) {
                int nscode = inscopeNS[pos];
                String pfx = this.pool.getPrefixFromNamespaceCode(nscode);
                if ("".equals(pfx)) continue;
                ++newLen;
            }
            if (newLen != inscopeNS.length) {
                int[] newCodes = new int[newLen];
                int npos = 0;
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int nscode = inscopeNS[pos];
                    String pfx = this.pool.getPrefixFromNamespaceCode(nscode);
                    if ("".equals(pfx)) continue;
                    newCodes[npos++] = nscode;
                }
                inscopeNS = newCodes;
            }
        }
        URI nodeBaseURI = node.getBaseURI();
        this.receiver.setSystemId(nodeBaseURI.toASCIIString());
        this.addStartElement(nameCode, typeCode, inscopeNS);
    }

    public void addStartElement(QName newName) {
        int nameCode = this.pool.allocate(newName.getPrefix(), newName.getNamespaceURI(), newName.getLocalName());
        int typeCode = 630;
        int[] inscopeNS = null;
        this.addStartElement(nameCode, typeCode, inscopeNS);
    }

    public void addStartElement(int nameCode, int typeCode, int[] nscodes) {
        String sysId = this.receiver.getSystemId();
        int locId = sysId == null ? 0 : this.xLocationProvider.allocateLocation(sysId);
        try {
            this.receiver.startElement(nameCode, typeCode, locId, 0);
            if (nscodes != null) {
                for (int ns : nscodes) {
                    this.receiver.namespace(ns, 0);
                }
            }
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addNamespace(String prefix, String uri) {
        int nscode = this.pool.allocateNamespaceCode(prefix, uri);
        try {
            this.receiver.namespace(nscode, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addAttributes(XdmNode element) {
        XdmSequenceIterator iter = element.axisIterator(Axis.ATTRIBUTE);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            this.addAttribute(child);
        }
    }

    public void addAttribute(XdmNode xdmattr) {
        this.addAttribute(xdmattr, xdmattr.getStringValue());
    }

    public void addAttribute(XdmNode xdmattr, String newValue) {
        NodeInfo inode = xdmattr.getUnderlyingNode();
        int nameCode = inode.getNameCode();
        int typeCode = inode.getTypeAnnotation() & 0xFFFFF;
        try {
            this.receiver.attribute(nameCode, typeCode, (CharSequence)newValue, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addAttribute(int nameCode, int typeCode, String newValue) {
        try {
            this.receiver.attribute(nameCode, typeCode, (CharSequence)newValue, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addAttribute(QName attrName, String newValue) {
        int nameCode = this.pool.allocate(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalName());
        int typeCode = 631;
        try {
            this.receiver.attribute(nameCode, typeCode, (CharSequence)newValue, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void startContent() {
        try {
            this.receiver.startContent();
        }
        catch (XPathException xe) {
            throw new XProcException(xe);
        }
    }

    public void addEndElement() {
        try {
            this.receiver.endElement();
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addComment(String comment) {
        try {
            this.receiver.comment((CharSequence)comment, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addText(String text) {
        try {
            this.receiver.characters((CharSequence)text, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addPI(String target, String data) {
        try {
            this.receiver.processingInstruction(target, (CharSequence)data, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }
}

