/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -i
#include <assert.h>
#include <float.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>

#define YYMAXFILL 17

static const size_t SIZE = 64 * 1024;

struct input_t {
    unsigned char buf[SIZE + YYMAXFILL];
    unsigned char *lim;
    unsigned char *cur;
    unsigned char *mar;
    unsigned char *tok;
    bool eof;

    FILE *const file;

    input_t(FILE *f)
        : buf()
        , lim(buf + SIZE)
        , cur(lim)
        , mar(lim)
        , tok(lim)
        , eof(false)
        , file(f)
    {}
    bool fill(size_t need)
    {
        if (eof) {
            return false;
        }
        const size_t free = tok - buf;
        if (free < need) {
            return false;
        }
        memmove(buf, tok, lim - tok);
        lim -= free;
        cur -= free;
        mar -= free;
        tok -= free;
        lim += fread(lim, 1, free, file);
        if (lim < buf + SIZE) {
            eof = true;
            memset(lim, 0, YYMAXFILL);
            lim += YYMAXFILL;
        }
        return true;
    }
};



template<int base>
static bool adddgt(unsigned long &u, unsigned long d)
{
    if (u > (ULONG_MAX - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

static bool lex_oct(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0, ++s; s < e; ++s) {
        if (!adddgt<8>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

static bool lex_dec(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

static bool lex_hex(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0, s += 2; s < e;) {
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F': goto yy2;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy3;
		default: goto yy1;
	}
yy1:
	++s;
	{ if (!adddgt<16>(u, s[-1] - 0x30u))      return false; continue; }
yy2:
	++s;
	{ if (!adddgt<16>(u, s[-1] - 0x41u + 10)) return false; continue; }
yy3:
	++s;
	{ if (!adddgt<16>(u, s[-1] - 0x61u + 10)) return false; continue; }
}

    }
    return true;
}

static bool lex_str(input_t &in, unsigned char q)
{
    fprintf(stderr, "%c", q);
    for (unsigned long u = q;; fprintf(stderr, "\\x%lx", u)) {
        in.tok = in.cur;
        
{
	unsigned char yych;
	if ((in.lim - in.cur) < 10) if (!in.fill(10)) return false;
	yych = *in.cur;
	switch (yych) {
		case '\n': goto yy6;
		case '\\': goto yy8;
		default: goto yy5;
	}
yy5:
	++in.cur;
	{ u = in.tok[0]; if (u == q) break; continue; }
yy6:
	++in.cur;
yy7:
	{ return false; }
yy8:
	yych = *(in.mar = ++in.cur);
	switch (yych) {
		case '"': goto yy9;
		case '\'': goto yy10;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': goto yy11;
		case '?': goto yy13;
		case 'U': goto yy14;
		case '\\': goto yy16;
		case 'a': goto yy17;
		case 'b': goto yy18;
		case 'f': goto yy19;
		case 'n': goto yy20;
		case 'r': goto yy21;
		case 't': goto yy22;
		case 'u': goto yy23;
		case 'v': goto yy24;
		case 'x': goto yy25;
		default: goto yy7;
	}
yy9:
	++in.cur;
	{ u = '"';  continue; }
yy10:
	++in.cur;
	{ u = '\''; continue; }
yy11:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': goto yy26;
		default: goto yy12;
	}
yy12:
	{ lex_oct(in.tok, in.cur, u); continue; }
yy13:
	++in.cur;
	{ u = '?';  continue; }
yy14:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy27;
		default: goto yy15;
	}
yy15:
	in.cur = in.mar;
	goto yy7;
yy16:
	++in.cur;
	{ u = '\\'; continue; }
yy17:
	++in.cur;
	{ u = '\a'; continue; }
yy18:
	++in.cur;
	{ u = '\b'; continue; }
yy19:
	++in.cur;
	{ u = '\f'; continue; }
yy20:
	++in.cur;
	{ u = '\n'; continue; }
yy21:
	++in.cur;
	{ u = '\r'; continue; }
yy22:
	++in.cur;
	{ u = '\t'; continue; }
yy23:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy28;
		default: goto yy15;
	}
yy24:
	++in.cur;
	{ u = '\v'; continue; }
yy25:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy29;
		default: goto yy15;
	}
yy26:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': goto yy31;
		default: goto yy12;
	}
yy27:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy32;
		default: goto yy15;
	}
yy28:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy33;
		default: goto yy15;
	}
yy29:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy29;
		default: goto yy30;
	}
yy30:
	{ if (!lex_hex(in.tok, in.cur, u)) return false; continue; }
yy31:
	++in.cur;
	goto yy12;
yy32:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy34;
		default: goto yy15;
	}
yy33:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy35;
		default: goto yy15;
	}
yy34:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy36;
		default: goto yy15;
	}
yy35:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy37;
		default: goto yy15;
	}
yy36:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy38;
		default: goto yy15;
	}
yy37:
	++in.cur;
	{ lex_hex(in.tok, in.cur, u); continue; }
yy38:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy39;
		default: goto yy15;
	}
yy39:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy40;
		default: goto yy15;
	}
yy40:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy41;
		default: goto yy15;
	}
yy41:
	++in.cur;
	{ lex_hex(in.tok, in.cur, u); continue; }
}

    }
    fprintf(stderr, "%c", q);
    return true;
}

static bool lex_flt(const unsigned char *s)
{
    double d = 0;
    double x = 1;
    int e = 0;
    
mant_int:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
		case '.': goto yy44;
		case 'E':
		case 'e': goto yy45;
		default: goto yy43;
	}
yy43:
	++s;
	{ d = (d * 10) + (s[-1] - '0'); goto mant_int; }
yy44:
	++s;
	{ goto mant_frac; }
yy45:
	++s;
	{ goto exp_sign; }
}

mant_frac:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy48;
		case 'E':
		case 'e': goto yy49;
		default: goto yy47;
	}
yy47:
	{ goto sfx; }
yy48:
	++s;
	{ d += (x /= 10) * (s[-1] - '0'); goto mant_frac; }
yy49:
	++s;
	{ goto exp_sign; }
}

exp_sign:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
		case '+': goto yy52;
		case '-': goto yy53;
		default: goto yy51;
	}
yy51:
	{ x = 1e+1; goto exp; }
yy52:
	++s;
	goto yy51;
yy53:
	++s;
	{ x = 1e-1; goto exp; }
}

exp:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy56;
		default: goto yy55;
	}
yy55:
	{ for (; e > 0; --e) d *= x;    goto sfx; }
yy56:
	++s;
	{ e = (e * 10) + (s[-1] - '0'); goto exp; }
}

sfx:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
		case 'F':
		case 'f': goto yy59;
		default: goto yy58;
	}
yy58:
	++s;
	{ goto end; }
yy59:
	++s;
	{ if (d > FLT_MAX) return false; goto end; }
}

end:
    fprintf(stderr, "%g", d);
    return true;
}

static bool lex(input_t &in)
{
    unsigned long u;
    for (;;) {
        in.tok = in.cur;
        
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	if ((in.lim - in.cur) < 17) if (!in.fill(17)) return false;
	yych = *in.cur;
	switch (yych) {
		case 0x00: goto yy61;
		case '\t':
		case '\n':
		case '\v':
		case '\r':
		case ' ': goto yy63;
		case '!': goto yy65;
		case '"': goto yy67;
		case '#': goto yy69;
		case '%': goto yy70;
		case '&': goto yy72;
		case '\'': goto yy74;
		case '(': goto yy75;
		case ')': goto yy76;
		case '*': goto yy77;
		case '+': goto yy79;
		case ',': goto yy81;
		case '-': goto yy82;
		case '.': goto yy84;
		case '/': goto yy86;
		case '0': goto yy88;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy90;
		case ':': goto yy92;
		case ';': goto yy94;
		case '<': goto yy95;
		case '=': goto yy97;
		case '>': goto yy99;
		case '?': goto yy101;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'h':
		case 'j':
		case 'k':
		case 'q':
		case 'y':
		case 'z': goto yy102;
		case 'L': goto yy105;
		case '[': goto yy106;
		case ']': goto yy107;
		case '^': goto yy108;
		case 'a': goto yy110;
		case 'b': goto yy111;
		case 'c': goto yy112;
		case 'd': goto yy113;
		case 'e': goto yy114;
		case 'f': goto yy115;
		case 'g': goto yy116;
		case 'i': goto yy117;
		case 'l': goto yy118;
		case 'm': goto yy119;
		case 'n': goto yy120;
		case 'o': goto yy121;
		case 'p': goto yy122;
		case 'r': goto yy123;
		case 's': goto yy124;
		case 't': goto yy125;
		case 'u': goto yy126;
		case 'v': goto yy127;
		case 'w': goto yy128;
		case 'x': goto yy129;
		case '{': goto yy130;
		case '|': goto yy131;
		case '}': goto yy133;
		case '~': goto yy134;
		default: goto yy62;
	}
yy61:
	++in.cur;
	{
                fprintf(stderr, "\n");
                return in.lim - in.tok == YYMAXFILL;
            }
yy62:
	++in.cur;
	{ return false; }
yy63:
	yyaccept = 0;
	in.mar = ++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '\t':
		case '\n':
		case '\v':
		case '\r':
		case ' ': goto yy63;
		case '/': goto yy136;
		default: goto yy64;
	}
yy64:
	{ fprintf(stderr, " "); continue; }
yy65:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy138;
		default: goto yy66;
	}
yy66:
	{ fprintf(stderr, "!");      continue; }
yy67:
	++in.cur;
yy68:
	{ if (!lex_str(in, in.cur[-1])) return false; continue; }
yy69:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '\n': goto yy140;
		case '\\': goto yy141;
		default: goto yy69;
	}
yy70:
	yych = *++in.cur;
	switch (yych) {
		case ':': goto yy69;
		case '=': goto yy142;
		case '>': goto yy133;
		default: goto yy71;
	}
yy71:
	{ fprintf(stderr, "%%");     continue; }
yy72:
	yych = *++in.cur;
	switch (yych) {
		case '&': goto yy143;
		case '=': goto yy145;
		default: goto yy73;
	}
yy73:
	{ fprintf(stderr, "&");      continue; }
yy74:
	yych = *++in.cur;
	switch (yych) {
		case '\'': goto yy147;
		default: goto yy68;
	}
yy75:
	++in.cur;
	{ fprintf(stderr, "(");      continue; }
yy76:
	++in.cur;
	{ fprintf(stderr, ")");      continue; }
yy77:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy148;
		default: goto yy78;
	}
yy78:
	{ fprintf(stderr, "*");      continue; }
yy79:
	yych = *++in.cur;
	switch (yych) {
		case '+': goto yy149;
		case '=': goto yy150;
		default: goto yy80;
	}
yy80:
	{ fprintf(stderr, "+");      continue; }
yy81:
	++in.cur;
	{ fprintf(stderr, ",");      continue; }
yy82:
	yych = *++in.cur;
	switch (yych) {
		case '-': goto yy151;
		case '=': goto yy152;
		case '>': goto yy153;
		default: goto yy83;
	}
yy83:
	{ fprintf(stderr, "-");      continue; }
yy84:
	yyaccept = 1;
	yych = *(in.mar = ++in.cur);
	switch (yych) {
		case '*': goto yy155;
		case '.': goto yy156;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy157;
		default: goto yy85;
	}
yy85:
	{ fprintf(stderr, ".");      continue; }
yy86:
	yych = *++in.cur;
	switch (yych) {
		case '*': goto yy159;
		case '/': goto yy160;
		case '=': goto yy161;
		default: goto yy87;
	}
yy87:
	{ fprintf(stderr, "/");      continue; }
yy88:
	yyaccept = 2;
	yych = *(in.mar = ++in.cur);
	switch (yych) {
		case 'X':
		case 'x': goto yy166;
		default: goto yy163;
	}
yy89:
	{ if (!lex_oct(in.tok, in.cur, u)) return false; goto sfx; }
yy90:
	yyaccept = 3;
	in.mar = ++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
	switch (yych) {
		case '.': goto yy157;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy90;
		case 'E':
		case 'e': goto yy165;
		default: goto yy91;
	}
yy91:
	{ if (!lex_dec(in.tok, in.cur, u)) return false; goto sfx; }
yy92:
	yych = *++in.cur;
	switch (yych) {
		case ':': goto yy167;
		case '>': goto yy107;
		default: goto yy93;
	}
yy93:
	{ fprintf(stderr, ":");      continue; }
yy94:
	++in.cur;
	{ fprintf(stderr, ";");      continue; }
yy95:
	yych = *++in.cur;
	switch (yych) {
		case '%': goto yy130;
		case ':': goto yy106;
		case '<': goto yy168;
		case '=': goto yy170;
		default: goto yy96;
	}
yy96:
	{ fprintf(stderr, "<");      continue; }
yy97:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy171;
		default: goto yy98;
	}
yy98:
	{ fprintf(stderr, "=");      continue; }
yy99:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy172;
		case '>': goto yy173;
		default: goto yy100;
	}
yy100:
	{ fprintf(stderr, ">");      continue; }
yy101:
	++in.cur;
	{ fprintf(stderr, "?");      continue; }
yy102:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
yy103:
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy104;
	}
yy104:
	{ fprintf(stderr, "%.*s", (int)(in.cur - in.tok), in.tok); continue; }
yy105:
	yych = *++in.cur;
	switch (yych) {
		case '"': goto yy67;
		case '\'': goto yy74;
		default: goto yy103;
	}
yy106:
	++in.cur;
	{ fprintf(stderr, "[");      continue; }
yy107:
	++in.cur;
	{ fprintf(stderr, "]");      continue; }
yy108:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy175;
		default: goto yy109;
	}
yy109:
	{ fprintf(stderr, "^");      continue; }
yy110:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy177;
		case 's': goto yy178;
		case 'u': goto yy179;
		default: goto yy103;
	}
yy111:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy180;
		case 'o': goto yy181;
		case 'r': goto yy182;
		default: goto yy103;
	}
yy112:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy183;
		case 'h': goto yy184;
		case 'l': goto yy185;
		case 'o': goto yy186;
		default: goto yy103;
	}
yy113:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy187;
		case 'o': goto yy188;
		case 'y': goto yy190;
		default: goto yy103;
	}
yy114:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy191;
		case 'n': goto yy192;
		case 'x': goto yy193;
		default: goto yy103;
	}
yy115:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy194;
		case 'l': goto yy195;
		case 'o': goto yy196;
		case 'r': goto yy197;
		default: goto yy103;
	}
yy116:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy198;
		default: goto yy103;
	}
yy117:
	yych = *++in.cur;
	switch (yych) {
		case 'f': goto yy199;
		case 'n': goto yy201;
		default: goto yy103;
	}
yy118:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy202;
		default: goto yy103;
	}
yy119:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy203;
		default: goto yy103;
	}
yy120:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy204;
		case 'e': goto yy205;
		case 'o': goto yy206;
		default: goto yy103;
	}
yy121:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy207;
		case 'r': goto yy208;
		default: goto yy103;
	}
yy122:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy210;
		case 'u': goto yy211;
		default: goto yy103;
	}
yy123:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy212;
		default: goto yy103;
	}
yy124:
	yych = *++in.cur;
	switch (yych) {
		case 'h': goto yy213;
		case 'i': goto yy214;
		case 't': goto yy215;
		case 'w': goto yy216;
		default: goto yy103;
	}
yy125:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy217;
		case 'h': goto yy218;
		case 'r': goto yy219;
		case 'y': goto yy220;
		default: goto yy103;
	}
yy126:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy221;
		case 's': goto yy222;
		default: goto yy103;
	}
yy127:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy223;
		case 'o': goto yy224;
		default: goto yy103;
	}
yy128:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy225;
		case 'h': goto yy226;
		default: goto yy103;
	}
yy129:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy227;
		default: goto yy103;
	}
yy130:
	++in.cur;
	{ fprintf(stderr, "{");      continue; }
yy131:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy228;
		case '|': goto yy230;
		default: goto yy132;
	}
yy132:
	{ fprintf(stderr, "|");      continue; }
yy133:
	++in.cur;
	{ fprintf(stderr, "}");      continue; }
yy134:
	++in.cur;
yy135:
	{ fprintf(stderr, "~");      continue; }
yy136:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '*': goto yy159;
		case '/': goto yy160;
		default: goto yy137;
	}
yy137:
	in.cur = in.mar;
	switch (yyaccept) {
		case 0: goto yy64;
		case 1: goto yy85;
		case 2: goto yy89;
		case 3: goto yy91;
		default: goto yy158;
	}
yy138:
	++in.cur;
yy139:
	{ fprintf(stderr, "!=");     continue; }
yy140:
	++in.cur;
	{ continue; }
yy141:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '\\': goto yy141;
		default: goto yy69;
	}
yy142:
	++in.cur;
	{ fprintf(stderr, "%%=");    continue; }
yy143:
	++in.cur;
yy144:
	{ fprintf(stderr, "&&");     continue; }
yy145:
	++in.cur;
yy146:
	{ fprintf(stderr, "&=");     continue; }
yy147:
	++in.cur;
	{ return false; }
yy148:
	++in.cur;
	{ fprintf(stderr, "*=");     continue; }
yy149:
	++in.cur;
	{ fprintf(stderr, "++");     continue; }
yy150:
	++in.cur;
	{ fprintf(stderr, "+=");     continue; }
yy151:
	++in.cur;
	{ fprintf(stderr, "--");     continue; }
yy152:
	++in.cur;
	{ fprintf(stderr, "-=");     continue; }
yy153:
	yych = *++in.cur;
	switch (yych) {
		case '*': goto yy231;
		default: goto yy154;
	}
yy154:
	{ fprintf(stderr, "->");     continue; }
yy155:
	++in.cur;
	{ fprintf(stderr, ".");      continue; }
yy156:
	yych = *++in.cur;
	switch (yych) {
		case '.': goto yy232;
		default: goto yy137;
	}
yy157:
	yyaccept = 4;
	in.mar = ++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy157;
		case 'E':
		case 'e': goto yy165;
		case 'F':
		case 'L':
		case 'f':
		case 'l': goto yy233;
		default: goto yy158;
	}
yy158:
	{ if (lex_flt(in.tok)) continue; return false; }
yy159:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '*': goto yy234;
		default: goto yy159;
	}
yy160:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '\n': goto yy63;
		default: goto yy160;
	}
yy161:
	++in.cur;
	{ fprintf(stderr, "/=");     continue; }
yy162:
	yyaccept = 2;
	in.mar = ++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
yy163:
	switch (yych) {
		case '.': goto yy157;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': goto yy162;
		case '8':
		case '9': goto yy164;
		case 'E':
		case 'e': goto yy165;
		default: goto yy89;
	}
yy164:
	++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
	switch (yych) {
		case '.': goto yy157;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy164;
		case 'E':
		case 'e': goto yy165;
		default: goto yy137;
	}
yy165:
	yych = *++in.cur;
	switch (yych) {
		case '+':
		case '-': goto yy235;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy236;
		default: goto yy137;
	}
yy166:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy237;
		default: goto yy137;
	}
yy167:
	++in.cur;
	{ fprintf(stderr, "::");     continue; }
yy168:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy239;
		default: goto yy169;
	}
yy169:
	{ fprintf(stderr, "<<");     continue; }
yy170:
	++in.cur;
	{ fprintf(stderr, "<=");     continue; }
yy171:
	++in.cur;
	{ fprintf(stderr, "==");     continue; }
yy172:
	++in.cur;
	{ fprintf(stderr, ">=");     continue; }
yy173:
	yych = *++in.cur;
	switch (yych) {
		case '=': goto yy240;
		default: goto yy174;
	}
yy174:
	{ fprintf(stderr, ">>");     continue; }
yy175:
	++in.cur;
yy176:
	{ fprintf(stderr, "^=");     continue; }
yy177:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy241;
		default: goto yy103;
	}
yy178:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy242;
		default: goto yy103;
	}
yy179:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy244;
		default: goto yy103;
	}
yy180:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy245;
		default: goto yy103;
	}
yy181:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy246;
		default: goto yy103;
	}
yy182:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy247;
		default: goto yy103;
	}
yy183:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy248;
		case 't': goto yy249;
		default: goto yy103;
	}
yy184:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy250;
		default: goto yy103;
	}
yy185:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy251;
		default: goto yy103;
	}
yy186:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy252;
		case 'n': goto yy253;
		default: goto yy103;
	}
yy187:
	yych = *++in.cur;
	switch (yych) {
		case 'f': goto yy254;
		case 'l': goto yy255;
		default: goto yy103;
	}
yy188:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'u': goto yy256;
		default: goto yy189;
	}
yy189:
	{ fprintf(stderr, "DO");               continue; }
yy190:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy257;
		default: goto yy103;
	}
yy191:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy258;
		default: goto yy103;
	}
yy192:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy259;
		default: goto yy103;
	}
yy193:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy260;
		case 't': goto yy261;
		default: goto yy103;
	}
yy194:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy262;
		default: goto yy103;
	}
yy195:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy263;
		default: goto yy103;
	}
yy196:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy264;
		default: goto yy103;
	}
yy197:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy266;
		default: goto yy103;
	}
yy198:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy267;
		default: goto yy103;
	}
yy199:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy200;
	}
yy200:
	{ fprintf(stderr, "IF");               continue; }
yy201:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy268;
		case 't': goto yy269;
		default: goto yy103;
	}
yy202:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy271;
		default: goto yy103;
	}
yy203:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy272;
		default: goto yy103;
	}
yy204:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy273;
		default: goto yy103;
	}
yy205:
	yych = *++in.cur;
	switch (yych) {
		case 'w': goto yy274;
		default: goto yy103;
	}
yy206:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy276;
		default: goto yy103;
	}
yy207:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy277;
		default: goto yy103;
	}
yy208:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case '_': goto yy278;
		default: goto yy209;
	}
yy209:
	{ fprintf(stderr, "||");     continue; }
yy210:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy279;
		case 'o': goto yy280;
		default: goto yy103;
	}
yy211:
	yych = *++in.cur;
	switch (yych) {
		case 'b': goto yy281;
		default: goto yy103;
	}
yy212:
	yych = *++in.cur;
	switch (yych) {
		case 'g': goto yy282;
		case 'i': goto yy283;
		case 't': goto yy284;
		default: goto yy103;
	}
yy213:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy285;
		default: goto yy103;
	}
yy214:
	yych = *++in.cur;
	switch (yych) {
		case 'g': goto yy286;
		case 'z': goto yy287;
		default: goto yy103;
	}
yy215:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy288;
		case 'r': goto yy289;
		default: goto yy103;
	}
yy216:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy290;
		default: goto yy103;
	}
yy217:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy291;
		default: goto yy103;
	}
yy218:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy292;
		case 'r': goto yy293;
		default: goto yy103;
	}
yy219:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy294;
		case 'y': goto yy295;
		default: goto yy103;
	}
yy220:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy297;
		default: goto yy103;
	}
yy221:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy298;
		case 's': goto yy299;
		default: goto yy103;
	}
yy222:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy300;
		default: goto yy103;
	}
yy223:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy301;
		default: goto yy103;
	}
yy224:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy302;
		case 'l': goto yy303;
		default: goto yy103;
	}
yy225:
	yych = *++in.cur;
	switch (yych) {
		case 'h': goto yy304;
		default: goto yy103;
	}
yy226:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy305;
		default: goto yy103;
	}
yy227:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy306;
		default: goto yy103;
	}
yy228:
	++in.cur;
yy229:
	{ fprintf(stderr, "|=");     continue; }
yy230:
	++in.cur;
	goto yy209;
yy231:
	++in.cur;
	{ fprintf(stderr, "->*");    continue; }
yy232:
	++in.cur;
	{ fprintf(stderr, "...");    continue; }
yy233:
	++in.cur;
	goto yy158;
yy234:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '/': goto yy63;
		default: goto yy159;
	}
yy235:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy236;
		default: goto yy137;
	}
yy236:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy236;
		case 'F':
		case 'L':
		case 'f':
		case 'l': goto yy233;
		default: goto yy158;
	}
yy237:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f': goto yy237;
		default: goto yy238;
	}
yy238:
	{ if (!lex_hex(in.tok, in.cur, u)) return false; goto sfx; }
yy239:
	++in.cur;
	{ fprintf(stderr, "<<=");    continue; }
yy240:
	++in.cur;
	{ fprintf(stderr, ">>=");    continue; }
yy241:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case '_': goto yy307;
		default: goto yy144;
	}
yy242:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy243;
	}
yy243:
	{ fprintf(stderr, "ASM");              continue; }
yy244:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy308;
		default: goto yy103;
	}
yy245:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy310;
		case 'o': goto yy311;
		default: goto yy103;
	}
yy246:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy312;
		default: goto yy103;
	}
yy247:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy314;
		default: goto yy103;
	}
yy248:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy315;
		default: goto yy103;
	}
yy249:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy317;
		default: goto yy103;
	}
yy250:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy318;
		default: goto yy103;
	}
yy251:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy320;
		default: goto yy103;
	}
yy252:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy321;
		default: goto yy103;
	}
yy253:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy322;
		case 't': goto yy323;
		default: goto yy103;
	}
yy254:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy324;
		default: goto yy103;
	}
yy255:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy325;
		default: goto yy103;
	}
yy256:
	yych = *++in.cur;
	switch (yych) {
		case 'b': goto yy326;
		default: goto yy103;
	}
yy257:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy327;
		default: goto yy103;
	}
yy258:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy328;
		default: goto yy103;
	}
yy259:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy330;
		default: goto yy103;
	}
yy260:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy332;
		case 'o': goto yy333;
		default: goto yy103;
	}
yy261:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy334;
		default: goto yy103;
	}
yy262:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy335;
		default: goto yy103;
	}
yy263:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy336;
		default: goto yy103;
	}
yy264:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy265;
	}
yy265:
	{ fprintf(stderr, "FOR");              continue; }
yy266:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy337;
		default: goto yy103;
	}
yy267:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy338;
		default: goto yy103;
	}
yy268:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy340;
		default: goto yy103;
	}
yy269:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy270;
	}
yy270:
	{ fprintf(stderr, "INT");              continue; }
yy271:
	yych = *++in.cur;
	switch (yych) {
		case 'g': goto yy341;
		default: goto yy103;
	}
yy272:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy343;
		default: goto yy103;
	}
yy273:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy344;
		default: goto yy103;
	}
yy274:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy275;
	}
yy275:
	{ fprintf(stderr, "new");    continue; }
yy276:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case '_': goto yy345;
		default: goto yy66;
	}
yy277:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy346;
		default: goto yy103;
	}
yy278:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy347;
		default: goto yy103;
	}
yy279:
	yych = *++in.cur;
	switch (yych) {
		case 'v': goto yy348;
		default: goto yy103;
	}
yy280:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy349;
		default: goto yy103;
	}
yy281:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy350;
		default: goto yy103;
	}
yy282:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy351;
		default: goto yy103;
	}
yy283:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy352;
		default: goto yy103;
	}
yy284:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy353;
		default: goto yy103;
	}
yy285:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy354;
		default: goto yy103;
	}
yy286:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy355;
		default: goto yy103;
	}
yy287:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy356;
		default: goto yy103;
	}
yy288:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy357;
		default: goto yy103;
	}
yy289:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy358;
		default: goto yy103;
	}
yy290:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy359;
		default: goto yy103;
	}
yy291:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy360;
		default: goto yy103;
	}
yy292:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy361;
		default: goto yy103;
	}
yy293:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy363;
		default: goto yy103;
	}
yy294:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy364;
		default: goto yy103;
	}
yy295:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy296;
	}
yy296:
	{ fprintf(stderr, "TRY");              continue; }
yy297:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy366;
		default: goto yy103;
	}
yy298:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy367;
		default: goto yy103;
	}
yy299:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy368;
		default: goto yy103;
	}
yy300:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy369;
		default: goto yy103;
	}
yy301:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy370;
		default: goto yy103;
	}
yy302:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy371;
		default: goto yy103;
	}
yy303:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy373;
		default: goto yy103;
	}
yy304:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy374;
		default: goto yy103;
	}
yy305:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy375;
		default: goto yy103;
	}
yy306:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case '_': goto yy376;
		default: goto yy109;
	}
yy307:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy377;
		default: goto yy103;
	}
yy308:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy309;
	}
yy309:
	{ fprintf(stderr, "AUTO");             continue; }
yy310:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy378;
		default: goto yy103;
	}
yy311:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy379;
		default: goto yy103;
	}
yy312:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy313;
	}
yy313:
	{ fprintf(stderr, "BOOL");             continue; }
yy314:
	yych = *++in.cur;
	switch (yych) {
		case 'k': goto yy380;
		default: goto yy103;
	}
yy315:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy316;
	}
yy316:
	{ fprintf(stderr, "CASE");             continue; }
yy317:
	yych = *++in.cur;
	switch (yych) {
		case 'h': goto yy382;
		default: goto yy103;
	}
yy318:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy319;
	}
yy319:
	{ fprintf(stderr, "CHAR");             continue; }
yy320:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy384;
		default: goto yy103;
	}
yy321:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy386;
		default: goto yy103;
	}
yy322:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy387;
		default: goto yy103;
	}
yy323:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy389;
		default: goto yy103;
	}
yy324:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy390;
		default: goto yy103;
	}
yy325:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy391;
		default: goto yy103;
	}
yy326:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy392;
		default: goto yy103;
	}
yy327:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy393;
		default: goto yy103;
	}
yy328:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy329;
	}
yy329:
	{ fprintf(stderr, "ELSE");             continue; }
yy330:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy331;
	}
yy331:
	{ fprintf(stderr, "ENUM");             continue; }
yy332:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy394;
		default: goto yy103;
	}
yy333:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy395;
		default: goto yy103;
	}
yy334:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy396;
		default: goto yy103;
	}
yy335:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy397;
		default: goto yy103;
	}
yy336:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy399;
		default: goto yy103;
	}
yy337:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy401;
		default: goto yy103;
	}
yy338:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy339;
	}
yy339:
	{ fprintf(stderr, "GOTO");             continue; }
yy340:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy402;
		default: goto yy103;
	}
yy341:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy342;
	}
yy342:
	{ fprintf(stderr, "LONG");             continue; }
yy343:
	yych = *++in.cur;
	switch (yych) {
		case 'b': goto yy403;
		default: goto yy103;
	}
yy344:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy404;
		default: goto yy103;
	}
yy345:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy405;
		default: goto yy103;
	}
yy346:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy406;
		default: goto yy103;
	}
yy347:
	yych = *++in.cur;
	switch (yych) {
		case 'q': goto yy407;
		default: goto yy103;
	}
yy348:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy408;
		default: goto yy103;
	}
yy349:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy409;
		default: goto yy103;
	}
yy350:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy410;
		default: goto yy103;
	}
yy351:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy411;
		default: goto yy103;
	}
yy352:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy412;
		default: goto yy103;
	}
yy353:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy413;
		default: goto yy103;
	}
yy354:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy414;
		default: goto yy103;
	}
yy355:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy416;
		default: goto yy103;
	}
yy356:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy417;
		default: goto yy103;
	}
yy357:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy418;
		default: goto yy103;
	}
yy358:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy419;
		default: goto yy103;
	}
yy359:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy420;
		default: goto yy103;
	}
yy360:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy421;
		default: goto yy103;
	}
yy361:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy362;
	}
yy362:
	{ fprintf(stderr, "THIS");             continue; }
yy363:
	yych = *++in.cur;
	switch (yych) {
		case 'w': goto yy422;
		default: goto yy103;
	}
yy364:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy365;
	}
yy365:
	{ fprintf(stderr, "true");  continue; }
yy366:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy424;
		case 'i': goto yy425;
		case 'n': goto yy426;
		default: goto yy103;
	}
yy367:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy427;
		default: goto yy103;
	}
yy368:
	yych = *++in.cur;
	switch (yych) {
		case 'g': goto yy429;
		default: goto yy103;
	}
yy369:
	yych = *++in.cur;
	switch (yych) {
		case 'g': goto yy430;
		default: goto yy103;
	}
yy370:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy432;
		default: goto yy103;
	}
yy371:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy372;
	}
yy372:
	{ fprintf(stderr, "VOID");             continue; }
yy373:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy433;
		default: goto yy103;
	}
yy374:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy434;
		default: goto yy103;
	}
yy375:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy435;
		default: goto yy103;
	}
yy376:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy437;
		default: goto yy103;
	}
yy377:
	yych = *++in.cur;
	switch (yych) {
		case 'q': goto yy438;
		default: goto yy103;
	}
yy378:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy439;
		default: goto yy103;
	}
yy379:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy132;
	}
yy380:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy381;
	}
yy381:
	{ fprintf(stderr, "BREAK");            continue; }
yy382:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy383;
	}
yy383:
	{ fprintf(stderr, "CATCH");            continue; }
yy384:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy385;
	}
yy385:
	{ fprintf(stderr, "CLASS");            continue; }
yy386:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy135;
	}
yy387:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case '_': goto yy440;
		default: goto yy388;
	}
yy388:
	{ fprintf(stderr, "CONST");            continue; }
yy389:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy441;
		default: goto yy103;
	}
yy390:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy442;
		default: goto yy103;
	}
yy391:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy443;
		default: goto yy103;
	}
yy392:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy445;
		default: goto yy103;
	}
yy393:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy447;
		default: goto yy103;
	}
yy394:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy448;
		default: goto yy103;
	}
yy395:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy449;
		default: goto yy103;
	}
yy396:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy451;
		default: goto yy103;
	}
yy397:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy398;
	}
yy398:
	{ fprintf(stderr, "false"); continue; }
yy399:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy400;
	}
yy400:
	{ fprintf(stderr, "FLOAT");            continue; }
yy401:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy453;
		default: goto yy103;
	}
yy402:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy455;
		default: goto yy103;
	}
yy403:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy457;
		default: goto yy103;
	}
yy404:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy458;
		default: goto yy103;
	}
yy405:
	yych = *++in.cur;
	switch (yych) {
		case 'q': goto yy459;
		default: goto yy103;
	}
yy406:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy460;
		default: goto yy103;
	}
yy407:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy229;
	}
yy408:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy461;
		default: goto yy103;
	}
yy409:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy462;
		default: goto yy103;
	}
yy410:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy463;
		default: goto yy103;
	}
yy411:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy465;
		default: goto yy103;
	}
yy412:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy466;
		default: goto yy103;
	}
yy413:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy467;
		default: goto yy103;
	}
yy414:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy415;
	}
yy415:
	{ fprintf(stderr, "SHORT");            continue; }
yy416:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy469;
		default: goto yy103;
	}
yy417:
	yych = *++in.cur;
	switch (yych) {
		case 'f': goto yy471;
		default: goto yy103;
	}
yy418:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy473;
		default: goto yy103;
	}
yy419:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy475;
		default: goto yy103;
	}
yy420:
	yych = *++in.cur;
	switch (yych) {
		case 'h': goto yy477;
		default: goto yy103;
	}
yy421:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy479;
		default: goto yy103;
	}
yy422:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy423;
	}
yy423:
	{ fprintf(stderr, "THROW");            continue; }
yy424:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy480;
		default: goto yy103;
	}
yy425:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy481;
		default: goto yy103;
	}
yy426:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy483;
		default: goto yy103;
	}
yy427:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy428;
	}
yy428:
	{ fprintf(stderr, "UNION");            continue; }
yy429:
	yych = *++in.cur;
	switch (yych) {
		case 'n': goto yy484;
		default: goto yy103;
	}
yy430:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy431;
	}
yy431:
	{ fprintf(stderr, "USING");            continue; }
yy432:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy485;
		default: goto yy103;
	}
yy433:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy486;
		default: goto yy103;
	}
yy434:
	yych = *++in.cur;
	switch (yych) {
		case '_': goto yy487;
		default: goto yy103;
	}
yy435:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy436;
	}
yy436:
	{ fprintf(stderr, "WHILE");            continue; }
yy437:
	yych = *++in.cur;
	switch (yych) {
		case 'q': goto yy488;
		default: goto yy103;
	}
yy438:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy146;
	}
yy439:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy73;
	}
yy440:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy489;
		default: goto yy103;
	}
yy441:
	yych = *++in.cur;
	switch (yych) {
		case 'u': goto yy490;
		default: goto yy103;
	}
yy442:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy491;
		default: goto yy103;
	}
yy443:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy444;
	}
yy444:
	{ fprintf(stderr, "delete"); continue; }
yy445:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy446;
	}
yy446:
	{ fprintf(stderr, "DOUBLE");           continue; }
yy447:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy493;
		default: goto yy103;
	}
yy448:
	yych = *++in.cur;
	switch (yych) {
		case 'i': goto yy494;
		default: goto yy103;
	}
yy449:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy450;
	}
yy450:
	{ fprintf(stderr, "EXPORT");           continue; }
yy451:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy452;
	}
yy452:
	{ fprintf(stderr, "EXTERN");           continue; }
yy453:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy454;
	}
yy454:
	{ fprintf(stderr, "FRIEND");           continue; }
yy455:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy456;
	}
yy456:
	{ fprintf(stderr, "INLINE");           continue; }
yy457:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy495;
		default: goto yy103;
	}
yy458:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy497;
		default: goto yy103;
	}
yy459:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy139;
	}
yy460:
	yych = *++in.cur;
	switch (yych) {
		case 'o': goto yy498;
		default: goto yy103;
	}
yy461:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy499;
		default: goto yy103;
	}
yy462:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy501;
		default: goto yy103;
	}
yy463:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy464;
	}
yy464:
	{ fprintf(stderr, "PUBLIC");           continue; }
yy465:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy502;
		default: goto yy103;
	}
yy466:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy503;
		default: goto yy103;
	}
yy467:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy468;
	}
yy468:
	{ fprintf(stderr, "RETURN");           continue; }
yy469:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy470;
	}
yy470:
	{ fprintf(stderr, "SIGNED");           continue; }
yy471:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy472;
	}
yy472:
	{ fprintf(stderr, "SIZEOF");           continue; }
yy473:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case '_': goto yy504;
		default: goto yy474;
	}
yy474:
	{ fprintf(stderr, "STATIC");           continue; }
yy475:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy476;
	}
yy476:
	{ fprintf(stderr, "STRUCT");           continue; }
yy477:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy478;
	}
yy478:
	{ fprintf(stderr, "SWITCH");           continue; }
yy479:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy505;
		default: goto yy103;
	}
yy480:
	yych = *++in.cur;
	switch (yych) {
		case 'f': goto yy506;
		default: goto yy103;
	}
yy481:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy482;
	}
yy482:
	{ fprintf(stderr, "TYPEID");           continue; }
yy483:
	yych = *++in.cur;
	switch (yych) {
		case 'm': goto yy508;
		default: goto yy103;
	}
yy484:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy509;
		default: goto yy103;
	}
yy485:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy510;
		default: goto yy103;
	}
yy486:
	yych = *++in.cur;
	switch (yych) {
		case 'l': goto yy512;
		default: goto yy103;
	}
yy487:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy513;
		default: goto yy103;
	}
yy488:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy176;
	}
yy489:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy515;
		default: goto yy103;
	}
yy490:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy516;
		default: goto yy103;
	}
yy491:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy492;
	}
yy492:
	{ fprintf(stderr, "DEFAULT");          continue; }
yy493:
	yych = *++in.cur;
	switch (yych) {
		case '_': goto yy518;
		default: goto yy103;
	}
yy494:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy519;
		default: goto yy103;
	}
yy495:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy496;
	}
yy496:
	{ fprintf(stderr, "MUTABLE");          continue; }
yy497:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy521;
		default: goto yy103;
	}
yy498:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy522;
		default: goto yy103;
	}
yy499:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy500;
	}
yy500:
	{ fprintf(stderr, "PRIVATE");          continue; }
yy501:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy524;
		default: goto yy103;
	}
yy502:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy525;
		default: goto yy103;
	}
yy503:
	yych = *++in.cur;
	switch (yych) {
		case 'p': goto yy527;
		default: goto yy103;
	}
yy504:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy528;
		default: goto yy103;
	}
yy505:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy529;
		default: goto yy103;
	}
yy506:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy507;
	}
yy507:
	{ fprintf(stderr, "TYPEDEF");          continue; }
yy508:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy531;
		default: goto yy103;
	}
yy509:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy533;
		default: goto yy103;
	}
yy510:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy511;
	}
yy511:
	{ fprintf(stderr, "VIRTUAL");          continue; }
yy512:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy535;
		default: goto yy103;
	}
yy513:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy514;
	}
yy514:
	{ fprintf(stderr, "WCHAR_T");          continue; }
yy515:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy537;
		default: goto yy103;
	}
yy516:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy517;
	}
yy517:
	{ fprintf(stderr, "CONTINUE");         continue; }
yy518:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy538;
		default: goto yy103;
	}
yy519:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy520;
	}
yy520:
	{ fprintf(stderr, "EXPLICIT");         continue; }
yy521:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy539;
		default: goto yy103;
	}
yy522:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy523;
	}
yy523:
	{ fprintf(stderr, "OPERATOR");         continue; }
yy524:
	yych = *++in.cur;
	switch (yych) {
		case 'd': goto yy541;
		default: goto yy103;
	}
yy525:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy526;
	}
yy526:
	{ fprintf(stderr, "REGISTER");         continue; }
yy527:
	yych = *++in.cur;
	switch (yych) {
		case 'r': goto yy543;
		default: goto yy103;
	}
yy528:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy544;
		default: goto yy103;
	}
yy529:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy530;
	}
yy530:
	{ fprintf(stderr, "TEMPLATE");         continue; }
yy531:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy532;
	}
yy532:
	{ fprintf(stderr, "TYPENAME");         continue; }
yy533:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy534;
	}
yy534:
	{ fprintf(stderr, "UNSIGNED");         continue; }
yy535:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy536;
	}
yy536:
	{ fprintf(stderr, "VOLATILE");         continue; }
yy537:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy545;
		default: goto yy103;
	}
yy538:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy547;
		default: goto yy103;
	}
yy539:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy540;
	}
yy540:
	{ fprintf(stderr, "NAMESPACE");        continue; }
yy541:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy542;
	}
yy542:
	{ fprintf(stderr, "PROTECTED");        continue; }
yy543:
	yych = *++in.cur;
	switch (yych) {
		case 'e': goto yy548;
		default: goto yy103;
	}
yy544:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy549;
		default: goto yy103;
	}
yy545:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy546;
	}
yy546:
	{ fprintf(stderr, "CONST_CAST");       continue; }
yy547:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy550;
		default: goto yy103;
	}
yy548:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy551;
		default: goto yy103;
	}
yy549:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy552;
		default: goto yy103;
	}
yy550:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy554;
		default: goto yy103;
	}
yy551:
	yych = *++in.cur;
	switch (yych) {
		case '_': goto yy556;
		default: goto yy103;
	}
yy552:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy553;
	}
yy553:
	{ fprintf(stderr, "STATIC_CAST");      continue; }
yy554:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy555;
	}
yy555:
	{ fprintf(stderr, "DYNAMIC_CAST");     continue; }
yy556:
	yych = *++in.cur;
	switch (yych) {
		case 'c': goto yy557;
		default: goto yy103;
	}
yy557:
	yych = *++in.cur;
	switch (yych) {
		case 'a': goto yy558;
		default: goto yy103;
	}
yy558:
	yych = *++in.cur;
	switch (yych) {
		case 's': goto yy559;
		default: goto yy103;
	}
yy559:
	yych = *++in.cur;
	switch (yych) {
		case 't': goto yy560;
		default: goto yy103;
	}
yy560:
	yych = *++in.cur;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy561;
	}
yy561:
	{ fprintf(stderr, "REINTERPRET_CAST"); continue; }
}

sfx:
        
{
	unsigned char yych;
	if ((in.lim - in.cur) < 2) if (!in.fill(2)) return false;
	yych = *in.cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy564;
		case 'U':
		case 'u': goto yy566;
		default: goto yy563;
	}
yy563:
	{ if (u > INT_MAX)  return false; fprintf(stderr, "%d",  static_cast<int>(u));      continue; }
yy564:
	yych = *++in.cur;
	switch (yych) {
		case 'U':
		case 'u': goto yy568;
		default: goto yy565;
	}
yy565:
	{ if (u > LONG_MAX) return false; fprintf(stderr, "%ld", static_cast<long>(u));     continue; }
yy566:
	yych = *++in.cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy568;
		default: goto yy567;
	}
yy567:
	{ if (u > UINT_MAX) return false; fprintf(stderr, "%u",  static_cast<unsigned>(u)); continue; }
yy568:
	++in.cur;
	{ fprintf(stderr, "%lu", u); continue; }
}

    }
}

int main()
{
    const char *fname = "example.cpp";
    FILE *f;

    // prepare input file
    f = fopen(fname, "w");
    fprintf(f,
        "#include<stdio.h>\n"
        "\n"
        "int main()\n"
        "{\n"
        "    int n;\n"
        "    printf(\"Enter the number:\\n\");\n"
        "    scanf(\"%%d\", &n);\n"
        "\n"
        "    int f = 1;\n"
        "    for(int i = 1; i <= n; ++i) {\n"
        "        f *= i;\n"
        "    }\n"
        "\n"
        "    printf(\"Factorial of %%d is %%d\\n\", n, f);\n"
        "    return 0;\n"
        "}\n"
        "\n");
    fclose(f);

    f = fopen(fname, "rb");
    input_t in(f);
    assert(lex(in));
    fclose(f);

    // cleanup
    remove(fname);
    return 0;
}
c/real_world/cxx98.re:158:14: warning: rule matches empty string [-Wmatch-empty-string]
