/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.xpcgrammar;

import com.xmlcalabash.xpcgrammar.Node;
import com.xmlcalabash.xpcgrammar.XpcParser;
import com.xmlcalabash.xpcgrammar.XpcParserTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected XpcParser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(XpcParser xpcParser, int n) {
        this(n);
        this.parser = xpcParser;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object object) {
        this.value = object;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public String toString() {
        return XpcParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }
}

