/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyDictionary$PyExposer;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyMapEntrySet;
import org.python.core.PyMapKeyValSet;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="dict", doc="dict() -> new empty dictionary.\ndict(mapping) -> new dictionary initialized from a mapping object's\n    (key, value) pairs.\ndict(seq) -> new dictionary initialized as if via:\n    d = {}\n    for k, v in seq:\n        d[k] = v\ndict(**kwargs) -> new dictionary initialized with the name=value pairs\n    in the keyword argument list.  For example:  dict(one=1, two=2)")
public class PyDictionary
extends PyObject
implements ConcurrentMap {
    public static final PyType TYPE;
    private final ConcurrentMap<PyObject, PyObject> map;

    public ConcurrentMap<PyObject, PyObject> getMap() {
        return this.map;
    }

    public PyDictionary() {
        this(TYPE);
    }

    public PyDictionary(PyType type, int capacity) {
        super(type);
        this.map = new ConcurrentHashMap<PyObject, PyObject>(capacity, 0.75f, 2);
    }

    public PyDictionary(PyType type) {
        super(type);
        this.map = Generic.concurrentMap();
    }

    public PyDictionary(Map<PyObject, PyObject> map) {
        this(TYPE, map);
    }

    public PyDictionary(PyType type, Map<PyObject, PyObject> map) {
        this(type, Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        this.map.putAll(map);
    }

    protected PyDictionary(PyType type, boolean initializeBacking) {
        super(type);
        this.map = initializeBacking ? Generic.concurrentMap() : null;
    }

    public PyDictionary(PyObject[] elements) {
        this();
        for (int i = 0; i < elements.length; i += 2) {
            this.map.put(elements[i], elements[i + 1]);
        }
    }

    @ExposedNew
    protected final void dict___init__(PyObject[] args, String[] keywords) {
        this.updateCommon(args, keywords, "dict");
    }

    public static PyObject fromkeys(PyObject keys) {
        return PyDictionary.fromkeys(keys, Py.None);
    }

    public static PyObject fromkeys(PyObject keys, PyObject value) {
        return PyDictionary.dict_fromkeys(TYPE, keys, value);
    }

    static PyObject dict_fromkeys(PyType type, PyObject keys, PyObject value) {
        PyObject d = type.__call__();
        for (PyObject o : keys.asIterable()) {
            d.__setitem__(o, value);
        }
        return d;
    }

    @Override
    public int __len__() {
        return this.dict___len__();
    }

    final int dict___len__() {
        return this.getMap().size();
    }

    @Override
    public boolean __nonzero__() {
        return this.getMap().size() != 0;
    }

    @Override
    public PyObject __finditem__(int index) {
        throw Py.TypeError("loop over non-sequence");
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        return (PyObject)this.getMap().get(key);
    }

    protected final PyObject dict___getitem__(PyObject key) {
        PyObject missing;
        PyObject result = (PyObject)this.getMap().get(key);
        if (result != null) {
            return result;
        }
        PyType type = this.getType();
        if (type != TYPE && (missing = type.lookup("__missing__")) != null) {
            return missing.__get__(this, type).__call__(key);
        }
        throw Py.KeyError(key);
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        this.dict___setitem__(key, value);
    }

    final void dict___setitem__(PyObject key, PyObject value) {
        this.getMap().put(key, value);
    }

    @Override
    public void __delitem__(PyObject key) {
        this.dict___delitem__(key);
    }

    final void dict___delitem__(PyObject key) {
        Object ret = this.getMap().remove(key);
        if (ret == null) {
            throw Py.KeyError(key.toString());
        }
    }

    @Override
    public PyObject __iter__() {
        return this.dict___iter__();
    }

    final PyObject dict___iter__() {
        return this.iterkeys();
    }

    @Override
    public String toString() {
        return this.dict_toString();
    }

    final String dict_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuilder buf = new StringBuilder("{");
        for (Map.Entry entry : this.getMap().entrySet()) {
            buf.append(((PyObject)entry.getKey()).__repr__().toString());
            buf.append(": ");
            buf.append(((PyObject)entry.getValue()).__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public PyObject __eq__(PyObject otherObj) {
        return this.dict___eq__(otherObj);
    }

    final PyObject dict___eq__(PyObject otherObj) {
        int bn;
        PyType thisType = this.getType();
        PyType otherType = otherObj.getType();
        if (otherType != thisType && !thisType.isSubType(otherType) && !otherType.isSubType(thisType)) {
            return null;
        }
        PyDictionary other = (PyDictionary)otherObj;
        int an = this.getMap().size();
        if (an != (bn = other.getMap().size())) {
            return Py.False;
        }
        PyList akeys = this.keys();
        for (int i = 0; i < an; ++i) {
            PyObject akey = akeys.pyget(i);
            PyObject bvalue = other.__finditem__(akey);
            if (bvalue == null) {
                return Py.False;
            }
            PyObject avalue = this.__finditem__(akey);
            if (avalue._eq(bvalue).__nonzero__()) continue;
            return Py.False;
        }
        return Py.True;
    }

    @Override
    public PyObject __ne__(PyObject otherObj) {
        return this.dict___ne__(otherObj);
    }

    final PyObject dict___ne__(PyObject otherObj) {
        PyObject eq_result = this.__eq__(otherObj);
        if (eq_result == null) {
            return null;
        }
        return eq_result.__not__();
    }

    final PyObject dict___lt__(PyObject otherObj) {
        int result = this.__cmp__(otherObj);
        if (result == -2) {
            return null;
        }
        return result < 0 ? Py.True : Py.False;
    }

    final PyObject dict___gt__(PyObject otherObj) {
        int result = this.__cmp__(otherObj);
        if (result == -2) {
            return null;
        }
        return result > 0 ? Py.True : Py.False;
    }

    final PyObject dict___le__(PyObject otherObj) {
        int result = this.__cmp__(otherObj);
        if (result == -2) {
            return null;
        }
        return result <= 0 ? Py.True : Py.False;
    }

    final PyObject dict___ge__(PyObject otherObj) {
        int result = this.__cmp__(otherObj);
        if (result == -2) {
            return null;
        }
        return result >= 0 ? Py.True : Py.False;
    }

    @Override
    public int __cmp__(PyObject otherObj) {
        return this.dict___cmp__(otherObj);
    }

    final int dict___cmp__(PyObject otherObj) {
        int bn;
        PyType thisType = this.getType();
        PyType otherType = otherObj.getType();
        if (otherType != thisType && !thisType.isSubType(otherType) && !otherType.isSubType(thisType)) {
            return -2;
        }
        PyDictionary other = (PyDictionary)otherObj;
        int an = this.getMap().size();
        if (an < (bn = other.getMap().size())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = other.keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bkey;
            PyObject akey = akeys.pyget(i);
            int c = akey._cmp(bkey = bkeys.pyget(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            PyObject bvalue = other.__finditem__(bkey);
            if (avalue == null) {
                if (bvalue == null) continue;
                return -3;
            }
            if (bvalue == null) {
                return -3;
            }
            c = avalue._cmp(bvalue);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean has_key(PyObject key) {
        return this.dict_has_key(key);
    }

    final boolean dict_has_key(PyObject key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.dict___contains__(o);
    }

    final boolean dict___contains__(PyObject o) {
        return this.dict_has_key(o);
    }

    public PyObject get(PyObject key, PyObject defaultObj) {
        return this.dict_get(key, defaultObj);
    }

    final PyObject dict_get(PyObject key, PyObject defaultObj) {
        PyObject o = (PyObject)this.getMap().get(key);
        return o == null ? defaultObj : o;
    }

    public PyObject get(PyObject key) {
        return this.dict_get(key, Py.None);
    }

    public PyDictionary copy() {
        return this.dict_copy();
    }

    final PyDictionary dict_copy() {
        return new PyDictionary(this.getMap());
    }

    @Override
    public void clear() {
        this.dict_clear();
    }

    final void dict_clear() {
        this.getMap().clear();
    }

    public void update(PyObject other) {
        this.dict_update(new PyObject[]{other}, Py.NoKeywords);
    }

    final void dict_update(PyObject[] args, String[] keywords) {
        this.updateCommon(args, keywords, "update");
    }

    private void updateCommon(PyObject[] args, String[] keywords, String methName) {
        int nargs = args.length - keywords.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, methName, 0, 1);
        }
        if (nargs == 1) {
            PyObject arg = args[0];
            Object proxy = arg.getJavaProxy();
            if (proxy instanceof Map) {
                this.merge((Map)proxy);
            } else if (arg.__findattr__("keys") != null) {
                this.merge(arg);
            } else {
                this.mergeFromSeq(arg);
            }
        }
        for (int i = 0; i < keywords.length; ++i) {
            this.dict___setitem__(Py.newString(keywords[i]), args[nargs + i]);
        }
    }

    private void merge(Map<Object, Object> other) {
        for (Map.Entry<Object, Object> entry : other.entrySet()) {
            this.dict___setitem__(Py.java2py(entry.getKey()), Py.java2py(entry.getValue()));
        }
    }

    private void merge(PyObject other) {
        if (other instanceof PyDictionary) {
            this.getMap().putAll(((PyDictionary)other).getMap());
        } else if (other instanceof PyStringMap) {
            this.mergeFromKeys(other, ((PyStringMap)other).keys());
        } else {
            this.mergeFromKeys(other, other.invoke("keys"));
        }
    }

    private void mergeFromKeys(PyObject other, PyObject keys) {
        for (PyObject key : keys.asIterable()) {
            this.dict___setitem__(key, other.__getitem__(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeFromSeq(PyObject other) {
        PyObject i;
        PyObject pairs = other.__iter__();
        boolean bl = false;
        while ((i = pairs.__iternext__()) != null) {
            void pair;
            try {
                i = PySequence.fastSequence(i, "");
            }
            catch (PyException pye) {
                if (pye.match(Py.TypeError)) {
                    throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", (int)pair));
                }
                throw pye;
            }
            int n = i.__len__();
            if (n != 2) {
                throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", (int)pair, n));
            }
            this.dict___setitem__(i.__getitem__(0), i.__getitem__(1));
            ++pair;
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.dict_setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        return this.dict_setdefault(key, failobj);
    }

    final PyObject dict_setdefault(PyObject key, PyObject failobj) {
        PyObject oldValue = this.getMap().putIfAbsent(key, failobj);
        return oldValue == null ? failobj : oldValue;
    }

    final PyObject dict_setifabsent(PyObject key, PyObject failobj) {
        PyObject oldValue = this.getMap().putIfAbsent(key, failobj);
        return oldValue == null ? Py.None : oldValue;
    }

    public PyObject pop(PyObject key) {
        return this.dict_pop(key, null);
    }

    public PyObject pop(PyObject key, PyObject defaultValue) {
        return this.dict_pop(key, defaultValue);
    }

    final PyObject dict_pop(PyObject key, PyObject defaultValue) {
        if (!this.map.containsKey(key)) {
            if (defaultValue == null) {
                throw Py.KeyError("popitem(): dictionary is empty");
            }
            return defaultValue;
        }
        return (PyObject)this.getMap().remove(key);
    }

    public PyObject popitem() {
        return this.dict_popitem();
    }

    final PyObject dict_popitem() {
        Iterator it = this.getMap().entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        Map.Entry entry = it.next();
        PyTuple tuple = new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue());
        it.remove();
        return tuple;
    }

    public PyList items() {
        return this.dict_items();
    }

    final PyList dict_items() {
        ArrayList<PyObject> list = new ArrayList<PyObject>(this.getMap().size());
        for (Map.Entry entry : this.getMap().entrySet()) {
            list.add(new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue()));
        }
        return PyList.fromList(list);
    }

    public PyList keys() {
        return this.dict_keys();
    }

    final PyList dict_keys() {
        return PyList.fromList(new ArrayList<PyObject>(this.getMap().keySet()));
    }

    final PyList dict_values() {
        return PyList.fromList(new ArrayList<PyObject>(this.getMap().values()));
    }

    public PyObject iteritems() {
        return this.dict_iteritems();
    }

    final PyObject dict_iteritems() {
        return new ItemsIter(this.getMap().entrySet());
    }

    public PyObject iterkeys() {
        return this.dict_iterkeys();
    }

    final PyObject dict_iterkeys() {
        return new ValuesIter(this.getMap().keySet());
    }

    public PyObject itervalues() {
        return this.dict_itervalues();
    }

    final PyObject dict_itervalues() {
        return new ValuesIter(this.getMap().values());
    }

    @Override
    public int hashCode() {
        return this.dict___hash__();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PyDictionary other = (PyDictionary)obj;
        return this.map == other.map || this.map != null && this.map.equals(other.map);
    }

    final int dict___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public boolean isMappingType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    public Set entrySet() {
        return new PyMapEntrySet(this.getMap().entrySet());
    }

    @Override
    public Set keySet() {
        return new PyMapKeyValSet(this.getMap().keySet());
    }

    @Override
    public Collection values() {
        return new PyMapKeyValSet(this.getMap().values());
    }

    @Override
    public void putAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            this.getMap().put(Py.java2py(entry.getKey()), Py.java2py(entry.getValue()));
        }
    }

    @Override
    public Object remove(Object key) {
        return PyDictionary.tojava(this.getMap().remove(Py.java2py(key)));
    }

    @Override
    public Object put(Object key, Object value) {
        return PyDictionary.tojava(this.getMap().put(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public Object get(Object key) {
        return PyDictionary.tojava(this.getMap().get(Py.java2py(key)));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(Py.java2py(value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(Py.java2py(key));
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    static Object tojava(Object val) {
        return val == null ? null : ((PyObject)val).__tojava__(Object.class);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return PyDictionary.tojava(this.getMap().putIfAbsent(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.getMap().remove(Py.java2py(key), Py.java2py(value));
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.getMap().replace(Py.java2py(key), Py.java2py(oldValue), Py.java2py(newValue));
    }

    @Override
    public Object replace(Object key, Object value) {
        return PyDictionary.tojava(this.getMap().replace(Py.java2py(key), Py.java2py(value)));
    }

    static {
        PyType.addBuilder(PyDictionary.class, new PyDictionary$PyExposer());
        TYPE = PyType.fromClass(PyDictionary.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemsIter
    extends PyIterator {
        private final Iterator<Map.Entry<PyObject, PyObject>> iterator;
        private final int size;

        public ItemsIter(Set<Map.Entry<PyObject, PyObject>> items) {
            this.iterator = items.iterator();
            this.size = items.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyDictionary.this.getMap().size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            Map.Entry<PyObject, PyObject> entry = this.iterator.next();
            return new PyTuple(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuesIter
    extends PyIterator {
        private final Iterator<PyObject> iterator;
        private final int size;

        public ValuesIter(Collection<PyObject> values) {
            this.iterator = values.iterator();
            this.size = values.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyDictionary.this.getMap().size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }
    }
}

