// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#![allow(rustdoc::redundant_explicit_links)]
#![allow(rustdoc::broken_intra_doc_links)]
#![no_implicit_prelude]
extern crate bytes;
extern crate serde;
extern crate serde_json;
extern crate serde_with;
extern crate std;
extern crate wkt;

mod debug;
mod deserialize;
mod serialize;

/// Describes the cause of the error with structured details.
///
/// Example of an error when contacting the "pubsub.googleapis.com" API when it
/// is not enabled:
///
/// ```norust
/// { "reason": "API_DISABLED"
///   "domain": "googleapis.com"
///   "metadata": {
///     "resource": "projects/123",
///     "service": "pubsub.googleapis.com"
///   }
/// }
/// ```
///
/// This response indicates that the pubsub.googleapis.com API is not enabled.
///
/// Example of an error that is returned when attempting to create a Spanner
/// instance in a region that is out of stock:
///
/// ```norust
/// { "reason": "STOCKOUT"
///   "domain": "spanner.googleapis.com",
///   "metadata": {
///     "availableRegions": "us-central1,us-east2"
///   }
/// }
/// ```
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct ErrorInfo {
    /// The reason of the error. This is a constant value that identifies the
    /// proximate cause of the error. Error reasons are unique within a particular
    /// domain of errors. This should be at most 63 characters and match a
    /// regular expression of `[A-Z][A-Z0-9_]+[A-Z0-9]`, which represents
    /// UPPER_SNAKE_CASE.
    pub reason: std::string::String,

    /// The logical grouping to which the "reason" belongs. The error domain
    /// is typically the registered service name of the tool or product that
    /// generates the error. Example: "pubsub.googleapis.com". If the error is
    /// generated by some common infrastructure, the error domain must be a
    /// globally unique value that identifies the infrastructure. For Google API
    /// infrastructure, the error domain is "googleapis.com".
    pub domain: std::string::String,

    /// Additional structured details about this error.
    ///
    /// Keys must match a regular expression of `[a-z][a-zA-Z0-9-_]+` but should
    /// ideally be lowerCamelCase. Also, they must be limited to 64 characters in
    /// length. When identifying the current value of an exceeded limit, the units
    /// should be contained in the key, not the value.  For example, rather than
    /// `{"instanceLimit": "100/request"}`, should be returned as,
    /// `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of
    /// instances that can be created in a single (batch) request.
    pub metadata: std::collections::HashMap<std::string::String, std::string::String>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl ErrorInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [reason][crate::model::ErrorInfo::reason].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ErrorInfo;
    /// let x = ErrorInfo::new().set_reason("example");
    /// ```
    pub fn set_reason<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.reason = v.into();
        self
    }

    /// Sets the value of [domain][crate::model::ErrorInfo::domain].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ErrorInfo;
    /// let x = ErrorInfo::new().set_domain("example");
    /// ```
    pub fn set_domain<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.domain = v.into();
        self
    }

    /// Sets the value of [metadata][crate::model::ErrorInfo::metadata].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ErrorInfo;
    /// let x = ErrorInfo::new().set_metadata([
    ///     ("key0", "abc"),
    ///     ("key1", "xyz"),
    /// ]);
    /// ```
    pub fn set_metadata<T, K, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = (K, V)>,
        K: std::convert::Into<std::string::String>,
        V: std::convert::Into<std::string::String>,
    {
        use std::iter::Iterator;
        self.metadata = v.into_iter().map(|(k, v)| (k.into(), v.into())).collect();
        self
    }
}

impl wkt::message::Message for ErrorInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.ErrorInfo"
    }
}

/// Describes when the clients can retry a failed request. Clients could ignore
/// the recommendation here or retry when this information is missing from error
/// responses.
///
/// It's always recommended that clients should use exponential backoff when
/// retrying.
///
/// Clients should wait until `retry_delay` amount of time has passed since
/// receiving the error response before retrying.  If retrying requests also
/// fail, clients should use an exponential backoff scheme to gradually increase
/// the delay between retries based on `retry_delay`, until either a maximum
/// number of retries have been reached or a maximum retry delay cap has been
/// reached.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct RetryInfo {
    /// Clients should wait at least this long between retrying the same request.
    pub retry_delay: std::option::Option<wkt::Duration>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl RetryInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [retry_delay][crate::model::RetryInfo::retry_delay].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::RetryInfo;
    /// use wkt::Duration;
    /// let x = RetryInfo::new().set_retry_delay(Duration::default()/* use setters */);
    /// ```
    pub fn set_retry_delay<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<wkt::Duration>,
    {
        self.retry_delay = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [retry_delay][crate::model::RetryInfo::retry_delay].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::RetryInfo;
    /// use wkt::Duration;
    /// let x = RetryInfo::new().set_or_clear_retry_delay(Some(Duration::default()/* use setters */));
    /// let x = RetryInfo::new().set_or_clear_retry_delay(None::<Duration>);
    /// ```
    pub fn set_or_clear_retry_delay<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<wkt::Duration>,
    {
        self.retry_delay = v.map(|x| x.into());
        self
    }
}

impl wkt::message::Message for RetryInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.RetryInfo"
    }
}

/// Describes additional debugging info.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct DebugInfo {
    /// The stack trace entries indicating where the error occurred.
    pub stack_entries: std::vec::Vec<std::string::String>,

    /// Additional debugging information provided by the server.
    pub detail: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl DebugInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [stack_entries][crate::model::DebugInfo::stack_entries].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::DebugInfo;
    /// let x = DebugInfo::new().set_stack_entries(["a", "b", "c"]);
    /// ```
    pub fn set_stack_entries<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<std::string::String>,
    {
        use std::iter::Iterator;
        self.stack_entries = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [detail][crate::model::DebugInfo::detail].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::DebugInfo;
    /// let x = DebugInfo::new().set_detail("example");
    /// ```
    pub fn set_detail<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.detail = v.into();
        self
    }
}

impl wkt::message::Message for DebugInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.DebugInfo"
    }
}

/// Describes how a quota check failed.
///
/// For example if a daily limit was exceeded for the calling project,
/// a service could respond with a QuotaFailure detail containing the project
/// id and the description of the quota limit that was exceeded.  If the
/// calling project hasn't enabled the service in the developer console, then
/// a service could respond with the project id and set `service_disabled`
/// to true.
///
/// Also see RetryInfo and Help types for other details about handling a
/// quota failure.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct QuotaFailure {
    /// Describes all quota violations.
    pub violations: std::vec::Vec<crate::model::quota_failure::Violation>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl QuotaFailure {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [violations][crate::model::QuotaFailure::violations].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::QuotaFailure;
    /// use google_cloud_rpc::model::quota_failure::Violation;
    /// let x = QuotaFailure::new()
    ///     .set_violations([
    ///         Violation::default()/* use setters */,
    ///         Violation::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_violations<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::model::quota_failure::Violation>,
    {
        use std::iter::Iterator;
        self.violations = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for QuotaFailure {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.QuotaFailure"
    }
}

/// Defines additional types related to [QuotaFailure].
pub mod quota_failure {
    #[allow(unused_imports)]
    use super::*;

    /// A message type used to describe a single quota violation.  For example, a
    /// daily quota or a custom quota that was exceeded.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct Violation {
        /// The subject on which the quota check failed.
        /// For example, "clientip:\<ip address of client\>" or "project:\<Google
        /// developer project id\>".
        pub subject: std::string::String,

        /// A description of how the quota check failed. Clients can use this
        /// description to find more about the quota configuration in the service's
        /// public documentation, or find the relevant quota limit to adjust through
        /// developer console.
        ///
        /// For example: "Service disabled" or "Daily Limit for read operations
        /// exceeded".
        pub description: std::string::String,

        /// The API Service from which the `QuotaFailure.Violation` orginates. In
        /// some cases, Quota issues originate from an API Service other than the one
        /// that was called. In other words, a dependency of the called API Service
        /// could be the cause of the `QuotaFailure`, and this field would have the
        /// dependency API service name.
        ///
        /// For example, if the called API is Kubernetes Engine API
        /// (container.googleapis.com), and a quota violation occurs in the
        /// Kubernetes Engine API itself, this field would be
        /// "container.googleapis.com". On the other hand, if the quota violation
        /// occurs when the Kubernetes Engine API creates VMs in the Compute Engine
        /// API (compute.googleapis.com), this field would be
        /// "compute.googleapis.com".
        pub api_service: std::string::String,

        /// The metric of the violated quota. A quota metric is a named counter to
        /// measure usage, such as API requests or CPUs. When an activity occurs in a
        /// service, such as Virtual Machine allocation, one or more quota metrics
        /// may be affected.
        ///
        /// For example, "compute.googleapis.com/cpus_per_vm_family",
        /// "storage.googleapis.com/internet_egress_bandwidth".
        pub quota_metric: std::string::String,

        /// The id of the violated quota. Also know as "limit name", this is the
        /// unique identifier of a quota in the context of an API service.
        ///
        /// For example, "CPUS-PER-VM-FAMILY-per-project-region".
        pub quota_id: std::string::String,

        /// The dimensions of the violated quota. Every non-global quota is enforced
        /// on a set of dimensions. While quota metric defines what to count, the
        /// dimensions specify for what aspects the counter should be increased.
        ///
        /// For example, the quota "CPUs per region per VM family" enforces a limit
        /// on the metric "compute.googleapis.com/cpus_per_vm_family" on dimensions
        /// "region" and "vm_family". And if the violation occurred in region
        /// "us-central1" and for VM family "n1", the quota_dimensions would be,
        ///
        /// {
        /// "region": "us-central1",
        /// "vm_family": "n1",
        /// }
        ///
        /// When a quota is enforced globally, the quota_dimensions would always be
        /// empty.
        pub quota_dimensions: std::collections::HashMap<std::string::String, std::string::String>,

        /// The enforced quota value at the time of the `QuotaFailure`.
        ///
        /// For example, if the enforced quota value at the time of the
        /// `QuotaFailure` on the number of CPUs is "10", then the value of this
        /// field would reflect this quantity.
        pub quota_value: i64,

        /// The new quota value being rolled out at the time of the violation. At the
        /// completion of the rollout, this value will be enforced in place of
        /// quota_value. If no rollout is in progress at the time of the violation,
        /// this field is not set.
        ///
        /// For example, if at the time of the violation a rollout is in progress
        /// changing the number of CPUs quota from 10 to 20, 20 would be the value of
        /// this field.
        pub future_quota_value: std::option::Option<i64>,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl Violation {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [subject][crate::model::quota_failure::Violation::subject].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_subject("example");
        /// ```
        pub fn set_subject<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.subject = v.into();
            self
        }

        /// Sets the value of [description][crate::model::quota_failure::Violation::description].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_description("example");
        /// ```
        pub fn set_description<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.description = v.into();
            self
        }

        /// Sets the value of [api_service][crate::model::quota_failure::Violation::api_service].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_api_service("example");
        /// ```
        pub fn set_api_service<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.api_service = v.into();
            self
        }

        /// Sets the value of [quota_metric][crate::model::quota_failure::Violation::quota_metric].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_quota_metric("example");
        /// ```
        pub fn set_quota_metric<T: std::convert::Into<std::string::String>>(
            mut self,
            v: T,
        ) -> Self {
            self.quota_metric = v.into();
            self
        }

        /// Sets the value of [quota_id][crate::model::quota_failure::Violation::quota_id].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_quota_id("example");
        /// ```
        pub fn set_quota_id<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.quota_id = v.into();
            self
        }

        /// Sets the value of [quota_dimensions][crate::model::quota_failure::Violation::quota_dimensions].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_quota_dimensions([
        ///     ("key0", "abc"),
        ///     ("key1", "xyz"),
        /// ]);
        /// ```
        pub fn set_quota_dimensions<T, K, V>(mut self, v: T) -> Self
        where
            T: std::iter::IntoIterator<Item = (K, V)>,
            K: std::convert::Into<std::string::String>,
            V: std::convert::Into<std::string::String>,
        {
            use std::iter::Iterator;
            self.quota_dimensions = v.into_iter().map(|(k, v)| (k.into(), v.into())).collect();
            self
        }

        /// Sets the value of [quota_value][crate::model::quota_failure::Violation::quota_value].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_quota_value(42);
        /// ```
        pub fn set_quota_value<T: std::convert::Into<i64>>(mut self, v: T) -> Self {
            self.quota_value = v.into();
            self
        }

        /// Sets the value of [future_quota_value][crate::model::quota_failure::Violation::future_quota_value].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_future_quota_value(42);
        /// ```
        pub fn set_future_quota_value<T>(mut self, v: T) -> Self
        where
            T: std::convert::Into<i64>,
        {
            self.future_quota_value = std::option::Option::Some(v.into());
            self
        }

        /// Sets or clears the value of [future_quota_value][crate::model::quota_failure::Violation::future_quota_value].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::quota_failure::Violation;
        /// let x = Violation::new().set_or_clear_future_quota_value(Some(42));
        /// let x = Violation::new().set_or_clear_future_quota_value(None::<i32>);
        /// ```
        pub fn set_or_clear_future_quota_value<T>(mut self, v: std::option::Option<T>) -> Self
        where
            T: std::convert::Into<i64>,
        {
            self.future_quota_value = v.map(|x| x.into());
            self
        }
    }

    impl wkt::message::Message for Violation {
        fn typename() -> &'static str {
            "type.googleapis.com/google.rpc.QuotaFailure.Violation"
        }
    }
}

/// Describes what preconditions have failed.
///
/// For example, if an RPC failed because it required the Terms of Service to be
/// acknowledged, it could list the terms of service violation in the
/// PreconditionFailure message.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct PreconditionFailure {
    /// Describes all precondition violations.
    pub violations: std::vec::Vec<crate::model::precondition_failure::Violation>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl PreconditionFailure {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [violations][crate::model::PreconditionFailure::violations].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::PreconditionFailure;
    /// use google_cloud_rpc::model::precondition_failure::Violation;
    /// let x = PreconditionFailure::new()
    ///     .set_violations([
    ///         Violation::default()/* use setters */,
    ///         Violation::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_violations<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::model::precondition_failure::Violation>,
    {
        use std::iter::Iterator;
        self.violations = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for PreconditionFailure {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.PreconditionFailure"
    }
}

/// Defines additional types related to [PreconditionFailure].
pub mod precondition_failure {
    #[allow(unused_imports)]
    use super::*;

    /// A message type used to describe a single precondition failure.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct Violation {
        /// The type of PreconditionFailure. We recommend using a service-specific
        /// enum type to define the supported precondition violation subjects. For
        /// example, "TOS" for "Terms of Service violation".
        pub r#type: std::string::String,

        /// The subject, relative to the type, that failed.
        /// For example, "google.com/cloud" relative to the "TOS" type would indicate
        /// which terms of service is being referenced.
        pub subject: std::string::String,

        /// A description of how the precondition failed. Developers can use this
        /// description to understand how to fix the failure.
        ///
        /// For example: "Terms of service not accepted".
        pub description: std::string::String,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl Violation {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [r#type][crate::model::precondition_failure::Violation::type].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::precondition_failure::Violation;
        /// let x = Violation::new().set_type("example");
        /// ```
        pub fn set_type<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.r#type = v.into();
            self
        }

        /// Sets the value of [subject][crate::model::precondition_failure::Violation::subject].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::precondition_failure::Violation;
        /// let x = Violation::new().set_subject("example");
        /// ```
        pub fn set_subject<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.subject = v.into();
            self
        }

        /// Sets the value of [description][crate::model::precondition_failure::Violation::description].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::precondition_failure::Violation;
        /// let x = Violation::new().set_description("example");
        /// ```
        pub fn set_description<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.description = v.into();
            self
        }
    }

    impl wkt::message::Message for Violation {
        fn typename() -> &'static str {
            "type.googleapis.com/google.rpc.PreconditionFailure.Violation"
        }
    }
}

/// Describes violations in a client request. This error type focuses on the
/// syntactic aspects of the request.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct BadRequest {
    /// Describes all violations in a client request.
    pub field_violations: std::vec::Vec<crate::model::bad_request::FieldViolation>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl BadRequest {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [field_violations][crate::model::BadRequest::field_violations].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::BadRequest;
    /// use google_cloud_rpc::model::bad_request::FieldViolation;
    /// let x = BadRequest::new()
    ///     .set_field_violations([
    ///         FieldViolation::default()/* use setters */,
    ///         FieldViolation::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_field_violations<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::model::bad_request::FieldViolation>,
    {
        use std::iter::Iterator;
        self.field_violations = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for BadRequest {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.BadRequest"
    }
}

/// Defines additional types related to [BadRequest].
pub mod bad_request {
    #[allow(unused_imports)]
    use super::*;

    /// A message type used to describe a single bad request field.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct FieldViolation {
        /// A path that leads to a field in the request body. The value will be a
        /// sequence of dot-separated identifiers that identify a protocol buffer
        /// field.
        ///
        /// Consider the following:
        ///
        /// ```norust
        /// message CreateContactRequest {
        ///   message EmailAddress {
        ///     enum Type {
        ///       TYPE_UNSPECIFIED = 0;
        ///       HOME = 1;
        ///       WORK = 2;
        ///     }
        ///
        ///     optional string email = 1;
        ///     repeated EmailType type = 2;
        ///   }
        ///
        ///   string full_name = 1;
        ///   repeated EmailAddress email_addresses = 2;
        /// }
        /// ```
        ///
        /// In this example, in proto `field` could take one of the following values:
        ///
        /// * `full_name` for a violation in the `full_name` value
        /// * `email_addresses[1].email` for a violation in the `email` field of the
        ///   first `email_addresses` message
        /// * `email_addresses[3].type[2]` for a violation in the second `type`
        ///   value in the third `email_addresses` message.
        ///
        /// In JSON, the same values are represented as:
        ///
        /// * `fullName` for a violation in the `fullName` value
        /// * `emailAddresses[1].email` for a violation in the `email` field of the
        ///   first `emailAddresses` message
        /// * `emailAddresses[3].type[2]` for a violation in the second `type`
        ///   value in the third `emailAddresses` message.
        pub field: std::string::String,

        /// A description of why the request element is bad.
        pub description: std::string::String,

        /// The reason of the field-level error. This is a constant value that
        /// identifies the proximate cause of the field-level error. It should
        /// uniquely identify the type of the FieldViolation within the scope of the
        /// google.rpc.ErrorInfo.domain. This should be at most 63
        /// characters and match a regular expression of `[A-Z][A-Z0-9_]+[A-Z0-9]`,
        /// which represents UPPER_SNAKE_CASE.
        pub reason: std::string::String,

        /// Provides a localized error message for field-level errors that is safe to
        /// return to the API consumer.
        pub localized_message: std::option::Option<crate::model::LocalizedMessage>,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl FieldViolation {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [field][crate::model::bad_request::FieldViolation::field].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::bad_request::FieldViolation;
        /// let x = FieldViolation::new().set_field("example");
        /// ```
        pub fn set_field<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.field = v.into();
            self
        }

        /// Sets the value of [description][crate::model::bad_request::FieldViolation::description].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::bad_request::FieldViolation;
        /// let x = FieldViolation::new().set_description("example");
        /// ```
        pub fn set_description<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.description = v.into();
            self
        }

        /// Sets the value of [reason][crate::model::bad_request::FieldViolation::reason].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::bad_request::FieldViolation;
        /// let x = FieldViolation::new().set_reason("example");
        /// ```
        pub fn set_reason<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.reason = v.into();
            self
        }

        /// Sets the value of [localized_message][crate::model::bad_request::FieldViolation::localized_message].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::bad_request::FieldViolation;
        /// use google_cloud_rpc::model::LocalizedMessage;
        /// let x = FieldViolation::new().set_localized_message(LocalizedMessage::default()/* use setters */);
        /// ```
        pub fn set_localized_message<T>(mut self, v: T) -> Self
        where
            T: std::convert::Into<crate::model::LocalizedMessage>,
        {
            self.localized_message = std::option::Option::Some(v.into());
            self
        }

        /// Sets or clears the value of [localized_message][crate::model::bad_request::FieldViolation::localized_message].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::bad_request::FieldViolation;
        /// use google_cloud_rpc::model::LocalizedMessage;
        /// let x = FieldViolation::new().set_or_clear_localized_message(Some(LocalizedMessage::default()/* use setters */));
        /// let x = FieldViolation::new().set_or_clear_localized_message(None::<LocalizedMessage>);
        /// ```
        pub fn set_or_clear_localized_message<T>(mut self, v: std::option::Option<T>) -> Self
        where
            T: std::convert::Into<crate::model::LocalizedMessage>,
        {
            self.localized_message = v.map(|x| x.into());
            self
        }
    }

    impl wkt::message::Message for FieldViolation {
        fn typename() -> &'static str {
            "type.googleapis.com/google.rpc.BadRequest.FieldViolation"
        }
    }
}

/// Contains metadata about the request that clients can attach when filing a bug
/// or providing other forms of feedback.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct RequestInfo {
    /// An opaque string that should only be interpreted by the service generating
    /// it. For example, it can be used to identify requests in the service's logs.
    pub request_id: std::string::String,

    /// Any data that was used to serve this request. For example, an encrypted
    /// stack trace that can be sent back to the service provider for debugging.
    pub serving_data: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl RequestInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [request_id][crate::model::RequestInfo::request_id].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::RequestInfo;
    /// let x = RequestInfo::new().set_request_id("example");
    /// ```
    pub fn set_request_id<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.request_id = v.into();
        self
    }

    /// Sets the value of [serving_data][crate::model::RequestInfo::serving_data].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::RequestInfo;
    /// let x = RequestInfo::new().set_serving_data("example");
    /// ```
    pub fn set_serving_data<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.serving_data = v.into();
        self
    }
}

impl wkt::message::Message for RequestInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.RequestInfo"
    }
}

/// Describes the resource that is being accessed.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct ResourceInfo {
    /// A name for the type of resource being accessed, e.g. "sql table",
    /// "cloud storage bucket", "file", "Google calendar"; or the type URL
    /// of the resource: e.g. "type.googleapis.com/google.pubsub.v1.Topic".
    pub resource_type: std::string::String,

    /// The name of the resource being accessed.  For example, a shared calendar
    /// name: "example.com_4fghdhgsrgh@group.calendar.google.com", if the current
    /// error is
    /// [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED].
    ///
    /// [google.rpc.Code.PERMISSION_DENIED]: crate::model::Code::PermissionDenied
    pub resource_name: std::string::String,

    /// The owner of the resource (optional).
    /// For example, "user:\<owner email\>" or "project:\<Google developer project
    /// id\>".
    pub owner: std::string::String,

    /// Describes what error is encountered when accessing this resource.
    /// For example, updating a cloud project may require the `writer` permission
    /// on the developer console project.
    pub description: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl ResourceInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [resource_type][crate::model::ResourceInfo::resource_type].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ResourceInfo;
    /// let x = ResourceInfo::new().set_resource_type("example");
    /// ```
    pub fn set_resource_type<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.resource_type = v.into();
        self
    }

    /// Sets the value of [resource_name][crate::model::ResourceInfo::resource_name].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ResourceInfo;
    /// let x = ResourceInfo::new().set_resource_name("example");
    /// ```
    pub fn set_resource_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.resource_name = v.into();
        self
    }

    /// Sets the value of [owner][crate::model::ResourceInfo::owner].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ResourceInfo;
    /// let x = ResourceInfo::new().set_owner("example");
    /// ```
    pub fn set_owner<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.owner = v.into();
        self
    }

    /// Sets the value of [description][crate::model::ResourceInfo::description].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::ResourceInfo;
    /// let x = ResourceInfo::new().set_description("example");
    /// ```
    pub fn set_description<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.description = v.into();
        self
    }
}

impl wkt::message::Message for ResourceInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.ResourceInfo"
    }
}

/// Provides links to documentation or for performing an out of band action.
///
/// For example, if a quota check failed with an error indicating the calling
/// project hasn't enabled the accessed service, this can contain a URL pointing
/// directly to the right place in the developer console to flip the bit.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Help {
    /// URL(s) pointing to additional information on handling the current error.
    pub links: std::vec::Vec<crate::model::help::Link>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Help {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [links][crate::model::Help::links].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::Help;
    /// use google_cloud_rpc::model::help::Link;
    /// let x = Help::new()
    ///     .set_links([
    ///         Link::default()/* use setters */,
    ///         Link::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_links<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::model::help::Link>,
    {
        use std::iter::Iterator;
        self.links = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for Help {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.Help"
    }
}

/// Defines additional types related to [Help].
pub mod help {
    #[allow(unused_imports)]
    use super::*;

    /// Describes a URL link.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct Link {
        /// Describes what the link offers.
        pub description: std::string::String,

        /// The URL of the link.
        pub url: std::string::String,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl Link {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [description][crate::model::help::Link::description].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::help::Link;
        /// let x = Link::new().set_description("example");
        /// ```
        pub fn set_description<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.description = v.into();
            self
        }

        /// Sets the value of [url][crate::model::help::Link::url].
        ///
        /// # Example
        /// ```ignore,no_run
        /// # use google_cloud_rpc::model::help::Link;
        /// let x = Link::new().set_url("example");
        /// ```
        pub fn set_url<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.url = v.into();
            self
        }
    }

    impl wkt::message::Message for Link {
        fn typename() -> &'static str {
            "type.googleapis.com/google.rpc.Help.Link"
        }
    }
}

/// Provides a localized error message that is safe to return to the user
/// which can be attached to an RPC error.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct LocalizedMessage {
    /// The locale used following the specification defined at
    /// <https://www.rfc-editor.org/rfc/bcp/bcp47.txt>.
    /// Examples are: "en-US", "fr-CH", "es-MX"
    pub locale: std::string::String,

    /// The localized error message in the above locale.
    pub message: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl LocalizedMessage {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [locale][crate::model::LocalizedMessage::locale].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::LocalizedMessage;
    /// let x = LocalizedMessage::new().set_locale("example");
    /// ```
    pub fn set_locale<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.locale = v.into();
        self
    }

    /// Sets the value of [message][crate::model::LocalizedMessage::message].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::LocalizedMessage;
    /// let x = LocalizedMessage::new().set_message("example");
    /// ```
    pub fn set_message<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.message = v.into();
        self
    }
}

impl wkt::message::Message for LocalizedMessage {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.LocalizedMessage"
    }
}

/// Represents an HTTP request.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct HttpRequest {
    /// The HTTP request method.
    pub method: std::string::String,

    /// The HTTP request URI.
    pub uri: std::string::String,

    /// The HTTP request headers. The ordering of the headers is significant.
    /// Multiple headers with the same key may present for the request.
    pub headers: std::vec::Vec<crate::model::HttpHeader>,

    /// The HTTP request body. If the body is not expected, it should be empty.
    pub body: ::bytes::Bytes,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl HttpRequest {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [method][crate::model::HttpRequest::method].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpRequest;
    /// let x = HttpRequest::new().set_method("example");
    /// ```
    pub fn set_method<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.method = v.into();
        self
    }

    /// Sets the value of [uri][crate::model::HttpRequest::uri].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpRequest;
    /// let x = HttpRequest::new().set_uri("example");
    /// ```
    pub fn set_uri<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.uri = v.into();
        self
    }

    /// Sets the value of [headers][crate::model::HttpRequest::headers].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpRequest;
    /// use google_cloud_rpc::model::HttpHeader;
    /// let x = HttpRequest::new()
    ///     .set_headers([
    ///         HttpHeader::default()/* use setters */,
    ///         HttpHeader::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_headers<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::model::HttpHeader>,
    {
        use std::iter::Iterator;
        self.headers = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [body][crate::model::HttpRequest::body].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpRequest;
    /// let x = HttpRequest::new().set_body(bytes::Bytes::from_static(b"example"));
    /// ```
    pub fn set_body<T: std::convert::Into<::bytes::Bytes>>(mut self, v: T) -> Self {
        self.body = v.into();
        self
    }
}

impl wkt::message::Message for HttpRequest {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.HttpRequest"
    }
}

/// Represents an HTTP response.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct HttpResponse {
    /// The HTTP status code, such as 200 or 404.
    pub status: i32,

    /// The HTTP reason phrase, such as "OK" or "Not Found".
    pub reason: std::string::String,

    /// The HTTP response headers. The ordering of the headers is significant.
    /// Multiple headers with the same key may present for the response.
    pub headers: std::vec::Vec<crate::model::HttpHeader>,

    /// The HTTP response body. If the body is not expected, it should be empty.
    pub body: ::bytes::Bytes,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl HttpResponse {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [status][crate::model::HttpResponse::status].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpResponse;
    /// let x = HttpResponse::new().set_status(42);
    /// ```
    pub fn set_status<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.status = v.into();
        self
    }

    /// Sets the value of [reason][crate::model::HttpResponse::reason].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpResponse;
    /// let x = HttpResponse::new().set_reason("example");
    /// ```
    pub fn set_reason<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.reason = v.into();
        self
    }

    /// Sets the value of [headers][crate::model::HttpResponse::headers].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpResponse;
    /// use google_cloud_rpc::model::HttpHeader;
    /// let x = HttpResponse::new()
    ///     .set_headers([
    ///         HttpHeader::default()/* use setters */,
    ///         HttpHeader::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_headers<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::model::HttpHeader>,
    {
        use std::iter::Iterator;
        self.headers = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [body][crate::model::HttpResponse::body].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpResponse;
    /// let x = HttpResponse::new().set_body(bytes::Bytes::from_static(b"example"));
    /// ```
    pub fn set_body<T: std::convert::Into<::bytes::Bytes>>(mut self, v: T) -> Self {
        self.body = v.into();
        self
    }
}

impl wkt::message::Message for HttpResponse {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.HttpResponse"
    }
}

/// Represents an HTTP header.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct HttpHeader {
    /// The HTTP header key. It is case insensitive.
    pub key: std::string::String,

    /// The HTTP header value.
    pub value: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl HttpHeader {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [key][crate::model::HttpHeader::key].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpHeader;
    /// let x = HttpHeader::new().set_key("example");
    /// ```
    pub fn set_key<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.key = v.into();
        self
    }

    /// Sets the value of [value][crate::model::HttpHeader::value].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::HttpHeader;
    /// let x = HttpHeader::new().set_value("example");
    /// ```
    pub fn set_value<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.value = v.into();
        self
    }
}

impl wkt::message::Message for HttpHeader {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.HttpHeader"
    }
}

/// The `Status` type defines a logical error model that is suitable for
/// different programming environments, including REST APIs and RPC APIs. It is
/// used by [gRPC](https://github.com/grpc). Each `Status` message contains
/// three pieces of data: error code, error message, and error details.
///
/// You can find out more about this error model and how to work with it in the
/// [API Design Guide](https://cloud.google.com/apis/design/errors).
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Status {
    /// The status code, which should be an enum value of
    /// [google.rpc.Code][google.rpc.Code].
    ///
    /// [google.rpc.Code]: crate::model::Code
    pub code: i32,

    /// A developer-facing error message, which should be in English. Any
    /// user-facing error message should be localized and sent in the
    /// [google.rpc.Status.details][google.rpc.Status.details] field, or localized
    /// by the client.
    ///
    /// [google.rpc.Status.details]: crate::model::Status::details
    pub message: std::string::String,

    /// A list of messages that carry the error details.  There is a common set of
    /// message types for APIs to use.
    pub details: std::vec::Vec<wkt::Any>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Status {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [code][crate::model::Status::code].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::Status;
    /// let x = Status::new().set_code(42);
    /// ```
    pub fn set_code<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.code = v.into();
        self
    }

    /// Sets the value of [message][crate::model::Status::message].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::Status;
    /// let x = Status::new().set_message("example");
    /// ```
    pub fn set_message<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.message = v.into();
        self
    }

    /// Sets the value of [details][crate::model::Status::details].
    ///
    /// # Example
    /// ```ignore,no_run
    /// # use google_cloud_rpc::model::Status;
    /// use wkt::Any;
    /// let x = Status::new()
    ///     .set_details([
    ///         Any::default()/* use setters */,
    ///         Any::default()/* use (different) setters */,
    ///     ]);
    /// ```
    pub fn set_details<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<wkt::Any>,
    {
        use std::iter::Iterator;
        self.details = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for Status {
    fn typename() -> &'static str {
        "type.googleapis.com/google.rpc.Status"
    }
}

/// The canonical error codes for gRPC APIs.
///
/// Sometimes multiple error codes may apply.  Services should return
/// the most specific error code that applies.  For example, prefer
/// `OUT_OF_RANGE` over `FAILED_PRECONDITION` if both codes apply.
/// Similarly prefer `NOT_FOUND` or `ALREADY_EXISTS` over `FAILED_PRECONDITION`.
///
/// # Working with unknown values
///
/// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
/// additional enum variants at any time. Adding new variants is not considered
/// a breaking change. Applications should write their code in anticipation of:
///
/// - New values appearing in future releases of the client library, **and**
/// - New values received dynamically, without application changes.
///
/// Please consult the [Working with enums] section in the user guide for some
/// guidelines.
///
/// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
#[derive(Clone, Debug, PartialEq)]
#[non_exhaustive]
pub enum Code {
    /// Not an error; returned on success.
    ///
    /// HTTP Mapping: 200 OK
    Ok,
    /// The operation was cancelled, typically by the caller.
    ///
    /// HTTP Mapping: 499 Client Closed Request
    Cancelled,
    /// Unknown error.  For example, this error may be returned when
    /// a `Status` value received from another address space belongs to
    /// an error space that is not known in this address space.  Also
    /// errors raised by APIs that do not return enough error information
    /// may be converted to this error.
    ///
    /// HTTP Mapping: 500 Internal Server Error
    Unknown,
    /// The client specified an invalid argument.  Note that this differs
    /// from `FAILED_PRECONDITION`.  `INVALID_ARGUMENT` indicates arguments
    /// that are problematic regardless of the state of the system
    /// (e.g., a malformed file name).
    ///
    /// HTTP Mapping: 400 Bad Request
    InvalidArgument,
    /// The deadline expired before the operation could complete. For operations
    /// that change the state of the system, this error may be returned
    /// even if the operation has completed successfully.  For example, a
    /// successful response from a server could have been delayed long
    /// enough for the deadline to expire.
    ///
    /// HTTP Mapping: 504 Gateway Timeout
    DeadlineExceeded,
    /// Some requested entity (e.g., file or directory) was not found.
    ///
    /// Note to server developers: if a request is denied for an entire class
    /// of users, such as gradual feature rollout or undocumented allowlist,
    /// `NOT_FOUND` may be used. If a request is denied for some users within
    /// a class of users, such as user-based access control, `PERMISSION_DENIED`
    /// must be used.
    ///
    /// HTTP Mapping: 404 Not Found
    NotFound,
    /// The entity that a client attempted to create (e.g., file or directory)
    /// already exists.
    ///
    /// HTTP Mapping: 409 Conflict
    AlreadyExists,
    /// The caller does not have permission to execute the specified
    /// operation. `PERMISSION_DENIED` must not be used for rejections
    /// caused by exhausting some resource (use `RESOURCE_EXHAUSTED`
    /// instead for those errors). `PERMISSION_DENIED` must not be
    /// used if the caller can not be identified (use `UNAUTHENTICATED`
    /// instead for those errors). This error code does not imply the
    /// request is valid or the requested entity exists or satisfies
    /// other pre-conditions.
    ///
    /// HTTP Mapping: 403 Forbidden
    PermissionDenied,
    /// The request does not have valid authentication credentials for the
    /// operation.
    ///
    /// HTTP Mapping: 401 Unauthorized
    Unauthenticated,
    /// Some resource has been exhausted, perhaps a per-user quota, or
    /// perhaps the entire file system is out of space.
    ///
    /// HTTP Mapping: 429 Too Many Requests
    ResourceExhausted,
    /// The operation was rejected because the system is not in a state
    /// required for the operation's execution.  For example, the directory
    /// to be deleted is non-empty, an rmdir operation is applied to
    /// a non-directory, etc.
    ///
    /// Service implementors can use the following guidelines to decide
    /// between `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`:
    /// (a) Use `UNAVAILABLE` if the client can retry just the failing call.
    /// (b) Use `ABORTED` if the client should retry at a higher level. For
    /// example, when a client-specified test-and-set fails, indicating the
    /// client should restart a read-modify-write sequence.
    /// (c) Use `FAILED_PRECONDITION` if the client should not retry until
    /// the system state has been explicitly fixed. For example, if an "rmdir"
    /// fails because the directory is non-empty, `FAILED_PRECONDITION`
    /// should be returned since the client should not retry unless
    /// the files are deleted from the directory.
    ///
    /// HTTP Mapping: 400 Bad Request
    FailedPrecondition,
    /// The operation was aborted, typically due to a concurrency issue such as
    /// a sequencer check failure or transaction abort.
    ///
    /// See the guidelines above for deciding between `FAILED_PRECONDITION`,
    /// `ABORTED`, and `UNAVAILABLE`.
    ///
    /// HTTP Mapping: 409 Conflict
    Aborted,
    /// The operation was attempted past the valid range.  E.g., seeking or
    /// reading past end-of-file.
    ///
    /// Unlike `INVALID_ARGUMENT`, this error indicates a problem that may
    /// be fixed if the system state changes. For example, a 32-bit file
    /// system will generate `INVALID_ARGUMENT` if asked to read at an
    /// offset that is not in the range [0,2^32-1], but it will generate
    /// `OUT_OF_RANGE` if asked to read from an offset past the current
    /// file size.
    ///
    /// There is a fair bit of overlap between `FAILED_PRECONDITION` and
    /// `OUT_OF_RANGE`.  We recommend using `OUT_OF_RANGE` (the more specific
    /// error) when it applies so that callers who are iterating through
    /// a space can easily look for an `OUT_OF_RANGE` error to detect when
    /// they are done.
    ///
    /// HTTP Mapping: 400 Bad Request
    OutOfRange,
    /// The operation is not implemented or is not supported/enabled in this
    /// service.
    ///
    /// HTTP Mapping: 501 Not Implemented
    Unimplemented,
    /// Internal errors.  This means that some invariants expected by the
    /// underlying system have been broken.  This error code is reserved
    /// for serious errors.
    ///
    /// HTTP Mapping: 500 Internal Server Error
    Internal,
    /// The service is currently unavailable.  This is most likely a
    /// transient condition, which can be corrected by retrying with
    /// a backoff. Note that it is not always safe to retry
    /// non-idempotent operations.
    ///
    /// See the guidelines above for deciding between `FAILED_PRECONDITION`,
    /// `ABORTED`, and `UNAVAILABLE`.
    ///
    /// HTTP Mapping: 503 Service Unavailable
    Unavailable,
    /// Unrecoverable data loss or corruption.
    ///
    /// HTTP Mapping: 500 Internal Server Error
    DataLoss,
    /// If set, the enum was initialized with an unknown value.
    ///
    /// Applications can examine the value using [Code::value] or
    /// [Code::name].
    UnknownValue(code::UnknownValue),
}

#[doc(hidden)]
pub mod code {
    #[allow(unused_imports)]
    use super::*;
    #[derive(Clone, Debug, PartialEq)]
    pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
}

impl Code {
    /// Gets the enum value.
    ///
    /// Returns `None` if the enum contains an unknown value deserialized from
    /// the string representation of enums.
    pub fn value(&self) -> std::option::Option<i32> {
        match self {
            Self::Ok => std::option::Option::Some(0),
            Self::Cancelled => std::option::Option::Some(1),
            Self::Unknown => std::option::Option::Some(2),
            Self::InvalidArgument => std::option::Option::Some(3),
            Self::DeadlineExceeded => std::option::Option::Some(4),
            Self::NotFound => std::option::Option::Some(5),
            Self::AlreadyExists => std::option::Option::Some(6),
            Self::PermissionDenied => std::option::Option::Some(7),
            Self::Unauthenticated => std::option::Option::Some(16),
            Self::ResourceExhausted => std::option::Option::Some(8),
            Self::FailedPrecondition => std::option::Option::Some(9),
            Self::Aborted => std::option::Option::Some(10),
            Self::OutOfRange => std::option::Option::Some(11),
            Self::Unimplemented => std::option::Option::Some(12),
            Self::Internal => std::option::Option::Some(13),
            Self::Unavailable => std::option::Option::Some(14),
            Self::DataLoss => std::option::Option::Some(15),
            Self::UnknownValue(u) => u.0.value(),
        }
    }

    /// Gets the enum value as a string.
    ///
    /// Returns `None` if the enum contains an unknown value deserialized from
    /// the integer representation of enums.
    pub fn name(&self) -> std::option::Option<&str> {
        match self {
            Self::Ok => std::option::Option::Some("OK"),
            Self::Cancelled => std::option::Option::Some("CANCELLED"),
            Self::Unknown => std::option::Option::Some("UNKNOWN"),
            Self::InvalidArgument => std::option::Option::Some("INVALID_ARGUMENT"),
            Self::DeadlineExceeded => std::option::Option::Some("DEADLINE_EXCEEDED"),
            Self::NotFound => std::option::Option::Some("NOT_FOUND"),
            Self::AlreadyExists => std::option::Option::Some("ALREADY_EXISTS"),
            Self::PermissionDenied => std::option::Option::Some("PERMISSION_DENIED"),
            Self::Unauthenticated => std::option::Option::Some("UNAUTHENTICATED"),
            Self::ResourceExhausted => std::option::Option::Some("RESOURCE_EXHAUSTED"),
            Self::FailedPrecondition => std::option::Option::Some("FAILED_PRECONDITION"),
            Self::Aborted => std::option::Option::Some("ABORTED"),
            Self::OutOfRange => std::option::Option::Some("OUT_OF_RANGE"),
            Self::Unimplemented => std::option::Option::Some("UNIMPLEMENTED"),
            Self::Internal => std::option::Option::Some("INTERNAL"),
            Self::Unavailable => std::option::Option::Some("UNAVAILABLE"),
            Self::DataLoss => std::option::Option::Some("DATA_LOSS"),
            Self::UnknownValue(u) => u.0.name(),
        }
    }
}

impl std::default::Default for Code {
    fn default() -> Self {
        use std::convert::From;
        Self::from(0)
    }
}

impl std::fmt::Display for Code {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
        wkt::internal::display_enum(f, self.name(), self.value())
    }
}

impl std::convert::From<i32> for Code {
    fn from(value: i32) -> Self {
        match value {
            0 => Self::Ok,
            1 => Self::Cancelled,
            2 => Self::Unknown,
            3 => Self::InvalidArgument,
            4 => Self::DeadlineExceeded,
            5 => Self::NotFound,
            6 => Self::AlreadyExists,
            7 => Self::PermissionDenied,
            8 => Self::ResourceExhausted,
            9 => Self::FailedPrecondition,
            10 => Self::Aborted,
            11 => Self::OutOfRange,
            12 => Self::Unimplemented,
            13 => Self::Internal,
            14 => Self::Unavailable,
            15 => Self::DataLoss,
            16 => Self::Unauthenticated,
            _ => Self::UnknownValue(code::UnknownValue(
                wkt::internal::UnknownEnumValue::Integer(value),
            )),
        }
    }
}

impl std::convert::From<&str> for Code {
    fn from(value: &str) -> Self {
        use std::string::ToString;
        match value {
            "OK" => Self::Ok,
            "CANCELLED" => Self::Cancelled,
            "UNKNOWN" => Self::Unknown,
            "INVALID_ARGUMENT" => Self::InvalidArgument,
            "DEADLINE_EXCEEDED" => Self::DeadlineExceeded,
            "NOT_FOUND" => Self::NotFound,
            "ALREADY_EXISTS" => Self::AlreadyExists,
            "PERMISSION_DENIED" => Self::PermissionDenied,
            "UNAUTHENTICATED" => Self::Unauthenticated,
            "RESOURCE_EXHAUSTED" => Self::ResourceExhausted,
            "FAILED_PRECONDITION" => Self::FailedPrecondition,
            "ABORTED" => Self::Aborted,
            "OUT_OF_RANGE" => Self::OutOfRange,
            "UNIMPLEMENTED" => Self::Unimplemented,
            "INTERNAL" => Self::Internal,
            "UNAVAILABLE" => Self::Unavailable,
            "DATA_LOSS" => Self::DataLoss,
            _ => Self::UnknownValue(code::UnknownValue(wkt::internal::UnknownEnumValue::String(
                value.to_string(),
            ))),
        }
    }
}

impl serde::ser::Serialize for Code {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        match self {
            Self::Ok => serializer.serialize_i32(0),
            Self::Cancelled => serializer.serialize_i32(1),
            Self::Unknown => serializer.serialize_i32(2),
            Self::InvalidArgument => serializer.serialize_i32(3),
            Self::DeadlineExceeded => serializer.serialize_i32(4),
            Self::NotFound => serializer.serialize_i32(5),
            Self::AlreadyExists => serializer.serialize_i32(6),
            Self::PermissionDenied => serializer.serialize_i32(7),
            Self::Unauthenticated => serializer.serialize_i32(16),
            Self::ResourceExhausted => serializer.serialize_i32(8),
            Self::FailedPrecondition => serializer.serialize_i32(9),
            Self::Aborted => serializer.serialize_i32(10),
            Self::OutOfRange => serializer.serialize_i32(11),
            Self::Unimplemented => serializer.serialize_i32(12),
            Self::Internal => serializer.serialize_i32(13),
            Self::Unavailable => serializer.serialize_i32(14),
            Self::DataLoss => serializer.serialize_i32(15),
            Self::UnknownValue(u) => u.0.serialize(serializer),
        }
    }
}

impl<'de> serde::de::Deserialize<'de> for Code {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        deserializer.deserialize_any(wkt::internal::EnumVisitor::<Code>::new(".google.rpc.Code"))
    }
}
