// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies website configuration parameters for an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct WebsiteConfiguration {
    /// <p>The name of the error document for the website.</p>
    pub error_document: ::std::option::Option<crate::types::ErrorDocument>,
    /// <p>The name of the index document for the website.</p>
    pub index_document: ::std::option::Option<crate::types::IndexDocument>,
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p><important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub redirect_all_requests_to: ::std::option::Option<crate::types::RedirectAllRequestsTo>,
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub routing_rules: ::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>>,
}
impl WebsiteConfiguration {
    /// <p>The name of the error document for the website.</p>
    pub fn error_document(&self) -> ::std::option::Option<&crate::types::ErrorDocument> {
        self.error_document.as_ref()
    }
    /// <p>The name of the index document for the website.</p>
    pub fn index_document(&self) -> ::std::option::Option<&crate::types::IndexDocument> {
        self.index_document.as_ref()
    }
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p><important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub fn redirect_all_requests_to(&self) -> ::std::option::Option<&crate::types::RedirectAllRequestsTo> {
        self.redirect_all_requests_to.as_ref()
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.routing_rules.is_none()`.
    pub fn routing_rules(&self) -> &[crate::types::RoutingRule] {
        self.routing_rules.as_deref().unwrap_or_default()
    }
}
impl WebsiteConfiguration {
    /// Creates a new builder-style object to manufacture [`WebsiteConfiguration`](crate::types::WebsiteConfiguration).
    pub fn builder() -> crate::types::builders::WebsiteConfigurationBuilder {
        crate::types::builders::WebsiteConfigurationBuilder::default()
    }
}

/// A builder for [`WebsiteConfiguration`](crate::types::WebsiteConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct WebsiteConfigurationBuilder {
    pub(crate) error_document: ::std::option::Option<crate::types::ErrorDocument>,
    pub(crate) index_document: ::std::option::Option<crate::types::IndexDocument>,
    pub(crate) redirect_all_requests_to: ::std::option::Option<crate::types::RedirectAllRequestsTo>,
    pub(crate) routing_rules: ::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>>,
}
impl WebsiteConfigurationBuilder {
    /// <p>The name of the error document for the website.</p>
    pub fn error_document(mut self, input: crate::types::ErrorDocument) -> Self {
        self.error_document = ::std::option::Option::Some(input);
        self
    }
    /// <p>The name of the error document for the website.</p>
    pub fn set_error_document(mut self, input: ::std::option::Option<crate::types::ErrorDocument>) -> Self {
        self.error_document = input;
        self
    }
    /// <p>The name of the error document for the website.</p>
    pub fn get_error_document(&self) -> &::std::option::Option<crate::types::ErrorDocument> {
        &self.error_document
    }
    /// <p>The name of the index document for the website.</p>
    pub fn index_document(mut self, input: crate::types::IndexDocument) -> Self {
        self.index_document = ::std::option::Option::Some(input);
        self
    }
    /// <p>The name of the index document for the website.</p>
    pub fn set_index_document(mut self, input: ::std::option::Option<crate::types::IndexDocument>) -> Self {
        self.index_document = input;
        self
    }
    /// <p>The name of the index document for the website.</p>
    pub fn get_index_document(&self) -> &::std::option::Option<crate::types::IndexDocument> {
        &self.index_document
    }
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p><important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub fn redirect_all_requests_to(mut self, input: crate::types::RedirectAllRequestsTo) -> Self {
        self.redirect_all_requests_to = ::std::option::Option::Some(input);
        self
    }
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p><important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub fn set_redirect_all_requests_to(mut self, input: ::std::option::Option<crate::types::RedirectAllRequestsTo>) -> Self {
        self.redirect_all_requests_to = input;
        self
    }
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p><important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub fn get_redirect_all_requests_to(&self) -> &::std::option::Option<crate::types::RedirectAllRequestsTo> {
        &self.redirect_all_requests_to
    }
    /// Appends an item to `routing_rules`.
    ///
    /// To override the contents of this collection use [`set_routing_rules`](Self::set_routing_rules).
    ///
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn routing_rules(mut self, input: crate::types::RoutingRule) -> Self {
        let mut v = self.routing_rules.unwrap_or_default();
        v.push(input);
        self.routing_rules = ::std::option::Option::Some(v);
        self
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn set_routing_rules(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>>) -> Self {
        self.routing_rules = input;
        self
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn get_routing_rules(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::RoutingRule>> {
        &self.routing_rules
    }
    /// Consumes the builder and constructs a [`WebsiteConfiguration`](crate::types::WebsiteConfiguration).
    pub fn build(self) -> crate::types::WebsiteConfiguration {
        crate::types::WebsiteConfiguration {
            error_document: self.error_document,
            index_document: self.index_document,
            redirect_all_requests_to: self.redirect_all_requests_to,
            routing_rules: self.routing_rules,
        }
    }
}
