;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; REQUIRES: regkeys
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=ForceOCLSIMDWidth=16 --regkey=LS_enableLoadSplitting=1 --regkey=LS_onlyStrided=0 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=0 %s | FileCheck %s --check-prefix=MINSPLIT
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=ForceOCLSIMDWidth=16 --regkey=LS_enableLoadSplitting=1 --regkey=LS_onlyStrided=0 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=8 %s | FileCheck %s --check-prefix=SPLIT8

declare spir_func <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)
declare spir_func <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)
declare spir_func <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)
declare spir_func <32 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v32i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)

declare spir_func void @fun_v2fl(<2 x float>)
declare spir_func void @fun_v4fl(<4 x float>)
declare spir_func void @fun_v8fl(<8 x float>)

declare spir_func void @fun_v2i32(<2 x i32>)
declare spir_func void @fun_v4i32(<4 x i32>)
declare spir_func void @fun_v8i32(<8 x i32>)
declare spir_func void @fun_v16i32(<16 x i32>)

declare spir_func void @fun_v2i16(<2 x i16>)
declare spir_func void @fun_v4i16(<4 x i16>)
declare spir_func void @fun_v8i16(<8 x i16>)

define spir_kernel void @test_basic_splits_2(i64 %ptr) {
; MINSPLIT-LABEL: @test_basic_splits_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_basic_splits_2(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec1a = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1a.1 = shufflevector <16 x i16> %vec1a, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick1a.2 = shufflevector <16 x i16> %vec1a, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  call void @fun_v8i16(<8 x i16> %pick1a.1)
  call void @fun_v8i16(<8 x i16> %pick1a.2)
  ret void
}

define spir_kernel void @test_basic_splits_3(i64 %ptr) {
; MINSPLIT-LABEL: @test_basic_splits_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_basic_splits_3(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick3 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick2 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick4 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick1)
  call void @fun_v4i16(<4 x i16> %pick2)
  call void @fun_v4i16(<4 x i16> %pick3)
  call void @fun_v4i16(<4 x i16> %pick4)
  ret void
}

define spir_kernel void @test_basic_block_splits_2(i64 %ptr) {
; MINSPLIT-LABEL: @test_basic_block_splits_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 16, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_basic_block_splits_2(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 16, i32 0, i32 16, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec1a = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick1a.1 = shufflevector <16 x i16> %vec1a, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick1a.2 = shufflevector <16 x i16> %vec1a, <16 x i16> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  call void @fun_v8i16(<8 x i16> %pick1a.1)
  call void @fun_v8i16(<8 x i16> %pick1a.2)
  ret void
}

define spir_kernel void @test_basic_block_splits_3(i64 %ptr) {
; MINSPLIT-LABEL: @test_basic_block_splits_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 4, i32 2, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 16, i32 16, i32 4, i32 2, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_basic_block_splits_3(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 16, i32 16, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec1b = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick1b.1 = shufflevector <16 x i16> %vec1b, <16 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11>
  %pick1b.2 = shufflevector <16 x i16> %vec1b, <16 x i16> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15>
  call void @fun_v8i16(<8 x i16> %pick1b.1)
  call void @fun_v8i16(<8 x i16> %pick1b.2)
  ret void
}

define spir_kernel void @test_basic_block_splits_4(i64 %ptr) {
; MINSPLIT-LABEL: @test_basic_block_splits_4(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 16, i32 0, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 16, i32 4, i32 16, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_basic_block_splits_4(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 16, i32 16, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 16, i32 16, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick1 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick3 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick2 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick4 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick1)
  call void @fun_v4i16(<4 x i16> %pick2)
  call void @fun_v4i16(<4 x i16> %pick3)
  call void @fun_v4i16(<4 x i16> %pick4)
  ret void
}

define spir_kernel void @test_transposed_1(i64 %ptr) {
; MINSPLIT-LABEL: @test_transposed_1(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 0, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_transposed_1(
; SPLIT8-NEXT:    [[VEC1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK1_1:%.*]] = shufflevector <8 x i32> [[VEC1]], <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK1_2:%.*]] = shufflevector <8 x i32> [[VEC1]], <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_1]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_2]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
  %pick1.1 = shufflevector <8 x i32> %vec1, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick1.2 = shufflevector <8 x i32> %vec1, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  call void @fun_v4i32(<4 x i32> %pick1.1)
  call void @fun_v4i32(<4 x i32> %pick1.2)
  ret void
}

define spir_kernel void @test_transposed_2(i64 %ptr) {
; MINSPLIT-LABEL: @test_transposed_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 2, i32 3, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 6, i32 3, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_transposed_2(
; SPLIT8-NEXT:    [[VEC3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 2, i32 3, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK3_1:%.*]] = shufflevector <8 x i32> [[VEC3]], <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK3_2:%.*]] = shufflevector <8 x i32> [[VEC3]], <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK3_1]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK3_2]])
; SPLIT8-NEXT:    ret void
;
  %vec3 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 63, i32 63, i32 63, i32 2, i32 3, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
  %pick3.1 = shufflevector <8 x i32> %vec3, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick3.2 = shufflevector <8 x i32> %vec3, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  call void @fun_v4i32(<4 x i32> %pick3.1)
  call void @fun_v4i32(<4 x i32> %pick3.2)
  ret void
}

define spir_kernel void @test_transposed_3(i64 %ptr) {
; MINSPLIT-LABEL: @test_transposed_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 31, i32 7, i32 63, i32 3, i32 2, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 31, i32 7, i32 63, i32 7, i32 2, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_transposed_3(
; SPLIT8-NEXT:    [[VEC4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 31, i32 7, i32 63, i32 3, i32 2, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK4_1:%.*]] = shufflevector <8 x i32> [[VEC4]], <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK4_2:%.*]] = shufflevector <8 x i32> [[VEC4]], <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK4_1]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK4_2]])
; SPLIT8-NEXT:    ret void
;
  %vec4 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 31, i32 7, i32 63, i32 3, i32 2, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
  %pick4.1 = shufflevector <8 x i32> %vec4, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick4.2 = shufflevector <8 x i32> %vec4, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  call void @fun_v4i32(<4 x i32> %pick4.1)
  call void @fun_v4i32(<4 x i32> %pick4.2)
  ret void
}

define spir_kernel void @test_transposed_4(i64 %ptr) {
; MINSPLIT-LABEL: @test_transposed_4(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 63, i32 7, i32 31, i32 3, i32 2, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 63, i32 7, i32 31, i32 7, i32 2, i32 32, i32 4, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_transposed_4(
; SPLIT8-NEXT:    [[VEC5:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 7, i32 31, i32 3, i32 2, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK5_1:%.*]] = shufflevector <8 x i32> [[VEC5]], <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK5_2:%.*]] = shufflevector <8 x i32> [[VEC5]], <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK5_1]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK5_2]])
; SPLIT8-NEXT:    ret void
;
  %vec5 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 63, i32 7, i32 31, i32 3, i32 2, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
  %pick5.1 = shufflevector <8 x i32> %vec5, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick5.2 = shufflevector <8 x i32> %vec5, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  call void @fun_v4i32(<4 x i32> %pick5.1)
  call void @fun_v4i32(<4 x i32> %pick5.2)
  ret void
}

define spir_kernel void @test_squeezed_1(i64 %ptr) {
; MINSPLIT-LABEL: @test_squeezed_1(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 4, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 8, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 12, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_squeezed_1(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 32, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 8, i32 8, i32 32, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 32, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1.1 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick1.2 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick1.3 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick1.4 = shufflevector <16 x i16> %vec1, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick1.1)
  call void @fun_v4i16(<4 x i16> %pick1.2)
  call void @fun_v4i16(<4 x i16> %pick1.3)
  call void @fun_v4i16(<4 x i16> %pick1.4)
  ret void
}

define spir_kernel void @test_squeezed_2(i64 %ptr) {
; MINSPLIT-LABEL: @test_squeezed_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 4, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 32, i32 0, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 32, i32 4, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_squeezed_2(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 32, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 4, i32 8, i32 32, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec2 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 32, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick2.1 = shufflevector <16 x i16> %vec2, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick2.2 = shufflevector <16 x i16> %vec2, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick2.3 = shufflevector <16 x i16> %vec2, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick2.4 = shufflevector <16 x i16> %vec2, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick2.1)
  call void @fun_v4i16(<4 x i16> %pick2.2)
  call void @fun_v4i16(<4 x i16> %pick2.3)
  call void @fun_v4i16(<4 x i16> %pick2.4)
  ret void
}

define spir_kernel void @test_squeezed_3(i64 %ptr) {
; MINSPLIT-LABEL: @test_squeezed_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 10, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 14, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 18, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_squeezed_3(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 14, i32 8, i32 32, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec3 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick3.1 = shufflevector <16 x i16> %vec3, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick3.2 = shufflevector <16 x i16> %vec3, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick3.3 = shufflevector <16 x i16> %vec3, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick3.4 = shufflevector <16 x i16> %vec3, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick3.1)
  call void @fun_v4i16(<4 x i16> %pick3.2)
  call void @fun_v4i16(<4 x i16> %pick3.3)
  call void @fun_v4i16(<4 x i16> %pick3.4)
  ret void
}

define spir_kernel void @test_squeezed_4(i64 %ptr) {
; MINSPLIT-LABEL: @test_squeezed_4(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 10, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 36, i32 6, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 36, i32 10, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_squeezed_4(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 10, i32 8, i32 32, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec4 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick4.1 = shufflevector <16 x i16> %vec4, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick4.2 = shufflevector <16 x i16> %vec4, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick4.3 = shufflevector <16 x i16> %vec4, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick4.4 = shufflevector <16 x i16> %vec4, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick4.1)
  call void @fun_v4i16(<4 x i16> %pick4.2)
  call void @fun_v4i16(<4 x i16> %pick4.3)
  call void @fun_v4i16(<4 x i16> %pick4.4)
  ret void
}

define spir_kernel void @test_squeezed_5(i64 %ptr) {
; MINSPLIT-LABEL: @test_squeezed_5(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 2, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 36, i32 2, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v4i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 36, i32 6, i32 8, i32 32, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_squeezed_5(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 2, i32 8, i32 32, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i16> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i16> undef, i16 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i16> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i16> [[TMP3]], i16 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i16> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i16> [[TMP5]], i16 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i16> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i16> [[TMP7]], i16 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i16> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i16> undef, i16 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i16> [[TMP11]], i16 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i16> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i16> [[TMP13]], i16 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i16> [[TMP15]], i16 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v8i16(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 4, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i16> undef, i16 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i16> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i16> [[TMP20]], i16 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i16> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i16> [[TMP22]], i16 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i16> [[TMP24]], i16 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i16> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i16> undef, i16 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i16> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i16> [[TMP28]], i16 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i16> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i16> [[TMP30]], i16 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i16> [[TMP32]], i16 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec5 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 63, i32 63, i32 63, i32 4, i32 2, i32 8, i32 32, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick5.1 = shufflevector <16 x i16> %vec5, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick5.2 = shufflevector <16 x i16> %vec5, <16 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick5.3 = shufflevector <16 x i16> %vec5, <16 x i16> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick5.4 = shufflevector <16 x i16> %vec5, <16 x i16> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i16(<4 x i16> %pick5.1)
  call void @fun_v4i16(<4 x i16> %pick5.2)
  call void @fun_v4i16(<4 x i16> %pick5.3)
  call void @fun_v4i16(<4 x i16> %pick5.4)
  ret void
}

define spir_kernel void @test_squeezed_6(i64 %ptr) {
; MINSPLIT-LABEL: @test_squeezed_6(
; MINSPLIT-NEXT:    [[VEC6:%.*]] = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 8, i32 2, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[PICK6_1:%.*]] = shufflevector <16 x i16> [[VEC6]], <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; MINSPLIT-NEXT:    [[PICK6_2:%.*]] = shufflevector <16 x i16> [[VEC6]], <16 x i16> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; MINSPLIT-NEXT:    call void @fun_v4i16(<4 x i16> [[PICK6_1]])
; MINSPLIT-NEXT:    call void @fun_v8i16(<8 x i16> [[PICK6_2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_squeezed_6(
; SPLIT8-NEXT:    [[VEC6:%.*]] = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 8, i32 2, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK6_1:%.*]] = shufflevector <16 x i16> [[VEC6]], <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK6_2:%.*]] = shufflevector <16 x i16> [[VEC6]], <16 x i16> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
; SPLIT8-NEXT:    call void @fun_v4i16(<4 x i16> [[PICK6_1]])
; SPLIT8-NEXT:    call void @fun_v8i16(<8 x i16> [[PICK6_2]])
; SPLIT8-NEXT:    ret void
;
  %vec6 = call <16 x i16> @llvm.genx.GenISA.LSC2DBlockRead.v16i16(i64 %ptr, i32 63, i32 63, i32 63, i32 4, i32 6, i32 8, i32 32, i32 8, i32 2, i1 false, i1 false, i32 0)
  %pick6.1 = shufflevector <16 x i16> %vec6, <16 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick6.2 = shufflevector <16 x i16> %vec6, <16 x i16> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  call void @fun_v4i16(<4 x i16> %pick6.1)
  call void @fun_v8i16(<8 x i16> %pick6.2)
  ret void
}

define spir_kernel void @test_vnni_1(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_1(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_1(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
  %pick1.1 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick1.2 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  call void @fun_v8i32(<8 x i32> %pick1.1)
  call void @fun_v8i32(<8 x i32> %pick1.2)
  ret void
}

define spir_kernel void @test_vnni_2(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_2(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP3]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP4]])
; SPLIT8-NEXT:    ret void
;
  %vec2 = call <32 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v32i32(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 32, i32 2, i1 false, i1 true, i32 0)
  %pick2.0 = shufflevector <32 x i32> %vec2, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick2.1 = shufflevector <32 x i32> %vec2, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %pick2.2 = shufflevector <32 x i32> %vec2, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %pick2.3 = shufflevector <32 x i32> %vec2, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  call void @fun_v8i32(<8 x i32> %pick2.0)
  call void @fun_v8i32(<8 x i32> %pick2.1)
  call void @fun_v8i32(<8 x i32> %pick2.2)
  call void @fun_v8i32(<8 x i32> %pick2.3)
  ret void
}

define spir_kernel void @test_vnni_3(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 0, i32 16, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_3(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 0, i32 16, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec2a = call <32 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v32i32(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 32, i32 2, i1 false, i1 true, i32 0)
  %pick2a.1 = shufflevector <32 x i32> %vec2a, <32 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %pick2a.2 = shufflevector <32 x i32> %vec2a, <32 x i32> undef, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  call void @fun_v16i32(<16 x i32> %pick2a.1)
  call void @fun_v16i32(<16 x i32> %pick2a.2)
  ret void
}

define spir_kernel void @test_vnni_4(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_4(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 16, i32 2, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 16, i32 16, i32 16, i32 16, i32 2, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_4(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 16, i32 2, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 0, i32 16, i32 16, i32 16, i32 16, i32 2, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v16i32(<16 x i32> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec2b = call <32 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v32i32(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 16, i32 16, i32 32, i32 2, i1 false, i1 true, i32 0)
  %pick2b.1 = shufflevector <32 x i32> %vec2b, <32 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %pick2b.2 = shufflevector <32 x i32> %vec2b, <32 x i32> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  call void @fun_v16i32(<16 x i32> %pick2b.1)
  call void @fun_v16i32(<16 x i32> %pick2b.2)
  ret void
}

define spir_kernel void @test_vnni_5(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_5(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 32, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 48, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_5(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 16, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 32, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 48, i32 0, i32 8, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP3]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP4]])
; SPLIT8-NEXT:    ret void
;
  %vec3 = call <32 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v32i32(i64 %ptr, i32 63, i32 63, i32 63, i32 0, i32 0, i32 8, i32 16, i32 32, i32 4, i1 false, i1 true, i32 0)
  %pick3.0 = shufflevector <32 x i32> %vec3, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick3.1 = shufflevector <32 x i32> %vec3, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %pick3.2 = shufflevector <32 x i32> %vec3, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %pick3.3 = shufflevector <32 x i32> %vec3, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  call void @fun_v8i32(<8 x i32> %pick3.0)
  call void @fun_v8i32(<8 x i32> %pick3.1)
  call void @fun_v8i32(<8 x i32> %pick3.2)
  call void @fun_v8i32(<8 x i32> %pick3.3)
  ret void
}

define spir_kernel void @test_vnni_6(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_6(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 22, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 20, i32 6, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 20, i32 22, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_6(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 63, i32 63, i32 4, i32 6, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 4, i32 22, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP3:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 20, i32 6, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP4:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 63, i32 63, i32 20, i32 22, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP3]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP4]])
; SPLIT8-NEXT:    ret void
;
  %vec4 = call <32 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v32i32(i64 %ptr, i32 63, i32 63, i32 63, i32 4, i32 6, i32 16, i32 16, i32 32, i32 2, i1 false, i1 true, i32 0)
  %pick4.0 = shufflevector <32 x i32> %vec4, <32 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick4.1 = shufflevector <32 x i32> %vec4, <32 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %pick4.2 = shufflevector <32 x i32> %vec4, <32 x i32> undef, <8 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %pick4.3 = shufflevector <32 x i32> %vec4, <32 x i32> undef, <8 x i32> <i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  call void @fun_v8i32(<8 x i32> %pick4.0)
  call void @fun_v8i32(<8 x i32> %pick4.1)
  call void @fun_v8i32(<8 x i32> %pick4.2)
  call void @fun_v8i32(<8 x i32> %pick4.3)
  ret void
}

define spir_kernel void @test_vnni_7(i64 %ptr) {
; MINSPLIT-LABEL: @test_vnni_7(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 15, i32 7, i32 15, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 15, i32 7, i32 15, i32 0, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @test_vnni_7(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 15, i32 7, i32 15, i32 0, i32 0, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 15, i32 7, i32 15, i32 0, i32 16, i32 16, i32 16, i32 16, i32 1, i1 false, i1 true, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; SPLIT8-NEXT:    ret void
;
  %vec5 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 15, i32 7, i32 15, i32 0, i32 0, i32 16, i32 16, i32 32, i32 1, i1 false, i1 true, i32 0)
  %pick5.1 = shufflevector <16 x i32> %vec5, <16 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick5.2 = shufflevector <16 x i32> %vec5, <16 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  call void @fun_v8i32(<8 x i32> %pick5.1)
  call void @fun_v8i32(<8 x i32> %pick5.2)
  ret void
}

define spir_kernel void @test_transposed_strided(i64 %ptr) {
; MINSPLIT-LABEL: @test_transposed_strided(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 7, i32 31, i32 3, i32 2, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 7, i32 31, i32 3, i32 18, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void

; SPLIT8-LABEL: @test_transposed_strided(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 63, i32 7, i32 31, i32 3, i32 2, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 63, i32 7, i32 31, i32 3, i32 18, i32 32, i32 8, i32 16, i32 1, i1 true, i1 false, i32 0)
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP1]])
; SPLIT8-NEXT:    call void @fun_v8i32(<8 x i32> [[TMP2]])
; SPLIT8-NEXT:    ret void

  %vec5 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 63, i32 7, i32 31, i32 3, i32 2, i32 32, i32 8, i32 32, i32 1, i1 true, i1 false, i32 0)
  %pick5.1 = shufflevector <16 x i32> %vec5, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %pick5.2 = shufflevector <16 x i32> %vec5, <16 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  call void @fun_v8i32(<8 x i32> %pick5.1)
  call void @fun_v8i32(<8 x i32> %pick5.2)
  ret void
}
